/*
 * Decompiled with CFR 0.152.
 */
package latmod.silicio.tile;

import latmod.core.InvUtils;
import latmod.core.util.FastMap;
import latmod.silicio.item.modules.ICBModule;
import latmod.silicio.tile.TileCBCable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraftforge.common.util.ForgeDirection;

public class CircuitBoard
implements IInventory {
    public final TileCBCable cable;
    public final int side;
    public final int sideOpposite;
    public final ForgeDirection sideF;
    public final ForgeDirection sideOppositeF;
    public final ChunkCoordinates sidePos;
    public ItemStack[] items = new ItemStack[12];
    public boolean dropItems = true;
    public long tick = 0L;
    public boolean redstoneOut = false;
    private Boolean prevRedstoneOut = null;

    public CircuitBoard(TileCBCable t, int f) {
        this.cable = t;
        this.side = f;
        this.sideOpposite = Facing.field_71588_a[this.side];
        this.sideF = ForgeDirection.VALID_DIRECTIONS[this.side];
        this.sideOppositeF = this.sideF.getOpposite();
        this.sidePos = new ChunkCoordinates(this.cable.field_145851_c + Facing.field_71586_b[this.side], this.cable.field_145848_d + Facing.field_71587_c[this.side], this.cable.field_145849_e + Facing.field_71585_d[this.side]);
    }

    public void readTileData(NBTTagCompound tag) {
        InvUtils.readItemsFromNBT((ItemStack[])this.items, (NBTTagCompound)tag, (String)"Items");
        this.tick = tag.func_74763_f("Tick");
        this.redstoneOut = tag.func_74767_n("RSOut");
    }

    public void writeTileData(NBTTagCompound tag) {
        if (this.items != null) {
            InvUtils.writeItemsToNBT((ItemStack[])this.items, (NBTTagCompound)tag, (String)"Items");
        }
        tag.func_74772_a("Tick", this.tick);
        tag.func_74757_a("RSOut", this.redstoneOut);
    }

    public ICBModule getModule(int moduleID) {
        if (moduleID < 0 || moduleID >= this.items.length || this.items[moduleID] == null) {
            return null;
        }
        if (this.items[moduleID].func_77973_b() instanceof ICBModule) {
            return (ICBModule)this.items[moduleID].func_77973_b();
        }
        return null;
    }

    public FastMap<Integer, ICBModule> getAllModules() {
        FastMap map = new FastMap();
        for (int i = 0; i < this.items.length; ++i) {
            ICBModule m = this.getModule(i);
            if (map == null) continue;
            map.put((Object)i, (Object)m);
        }
        return map;
    }

    public void preUpdate() {
        this.redstoneOut = false;
    }

    public void postUpdate() {
        if (this.prevRedstoneOut == null || this.prevRedstoneOut != this.redstoneOut) {
            this.prevRedstoneOut = this.redstoneOut;
            this.cable.func_70296_d();
            this.cable.func_145831_w().func_147459_d(this.cable.field_145851_c, this.cable.field_145848_d, this.cable.field_145849_e, this.cable.field_145854_h);
        }
        ++this.tick;
    }

    public TileEntity getFacingTile() {
        TileEntity te = this.cable.func_145831_w().func_147438_o(this.sidePos.field_71574_a, this.sidePos.field_71572_b, this.sidePos.field_71573_c);
        return te == null || te.func_145837_r() ? null : te;
    }

    public Block getFacingBlock() {
        return this.cable.func_145831_w().func_147439_a(this.sidePos.field_71574_a, this.sidePos.field_71572_b, this.sidePos.field_71573_c);
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        return InvUtils.decrStackSize((IInventory)this, (int)slot, (int)amt);
    }

    public ItemStack func_70304_b(int i) {
        return InvUtils.getStackInSlotOnClosing((IInventory)this, (int)i);
    }

    public void func_70299_a(int i, ItemStack is) {
        this.items[i] = is;
    }

    public String func_145825_b() {
        return "Circuit Board";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.cable.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer ep) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return true;
    }
}

