/*
 * Decompiled with CFR 0.152.
 */
package latmod.silicio.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.gui.ButtonLM;
import latmod.core.gui.ContainerEmpty;
import latmod.core.gui.ContainerLM;
import latmod.core.gui.GuiLM;
import latmod.core.gui.TextureCoords;
import latmod.core.mod.LC;
import latmod.silicio.gui.GuiModule;
import latmod.silicio.item.modules.ICBModule;
import latmod.silicio.item.modules.ItemModule;
import latmod.silicio.tile.CBChannel;
import latmod.silicio.tile.CircuitBoard;
import latmod.silicio.tile.TileCBCable;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class GuiSelectChannels
extends GuiLM {
    public static final ResourceLocation thisTex = GuiModule.getTex("selectChannel.png");
    public static final TextureCoords iconSelChannel = new TextureCoords(thisTex, 180, 0);
    public static final TextureCoords iconInput = new TextureCoords(thisTex, 180, 10);
    public static final TextureCoords iconOutput = new TextureCoords(thisTex, 180, 18);
    public static final TextureCoords iconIOPressed = new TextureCoords(thisTex, 180, 26);
    public static final TextureCoords iconChannelEnabled = new TextureCoords(thisTex, 180, 34);
    public static final TextureCoords iconBack = new TextureCoords(thisTex, 166, 2);
    public CircuitBoard board;
    public ICBModule module;
    public int moduleID;
    public ButtonLM buttonBack;
    public ButtonLM[] buttonSelectIO;
    public ButtonLM[] allChannels;
    public int selectedIO = 0;

    public GuiSelectChannels(ContainerEmpty c, int id) {
        super((ContainerLM)c, thisTex);
        this.field_146999_f = 166;
        this.field_147000_g = 98;
        this.board = (CircuitBoard)c.inv;
        this.moduleID = id;
        this.module = this.board.getModule(this.moduleID);
        this.buttonBack = new ButtonLM(this, 166, 2, 14, 18){

            public void onButtonPressed(int b) {
                GuiSelectChannels.this.board.cable.clientOpenGui(TileCBCable.guiData(GuiSelectChannels.this.board.side, 2, GuiSelectChannels.this.moduleID));
                GuiSelectChannels.this.playClickSound();
            }
        };
        this.widgets.add((Object)this.buttonBack);
        this.buttonBack.title = LC.mod.translate("button.back", new Object[0]);
        int chCount = this.module.getChannelCount();
        if (chCount > 16) {
            chCount = 16;
        }
        this.buttonSelectIO = new ButtonLM[chCount];
        for (int i = 0; i < chCount; ++i) {
            this.buttonSelectIO[i] = new ButtonLM(this, 7 + i * 9, 7, 8, 8){

                public void onButtonPressed(int b) {
                    GuiSelectChannels.this.selectedIO = this.customID;
                    GuiSelectChannels.this.playClickSound();
                }
            };
            this.buttonSelectIO[i].customID = i;
            this.buttonSelectIO[i].title = this.module.getChannelName(i);
            this.widgets.add((Object)this.buttonSelectIO[i]);
        }
        this.allChannels = new ButtonLM[this.board.cable.controller().channels.length + 1];
        ButtonLM b = new ButtonLM(this, 151, 7, 8, 8){

            public void onButtonPressed(int b) {
                GuiSelectChannels.this.playClickSound();
                GuiSelectChannels.this.sendSetChannel(this.customID);
            }
        };
        b.customID = -1;
        b.title = CBChannel.NONE.name;
        this.allChannels[this.allChannels.length - 1] = b;
        this.widgets.add((Object)b);
        for (int i = 0; i < this.board.cable.controller().channels.length; ++i) {
            int bx = i % 16;
            int by = i / 16;
            this.allChannels[i] = new ButtonLM(this, 16 + bx * 9, 20 + by * 9, 8, 8){

                public void onButtonPressed(int b) {
                    GuiSelectChannels.this.playClickSound();
                    GuiSelectChannels.this.sendSetChannel(this.customID);
                }
            };
            this.allChannels[i].customID = i;
            this.allChannels[i].title = this.board.cable.controller().channels[i].name;
            this.widgets.add((Object)this.allChannels[i]);
        }
    }

    private void sendSetChannel(int ch) {
        this.board.cable.clientSetChannel(this.board.side, this.moduleID, this.selectedIO, ch);
    }

    public void func_146976_a(float f, int mx, int my) {
        super.func_146976_a(f, mx, my);
        for (int i = 0; i < this.buttonSelectIO.length; ++i) {
            if (this.module.getChannelType(this.buttonSelectIO[i].customID).isInput()) {
                this.buttonSelectIO[i].render((Object)iconInput);
            } else {
                this.buttonSelectIO[i].render((Object)iconOutput);
            }
            if (this.selectedIO != i) continue;
            iconIOPressed.render((GuiLM)this, this.buttonSelectIO[i].posX, this.buttonSelectIO[i].posY, 8, 8);
        }
        for (ButtonLM b : this.allChannels) {
            if (b.customID == ItemModule.getChannelID(this.module, this.board.items[this.moduleID], this.selectedIO)) {
                iconSelChannel.render((GuiLM)this, b.posX - 1, b.posY - 1, 10, 10);
            }
            if (b.customID < 0 || this.board.cable.controller() == null || !this.board.cable.controller().channels[b.customID].isEnabled()) continue;
            iconChannelEnabled.render((GuiLM)this, b.posX, b.posY, 8, 8);
        }
        iconBack.render((GuiLM)this, this.buttonBack.posX, this.buttonBack.posY, this.buttonBack.width, this.buttonBack.height);
    }

    public void func_73863_a(int mx, int my, float f) {
        this.board = ((TileCBCable)this.board.cable.func_145831_w().func_147438_o(this.board.cable.field_145851_c, this.board.cable.field_145848_d, this.board.cable.field_145849_e)).getBoard(this.board.side);
        this.module = (ICBModule)this.board.items[this.moduleID].func_77973_b();
        super.func_73863_a(mx, my, f);
    }
}

