/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.lamp;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.part.lamp.PartLamp;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;

public class PartFixture
extends PartLamp {
    public PartFixture(MinecraftColor color, Boolean inverted) {
        super(color, inverted);
    }

    @Override
    protected String getLampType() {
        return "fixture";
    }

    @Override
    public List<Vec3dCube> getSelectionBoxes() {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        boxes.add(new Vec3dCube(0.125, 0.0, 0.125, 0.875, 0.125, 0.875).rotate(this.getFace(), Vec3d.center));
        boxes.add(new Vec3dCube(0.1875, 0.125, 0.1875, 0.8125, 0.5, 0.8125).expand(0.03125).rotate(this.getFace(), Vec3d.center));
        return boxes;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderLamp(RenderHelper renderer) {
        Vec3dCube vector = new Vec3dCube(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
        IIcon topIcon = IconSupplier.fixtureFootTop;
        IIcon sideIcon = IconSupplier.fixtureFootSide;
        renderer.renderBox(vector, topIcon, topIcon, sideIcon, sideIcon, sideIcon, sideIcon);
        vector = new Vec3dCube(0.1875, 0.125, 0.1875, 0.8125, 0.5, 0.8125);
        if (this.inverted ? (this.power & 0xFF) == 255 : this.power == 0) {
            sideIcon = IconSupplier.fixtureLampSideOff;
            topIcon = IconSupplier.fixtureLampTopOff;
        } else {
            sideIcon = IconSupplier.fixtureLampSideOn;
            topIcon = IconSupplier.fixtureLampTopOn;
        }
        renderer.setColor(this.color.getHex());
        renderer.renderBox(vector, topIcon, topIcon, sideIcon, sideIcon, sideIcon, sideIcon);
        renderer.setColor(0xFFFFFF);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderGlow(int pass) {
        Vec3dCube vector = new Vec3dCube(0.1875, 0.125, 0.1875, 0.8125, 0.5, 0.8125).rotate(this.getFace(), Vec3d.center);
        double r = (double)((this.color.getHex() & 0xFF0000) >> 16) / 256.0;
        double g = (double)((this.color.getHex() & 0xFF00) >> 8) / 256.0;
        double b = (double)(this.color.getHex() & 0xFF) / 256.0;
        if (pass == 1) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glBegin((int)7);
            com.bluepowermod.client.render.RenderHelper.drawColoredCube(vector.clone().expand(0.03125), r, g, b, (double)(this.inverted ? 255 - (this.power & 0xFF) : this.power & 0xFF) / 256.0 * 0.625, new boolean[0]);
            GL11.glEnd();
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3042);
        }
    }
}

