/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.analogue;

import com.bluepowermod.api.gate.IAnalogueComparatorReadout;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.analogue.GateSimpleAnalogue;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentQuartzResonator;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionAnalogue;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.helper.MathHelper;
import uk.co.qmunity.lib.vec.Vec3i;

public class GateComparator
extends GateSimpleAnalogue {
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentTorch t3;
    private GateComponentWire w;

    @Override
    public void initializeConnections() {
        ((GateConnectionAnalogue)this.front()).enable().setOutputOnly();
        ((GateConnectionAnalogue)this.right()).enable();
        ((GateConnectionAnalogue)this.back()).enable();
        ((GateConnectionAnalogue)this.left()).enable();
    }

    @Override
    public void onNeighborTileChange() {
        if (!this.getWorld().field_72995_K) {
            this.onUpdate();
        }
    }

    @Override
    public void initComponents() {
        this.t1 = new GateComponentTorch(this, 255, 0.25, false).setState(true);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 7274677, 0.25, false).setState(true);
        this.addComponent(this.t2);
        this.t3 = new GateComponentTorch(this, 4101340, 0.3125, false).setState(false);
        this.addComponent(this.t3);
        this.w = new GateComponentWire(this, 1638144, RedwireType.RED_ALLOY).setPower((byte)-1);
        this.addComponent(this.w);
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.RED_ALLOY).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.RED_ALLOY).bind((GateConnectionBase)this.back()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.RED_ALLOY).bind((GateConnectionBase)this.left()));
        this.addComponent(new GateComponentQuartzResonator(this, 14068503));
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public String getGateType() {
        return "comparator";
    }

    @Override
    public void doLogic() {
        byte power = ((GateConnectionAnalogue)this.back()).getInput();
        ForgeDirection d = ((GateConnectionAnalogue)this.back()).getDirection().toForgeDirection(this.getFace(), this.getRotation());
        Vec3i a = new Vec3i(this.getX(), this.getY(), this.getZ(), this.getWorld()).add(d);
        Block ba = a.getBlock(false);
        if (ba.func_149740_M()) {
            power = (byte)MathHelper.map((int)ba.func_149736_g(this.getWorld(), a.getX(), a.getY(), a.getZ(), d.getOpposite().ordinal()), (int)0, (int)15, (int)0, (int)255);
        }
        if (ba instanceof IAnalogueComparatorReadout && ((IAnalogueComparatorReadout)ba).hasAnalogueComparatorInputOverride()) {
            power = ((IAnalogueComparatorReadout)ba).getAnalogueComparatorInputOverride(this.getWorld(), a.getX(), a.getY(), a.getZ(), d.getOpposite().ordinal());
        }
        if (ba.func_149662_c()) {
            Vec3i b = a.getRelative(d);
            Block bb = b.getBlock(false);
            if (bb.func_149740_M()) {
                power = (byte)MathHelper.map((int)bb.func_149736_g(this.getWorld(), b.getX(), b.getY(), b.getZ(), d.getOpposite().ordinal()), (int)0, (int)15, (int)0, (int)255);
            }
            if (bb instanceof IAnalogueComparatorReadout && ((IAnalogueComparatorReadout)bb).hasAnalogueComparatorInputOverride()) {
                power = ((IAnalogueComparatorReadout)bb).getAnalogueComparatorInputOverride(this.getWorld(), b.getX(), b.getY(), b.getZ(), d.getOpposite().ordinal());
            }
        }
        this.t1.setState(((GateConnectionAnalogue)this.left()).getInput() == 0);
        this.t2.setState(((GateConnectionAnalogue)this.right()).getInput() == 0);
        this.w.setPower((byte)(255 - (power & 0xFF)));
        this.t3.setState(power != 0);
        ((GateConnectionAnalogue)this.front()).setOutput((byte)Math.max((power & 0xFF) - Math.max(((GateConnectionAnalogue)this.left()).getInput() & 0xFF, ((GateConnectionAnalogue)this.right()).getInput() & 0xFF), 0));
    }

    @Override
    public void tick() {
    }
}

