/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.helper;

import com.bluepowermod.BluePower;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackDatabase {
    private static final String FILE_EXTENSION = ".cdf";
    private static final String DATABASE_FOLDER_NAME = "bluepower" + File.separator + "circuitDatabase" + File.separator;
    private final String saveLocation = BluePower.proxy.getSavePath() + File.separator + DATABASE_FOLDER_NAME;
    private List<ItemStack> cache;

    public void saveItemStack(ItemStack stack) {
        new File(this.saveLocation).mkdirs();
        File targetLocation = new File(this.saveLocation + stack.func_82833_r() + FILE_EXTENSION);
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77955_b(tag);
        GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
        tag.func_74778_a("owner", ui.modId);
        tag.func_74778_a("name", ui.name);
        try {
            FileOutputStream fos = new FileOutputStream(targetLocation);
            DataOutputStream dos = new DataOutputStream(fos);
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            dos.writeShort((short)abyte.length);
            dos.write(abyte);
            dos.close();
        }
        catch (IOException e) {
            BluePower.log.error("IOException when trying to save an ItemStack in the database: " + e);
        }
        this.cache = null;
    }

    public void deleteStack(ItemStack deletingStack) {
        File targetLocation = new File(this.saveLocation);
        if (targetLocation.exists()) {
            File[] files;
            for (File file : files = targetLocation.listFiles()) {
                if (!deletingStack.func_82833_r().equals(file.getName().substring(0, file.getName().length() - 4))) continue;
                file.delete();
                this.cache = null;
                return;
            }
        }
    }

    public List<ItemStack> loadItemStacks() {
        if (this.cache == null) {
            File targetLocation = new File(this.saveLocation);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (targetLocation.exists()) {
                File[] files;
                for (File file : files = targetLocation.listFiles()) {
                    try {
                        FileInputStream fos = new FileInputStream(file);
                        DataInputStream dos = new DataInputStream(fos);
                        short short1 = dos.readShort();
                        byte[] abyte = new byte[short1];
                        dos.read(abyte);
                        NBTTagCompound tag = CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
                        ItemStack stack = new ItemStack(Items.field_151055_y);
                        stack.func_77963_c(tag);
                        if (stack.func_77973_b() != null) {
                            stacks.add(stack);
                        } else {
                            BluePower.log.error("Couldn't retrieve an itemstack with item id: " + tag.func_74765_d("id"));
                            Item item = GameRegistry.findItem((String)tag.func_74779_i("owner"), (String)tag.func_74779_i("name"));
                            if (item != null) {
                                ItemStack backupStack = new ItemStack(item, stack.field_77994_a, (int)tag.func_74765_d("Damage"));
                                if (stack.func_77942_o()) {
                                    backupStack.func_77982_d(stack.func_77978_p());
                                }
                                stacks.add(backupStack);
                                BluePower.log.info("Successfully retrieved stack via its name: " + tag.func_74779_i("owner") + ":" + tag.func_74779_i("name"));
                            } else {
                                BluePower.log.error("Couldn't retrieve the item via its name: " + tag.func_74779_i("owner") + ":" + tag.func_74779_i("name"));
                            }
                        }
                        dos.close();
                    }
                    catch (IOException e) {
                        BluePower.log.error("Exception : " + e);
                    }
                }
            }
            this.cache = stacks;
        }
        return this.cache;
    }
}

