/*
 * Decompiled with CFR 0.152.
 */
package particlephysics.entity.particle;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import particlephysics.ParticleRegistry;
import particlephysics.api.IParticleBouncer;
import particlephysics.api.IParticleReceptor;
import particlephysics.utility.BlockRenderInfo;

public abstract class TemplateParticle
extends EntityLivingBase {
    public int ticks = 0;
    public int iSize = 1;
    public int jSize = 1;
    public int kSize = 1;
    public int rotationX = 0;
    public int rotationY = 0;
    public int rotationZ = 0;
    public float potential;
    public ForgeDirection movementDirection;
    public int effect = 0;
    public static IIcon icon;

    public TemplateParticle(World par1World) {
        super(par1World);
        this.func_70105_a(0.25f, 0.25f);
        this.potential = this.getStartingPotential();
    }

    public abstract float getStartingPotential();

    public abstract String getName();

    public BlockRenderInfo getRenderIcon() {
        Class<?> key = ((Object)((Object)this)).getClass();
        return new BlockRenderInfo(ParticleRegistry.icons.get(key));
    }

    public void bounce(int targetX, int targetY, int targetZ, ForgeDirection forward) {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        ArrayList<ForgeDirection> freeDirections = new ArrayList<ForgeDirection>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir.getOpposite() == forward || !this.field_70170_p.func_147437_c(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
            freeDirections.add(dir);
        }
        if (freeDirections.size() != 0) {
            ForgeDirection targetDirection = (ForgeDirection)freeDirections.get(new Random().nextInt(freeDirections.size()));
            this.func_70107_b((double)x + 0.375, (double)y + 0.375, (double)z + 0.375);
            this.potential = (float)((double)this.potential * 0.9);
            double f = this.potential / this.getStartingPotential();
            this.field_70159_w = (double)targetDirection.offsetX * f;
            this.field_70181_x = (double)targetDirection.offsetY * f;
            this.field_70179_y = (double)targetDirection.offsetZ * f;
            this.onBounceHook(x, y, z);
        } else {
            this.func_70106_y();
        }
    }

    public boolean func_90999_ad() {
        return this.effect == 1;
    }

    public void onBounceHook(int x, int y, int z) {
    }

    public ItemStack[] func_70035_c() {
        return new ItemStack[0];
    }

    public void func_70062_b(int i, ItemStack itemStack) {
    }

    public void func_70030_z() {
        ++this.ticks;
        if (this.field_70170_p.field_72995_K || this.field_70170_p.func_82737_E() % 20L == 0L) {
            // empty if block
        }
        if (this.effect == 1) {
            this.potential = (float)((double)this.potential * 0.97);
        }
        if (this.effect == 2) {
            this.potential = (float)((double)this.potential * 1.01);
        }
        super.func_70030_z();
        if (this.ticks > 600 || this.field_70163_u > 257.0) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ForgeDirection dir = this.getForward();
        if (dir != ForgeDirection.UNKNOWN) {
            this.movementDirection = dir;
        }
        if (!this.field_70170_p.field_72995_K && Math.abs(this.field_70159_w) < 0.3 && Math.abs(this.field_70181_x) < 0.3 && Math.abs(this.field_70179_y) < 0.3) {
            ForgeDirection forward = this.movementDirection;
            if (forward == null) {
                return;
            }
            int targetX = MathHelper.func_76128_c((double)(this.field_70165_t + 0.5 * (double)forward.offsetX));
            int targetY = MathHelper.func_76128_c((double)(this.field_70163_u + 0.5 * (double)forward.offsetY));
            int targetZ = MathHelper.func_76128_c((double)(this.field_70161_v + 0.5 * (double)forward.offsetZ));
            Block block = this.field_70170_p.func_147439_a(targetX, targetY, targetZ);
            boolean isReflective = false;
            if (block instanceof IParticleBouncer) {
                isReflective = ((IParticleBouncer)block).canBounce(this.field_70170_p, targetX, targetY, targetZ, this);
            }
            if (block == Blocks.field_150359_w || isReflective) {
                this.bounce(targetX, targetY, targetZ, forward);
            } else {
                TileEntity entity = this.field_70170_p.func_147438_o(targetX, targetY, targetZ);
                if (entity instanceof IParticleReceptor) {
                    ((IParticleReceptor)entity).onContact(this);
                } else {
                    this.func_70106_y();
                }
            }
        }
        this.checkForParticleCollision();
    }

    public ItemStack func_70694_bm() {
        return null;
    }

    public ItemStack func_71124_b(int slot) {
        return null;
    }

    public void checkForParticleCollision() {
        if (!this.field_70170_p.field_72995_K) {
            List nearbyParticles = this.field_70170_p.func_72872_a(TemplateParticle.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 1.5), (double)(this.field_70163_u - 1.5), (double)(this.field_70161_v - 1.5), (double)(this.field_70165_t + 1.5), (double)(this.field_70163_u + 1.5), (double)(this.field_70161_v + 1.5)));
            for (int i = 0; i < nearbyParticles.size(); ++i) {
                TemplateParticle particle = (TemplateParticle)((Object)nearbyParticles.get(i));
                if (this == particle || this.field_70128_L || particle.field_70128_L) continue;
                this.onCollideWithParticle(particle);
            }
        }
    }

    public abstract void onCollideWithParticle(TemplateParticle var1);

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        if (this.movementDirection != null) {
            nbt.func_74768_a("direction", this.movementDirection.ordinal());
        }
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.movementDirection = ForgeDirection.VALID_DIRECTIONS[nbt.func_74762_e("direction")];
    }

    public ForgeDirection getForward() {
        if (this.field_70159_w > 0.1) {
            return ForgeDirection.EAST;
        }
        if (this.field_70159_w < -0.1) {
            return ForgeDirection.WEST;
        }
        if (this.field_70181_x > 0.1) {
            return ForgeDirection.UP;
        }
        if (this.field_70181_x < -0.1) {
            return ForgeDirection.DOWN;
        }
        if (this.field_70179_y > 0.1) {
            return ForgeDirection.SOUTH;
        }
        if (this.field_70179_y < -0.1) {
            return ForgeDirection.NORTH;
        }
        return ForgeDirection.UNKNOWN;
    }

    public void func_70612_e(float par1, float par2) {
        float f2 = 0.91f;
        float f3 = 0.16277136f / (f2 * f2 * f2);
        float f4 = this.field_70122_E ? this.func_70689_ay() * f3 : this.field_70747_aH;
        this.func_70060_a(par1, par2, f4);
        f2 = 0.91f;
        if (this.field_70122_E) {
            f2 = 0.54600006f;
            Block block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            if (block != Blocks.field_150350_a) {
                f2 = block.field_149765_K * 0.91f;
            }
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f6 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
    }

    public boolean func_70650_aV() {
        return false;
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity par1Entity) {
        if (!(par1Entity instanceof TemplateParticle)) {
            par1Entity.func_70108_f((Entity)this);
        }
    }

    public boolean func_70067_L() {
        return false;
    }
}

