/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobdbb.configuration;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.World;

public class BerryBushConfigs {
    private boolean isEnabled = true;
    private Block bush;
    private Item berry;
    private int minY = 0;
    private int maxY = 40;
    private int maxVeinSize = 4;
    private int bushColour;
    private double genChance = 0.01;
    private double growthChance = 0.04;
    private int[] dimensionBlacklist;
    private int[] dimensionWhitelist;

    public BerryBushConfigs(String name, double factor) {
        this.genChance /= factor;
        this.growthChance /= factor;
        if ("cobalt".equals(name) || "ardite".equals(name)) {
            this.dimensionBlacklist = new int[0];
            this.dimensionWhitelist = new int[]{-1};
            this.minY = 0;
            this.maxY = 120;
        } else if ("endium".equals(name)) {
            this.dimensionBlacklist = new int[0];
            this.dimensionWhitelist = new int[]{1};
            this.minY = 0;
            this.maxY = 120;
        } else {
            this.dimensionBlacklist = new int[]{-1, 1};
            this.dimensionWhitelist = new int[0];
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public Block getBush() {
        return this.bush;
    }

    public void setBush(Block bush) {
        this.bush = bush;
    }

    public Item getBerry() {
        return this.berry;
    }

    public void setBerry(Item berry) {
        this.berry = berry;
    }

    public int getMinY() {
        return this.minY;
    }

    public void setMinY(int minY) {
        this.minY = minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    public int getMaxVeinSize() {
        return this.maxVeinSize;
    }

    public void setMaxVeinSize(int maxVeinSize) {
        this.maxVeinSize = maxVeinSize;
    }

    public double getGenChance() {
        return this.genChance;
    }

    public void setGenChance(double genChance) {
        this.genChance = genChance;
    }

    public double getGrowthChance() {
        return this.growthChance;
    }

    public void setGrowthChance(double growthChance) {
        this.growthChance = growthChance;
    }

    public int getBushColour() {
        return this.bushColour & 0xFFFFFF;
    }

    public void setBushColour(int bushColour) {
        this.bushColour = bushColour;
    }

    public int[] getDefaultBlacklistDims() {
        return this.dimensionBlacklist;
    }

    public int[] getDefaultWhitelistDims() {
        return this.dimensionWhitelist;
    }

    public void setDimensionBlacklist(int[] dimensionBlacklist) {
        this.dimensionBlacklist = dimensionBlacklist;
    }

    public void setDimensionWhitelist(int[] dimensionWhitelist) {
        this.dimensionWhitelist = dimensionWhitelist;
    }

    public boolean isDimensionAllowed(World world) {
        if (this.dimensionWhitelist.length != 0) {
            return this.arrayContainsValue(this.dimensionWhitelist, world.field_73011_w.field_76574_g);
        }
        return !this.arrayContainsValue(this.dimensionBlacklist, world.field_73011_w.field_76574_g);
    }

    public boolean arrayContainsValue(int[] array, int value) {
        for (int id : array) {
            if (id != value) continue;
            return true;
        }
        return false;
    }
}

