/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.world;

import codechicken.lib.vec.BlockCoord;
import com.amadornes.framez.movement.MovingBlock;
import com.amadornes.framez.movement.MovingStructure;
import com.amadornes.framez.movement.StructureTickHandler;
import com.amadornes.framez.tile.TileMoving;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldWrapperServer
extends WorldServer {
    private List<MovingStructure> structures = new ArrayList<MovingStructure>();
    private World world;
    private List<BlockCoord> toUpdate = new ArrayList<BlockCoord>();

    public WorldWrapperServer(World world) {
        super(MinecraftServer.func_71276_C(), (ISaveHandler)new NonSavingHandler(), world.func_72912_H().func_76065_j(), world.field_73011_w.field_76574_g, new WorldSettings(world.func_72912_H()), world.field_72984_F);
        DimensionManager.setWorld((int)world.field_73011_w.field_76574_g, (WorldServer)((WorldServer)world));
        this.field_73020_y = world.func_72863_F();
        this.world = world;
    }

    public void addStructure(MovingStructure structure) {
        this.structures.add(structure);
    }

    public void removeStructure(MovingStructure structure) {
        this.structures.remove(structure);
    }

    protected void func_72963_a(WorldSettings p_72963_1_) {
    }

    protected IChunkProvider func_72970_h() {
        return new EmptyChunkProvider();
    }

    protected int func_152379_p() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    private MovingBlock get(int x, int y, int z) {
        for (MovingStructure structure : this.structures) {
            MovingBlock b;
            if (structure.getMoved() >= 1.0 || (b = structure.getBlock(x, y, z)) != null && !b.isStored()) continue;
            return b;
        }
        return null;
    }

    public Block func_147439_a(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getBlock();
        }
        return Blocks.field_150350_a;
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getTileEntity();
        }
        return null;
    }

    public int func_72802_i(int x, int y, int z, int unknown) {
        return this.world.func_72802_i(x, y, z, unknown);
    }

    public int func_72805_g(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getMetadata();
        }
        return 0;
    }

    public int func_72879_k(int x, int y, int z, int face) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getBlock().func_149748_c((IBlockAccess)this, x, y, z, face);
        }
        return 0;
    }

    public boolean func_147437_c(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        return b == null;
    }

    public Entity func_73045_a(int id) {
        return this.world.func_73045_a(id);
    }

    public boolean func_72838_d(Entity entity) {
        MovingStructure structure = StructureTickHandler.INST.tickingStructure;
        if (structure != null) {
            entity.field_70165_t += (double)structure.getDirection().offsetX * structure.getMoved();
            entity.field_70163_u += (double)structure.getDirection().offsetY * structure.getMoved();
            entity.field_70161_v += (double)structure.getDirection().offsetZ * structure.getMoved();
        }
        return this.world.func_72838_d(entity);
    }

    public void func_72869_a(String type, double x, double y, double z, double r, double g, double b) {
        MovingStructure structure = StructureTickHandler.INST.tickingStructure;
        if (structure != null) {
            this.world.func_72869_a(type, x + (double)structure.getDirection().offsetX * structure.getMoved(), y + (double)structure.getDirection().offsetY * structure.getMoved(), z + (double)structure.getDirection().offsetZ * structure.getMoved(), r, g, b);
        } else {
            this.world.func_72869_a(type, x, y, z, r, g, b);
        }
    }

    public boolean func_147449_b(int x, int y, int z, Block block) {
        MovingBlock b = this.get(x, y, z);
        if (b == null) {
            return false;
        }
        b.setBlock(block);
        if (b.getPlaceholder() != null) {
            b.getPlaceholder().sendUpdatePacket(TileMoving.UpdateType.BLOCK);
        }
        return true;
    }

    public boolean func_147465_d(int x, int y, int z, Block block, int meta, int notify) {
        MovingBlock b = this.get(x, y, z);
        if (b == null) {
            return false;
        }
        b.setBlock(block);
        b.setMetadata(meta);
        if (b.getPlaceholder() != null) {
            b.getPlaceholder().sendUpdatePacket(TileMoving.UpdateType.BLOCK);
        }
        return true;
    }

    public boolean func_72921_c(int x, int y, int z, int meta, int notify) {
        MovingBlock b = this.get(x, y, z);
        if (b == null) {
            return false;
        }
        b.setMetadata(meta);
        if (b.getPlaceholder() != null) {
            b.getPlaceholder().sendUpdatePacket(TileMoving.UpdateType.BLOCK);
        }
        return true;
    }

    public boolean func_147468_f(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        if (b == null) {
            return false;
        }
        b.setBlock(Blocks.field_150350_a);
        if (b.getPlaceholder() != null) {
            b.getPlaceholder().sendUpdatePacket(TileMoving.UpdateType.BLOCK);
        }
        return true;
    }

    public void func_147455_a(int x, int y, int z, TileEntity te) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            b.setTileEntity(te);
        }
    }

    public void func_147475_p(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            b.setTileEntity(null);
        }
    }

    public void func_72835_b() {
        ArrayList<BlockCoord> toUpdateCurrent = new ArrayList<BlockCoord>(this.toUpdate);
        this.toUpdate.clear();
        for (BlockCoord b : toUpdateCurrent) {
            Block bl = this.func_147439_a(b.x, b.y, b.z);
            if (bl == null) continue;
            bl.func_149674_a((World)this, b.x, b.y, b.z, this.field_73012_v);
        }
        toUpdateCurrent.clear();
    }

    public void func_72939_s() {
    }

    public void func_72980_b(double x, double y, double z, String sound, float volume, float pitch, boolean unknown) {
        this.world.func_72980_b(x, y, z, sound, volume, pitch, unknown);
    }

    public void func_72956_a(Entity entity, String sound, float volume, float pitch) {
        this.world.func_72956_a(entity, sound, volume, pitch);
    }

    public void func_72908_a(double x, double y, double z, String sound, float volume, float pitch) {
        this.world.func_72908_a(x, y, z, sound, volume, pitch);
    }

    public void func_72926_e(int x, int y, int z, int a, int b) {
        this.world.func_72926_e(x, y, z, a, b);
    }

    public void func_72889_a(EntityPlayer player, int x, int y, int z, int a, int b) {
        this.world.func_72889_a(player, x, y, z, a, b);
    }

    public void func_85173_a(EntityPlayer player, String sound, float volume, float pitch) {
        this.world.func_85173_a(player, sound, volume, pitch);
    }

    public void func_82739_e(int x, int y, int z, int p_82739_4_, int p_82739_5_) {
        this.world.func_82739_e(x, y, z, p_82739_4_, p_82739_5_);
    }

    public boolean func_147463_c(EnumSkyBlock p_147463_1_, int p_147463_2_, int p_147463_3_, int p_147463_4_) {
        return false;
    }

    public Chunk func_72938_d(int x, int z) {
        return this.world.func_72938_d(x, z);
    }

    public Chunk func_72964_e(int x, int z) {
        return this.world.func_72964_e(x, z);
    }

    public IChunkProvider func_72863_F() {
        return this.world.func_72863_F();
    }

    protected boolean func_72916_c(int p_72916_1_, int p_72916_2_) {
        return this.func_72863_F().func_73149_a(p_72916_1_, p_72916_2_);
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getBlock().isSideSolid((IBlockAccess)this, x, y, z, side);
        }
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getBlock().isSideSolid((IBlockAccess)this, x, y, z, side);
        }
        return _default;
    }

    public void func_147444_c(int p_147444_1_, int p_147444_2_, int p_147444_3_, Block p_147444_4_) {
    }

    public void func_147460_e(int p_147460_1_, int p_147460_2_, int p_147460_3_, Block p_147460_4_) {
    }

    public void func_147441_b(int p_147441_1_, int p_147441_2_, int p_147441_3_, Block p_147441_4_, int p_147441_5_) {
    }

    public void func_147459_d(int p_147459_1_, int p_147459_2_, int p_147459_3_, Block p_147459_4_) {
    }

    public void func_73044_a(boolean p_73044_1_, IProgressUpdate p_73044_2_) throws MinecraftException {
    }

    public void func_104140_m() {
    }

    protected void func_73042_a() throws MinecraftException {
    }

    public void func_72897_h(Entity entity) {
        this.world.func_72897_h(entity);
    }

    public void func_72900_e(Entity p_72900_1_) {
        this.world.func_72900_e(p_72900_1_);
    }

    public File getChunkSaveLocation() {
        return null;
    }

    public void func_147471_g(int x, int y, int z) {
        this.toUpdate.add(new BlockCoord(x, y, z));
        MovingBlock b = this.get(x, y, z);
        if (b != null && b.getPlaceholder() != null) {
            b.getPlaceholder().sendUpdatePacket(TileMoving.UpdateType.ALL);
        }
    }

    public World getRealWorld() {
        return this.world;
    }

    public long func_72820_D() {
        return this.world.func_72820_D();
    }

    public long func_82737_E() {
        return this.world.func_82737_E();
    }

    private static class EmptyChunkProvider
    extends AnvilChunkLoader
    implements IChunkProvider {
        public EmptyChunkProvider() {
            super(null);
        }

        public boolean chunkExists(World world, int i, int j) {
            return true;
        }

        public void func_75817_a() {
        }

        public Chunk func_75815_a(World p_75815_1_, int p_75815_2_, int p_75815_3_) {
            return null;
        }

        public Object[] loadChunk__Async(World p_75815_1_, int p_75815_2_, int p_75815_3_) {
            return null;
        }

        public void loadEntities(World p_75823_1_, NBTTagCompound p_75823_2_, Chunk chunk) {
        }

        public void func_75816_a(World p_75816_1_, Chunk p_75816_2_) {
        }

        public void func_75819_b(World p_75819_1_, Chunk p_75819_2_) {
        }

        public void func_104112_b() {
        }

        protected void func_75824_a(ChunkCoordIntPair p_75824_1_, NBTTagCompound p_75824_2_) {
        }

        protected Chunk func_75822_a(World p_75822_1_, int p_75822_2_, int p_75822_3_, NBTTagCompound p_75822_4_) {
            return null;
        }

        protected Object[] checkedReadChunkFromNBT__Async(World p_75822_1_, int p_75822_2_, int p_75822_3_, NBTTagCompound p_75822_4_) {
            return null;
        }

        public boolean func_75814_c() {
            return true;
        }

        public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
            return false;
        }

        public Chunk func_73154_d(int p_73154_1_, int p_73154_2_) {
            return null;
        }

        public Chunk func_73158_c(int p_73158_1_, int p_73158_2_) {
            return null;
        }

        public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        }

        public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
            return true;
        }

        public boolean func_73156_b() {
            return true;
        }

        public boolean func_73157_c() {
            return true;
        }

        public String func_73148_d() {
            return "";
        }

        public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
            return new ArrayList();
        }

        public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
            return null;
        }

        public int func_73152_e() {
            return 0;
        }

        public void func_82695_e(int p_82695_1_, int p_82695_2_) {
        }
    }

    private static class NonSavingHandler
    implements ISaveHandler {
        private NonSavingHandler() {
        }

        public void func_75755_a(WorldInfo p_75755_1_, NBTTagCompound p_75755_2_) {
        }

        public void func_75761_a(WorldInfo p_75761_1_) {
        }

        public WorldInfo func_75757_d() {
            return null;
        }

        public String func_75760_g() {
            return null;
        }

        public File func_75765_b() {
            return null;
        }

        public IPlayerFileData func_75756_e() {
            return null;
        }

        public File func_75758_b(String p_75758_1_) {
            return null;
        }

        public IChunkLoader func_75763_a(WorldProvider p_75763_1_) {
            return null;
        }

        public void func_75759_a() {
        }

        public void func_75762_c() {
        }
    }
}

