/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.util;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.FaceMicroblock;
import codechicken.microblock.HollowMicroblock;
import codechicken.microblock.Microblock;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.amadornes.framez.api.IFrame;
import com.amadornes.framez.api.IFrameProvider;
import com.amadornes.framez.api.movement.HandlingPriority;
import com.amadornes.framez.part.PartFrame;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Utils {
    public static List<IFrameProvider> providers = new ArrayList<IFrameProvider>();

    public static IFrame getFrame(World world, int x, int y, int z) {
        IFrame f;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileMultipart && (f = Utils.getFrame((TileMultipart)te)) != null) {
            return f;
        }
        for (IFrameProvider p : providers) {
            IFrame f2 = p.getFrameAt(world, x, y, z);
            if (f2 == null) continue;
            return f2;
        }
        return null;
    }

    private static IFrame getFrame(TileMultipart te) {
        for (TMultiPart p : te.jPartList()) {
            if (!(p instanceof PartFrame)) continue;
            return (PartFrame)p;
        }
        return null;
    }

    public static boolean occlusionTest(World world, int x, int y, int z, ForgeDirection face) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileMultipart) {
            return Utils.occlusionTest((TileMultipart)te, face);
        }
        return false;
    }

    public static boolean occlusionTest(TileMultipart tile, ForgeDirection face) {
        if (tile != null) {
            TileMultipart te = tile;
            NormallyOccludedPart box = new NormallyOccludedPart(new Cuboid6(0.1875, 0.0, 0.1875, 0.75, 0.1875, 0.75).apply(Rotation.sideRotations[face.ordinal()].at(Vector3.center)));
            for (TMultiPart p : te.jPartList()) {
                if (p instanceof PartFrame || p.occlusionTest((TMultiPart)box)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static int getMicroblockSize(TileMultipart tile, ForgeDirection face) {
        if (tile != null) {
            TileMultipart te = tile;
            for (TMultiPart p : te.jPartList()) {
                if (p instanceof PartFrame || !(p instanceof FaceMicroblock) && !(p instanceof HollowMicroblock) || ((Microblock)p).getShape() != face.ordinal()) continue;
                return ((Microblock)p).getSize();
            }
            return 0;
        }
        return 0;
    }

    public static TileMultipart getMultipartTile(World w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te != null && te instanceof TileMultipart) {
            return (TileMultipart)te;
        }
        return null;
    }

    public static <T> List<T> sortByPriority(Map<T, HandlingPriority.Priority> map) {
        ArrayList<T> sorted = new ArrayList<T>();
        for (T h : map.keySet()) {
            if (map.get(h) != HandlingPriority.Priority.HIGH) continue;
            sorted.add(h);
        }
        for (T h : map.keySet()) {
            if (map.get(h) != HandlingPriority.Priority.MEDIUM) continue;
            sorted.add(h);
        }
        for (T h : map.keySet()) {
            if (map.get(h) != HandlingPriority.Priority.LOW) continue;
            sorted.add(h);
        }
        return sorted;
    }
}

