/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.render.EntityDigIconFX;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.FaceMicroblock;
import codechicken.microblock.HollowMicroblock;
import codechicken.microblock.ItemMicroPart;
import codechicken.microblock.Microblock;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TNormalOcclusion;
import com.amadornes.framez.api.FramezApi;
import com.amadornes.framez.api.IFrame;
import com.amadornes.framez.api.IFrameModifier;
import com.amadornes.framez.api.IFrameModifierProvider;
import com.amadornes.framez.api.IFramezWrench;
import com.amadornes.framez.client.IconProvider;
import com.amadornes.framez.client.render.RenderFrame;
import com.amadornes.framez.modifier.ModifierRegistry;
import com.amadornes.framez.network.NetworkHandler;
import com.amadornes.framez.network.packet.PacketBlockSide;
import com.amadornes.framez.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class PartFrame
extends TMultiPart
implements TNormalOcclusion,
IFrame {
    private static final Cuboid6[] subParts = new Cuboid6[]{null, null, null, null, null, null};
    private Object[] connections = new Object[]{null, null, null, null, null, null};
    private List<IFrameModifier> modifiers = new ArrayList<IFrameModifier>();
    private boolean[] render = new boolean[20];
    private boolean[] blocked = new boolean[6];

    private boolean isConnected(ForgeDirection dir) {
        return this.getConnection(dir) != null && this.getConnection(dir) instanceof IFrame;
    }

    public Object getConnection(ForgeDirection dir) {
        return this.connections[dir.ordinal()];
    }

    private boolean shouldRenderCorner(ForgeDirection face, ForgeDirection a, ForgeDirection b) {
        Object of = face != ForgeDirection.UNKNOWN ? this.getConnection(face) : null;
        Object oa = this.getConnection(a);
        Object ob = this.getConnection(b);
        if (face == ForgeDirection.UNKNOWN) {
            return oa == null && ob == null || (oa == null || !(oa instanceof PartFrame)) && (ob == null || !(ob instanceof PartFrame));
        }
        if (oa != null && ob != null && oa instanceof PartFrame && ob instanceof PartFrame && ((PartFrame)oa).isConnected(b)) {
            return false;
        }
        if (oa != null && of != null && oa instanceof PartFrame && of instanceof PartFrame && ((PartFrame)oa).isConnected(face)) {
            return false;
        }
        return ob == null || of == null || !(ob instanceof PartFrame) || !(of instanceof PartFrame) || !((PartFrame)ob).isConnected(face);
    }

    public String getType() {
        return "framez.frame";
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        ArrayList<Cuboid6> boxes = new ArrayList<Cuboid6>();
        return boxes;
    }

    public boolean occlusionTest(TMultiPart npart) {
        if (npart instanceof PartFrame) {
            return false;
        }
        if (npart instanceof Microblock) {
            if (npart instanceof FaceMicroblock || npart instanceof HollowMicroblock) {
                return ((Microblock)npart).getSize() < 3;
            }
            return false;
        }
        return true;
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        return Arrays.asList(new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        ArrayList<IndexedCuboid6> boxes = new ArrayList<IndexedCuboid6>();
        double translation = 1.0E-4;
        double t = 0.001;
        PartFrame.subParts[0] = new Cuboid6(0.0, 0.0 + t, 0.0, 1.0, translation + t, 1.0);
        PartFrame.subParts[1] = new Cuboid6(0.0, 1.0 - translation - t, 0.0, 1.0, 1.0 - t, 1.0);
        PartFrame.subParts[2] = new Cuboid6(0.0, 0.0, 0.0 + t, 1.0, 1.0, translation + t);
        PartFrame.subParts[3] = new Cuboid6(0.0, 0.0, 1.0 - translation - t, 1.0, 1.0, 1.0 - t);
        PartFrame.subParts[4] = new Cuboid6(0.0 + t, 0.0, 0.0, translation + t, 1.0, 1.0);
        PartFrame.subParts[5] = new Cuboid6(1.0 - translation - t, 0.0, 0.0, 1.0 - t, 1.0, 1.0);
        if (this.tile() != null) {
            List parts = this.tile().jPartList();
            for (int i = 0; i < 6; ++i) {
                IndexedCuboid6 c = new IndexedCuboid6((Object)0, subParts[i]);
                boolean skip = false;
                for (TMultiPart p : parts) {
                    if (!(p instanceof HollowMicroblock) || ((HollowMicroblock)p).getSlot() != i) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                boxes.add(c);
            }
        }
        return boxes;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        if (pass != 0) {
            return false;
        }
        RenderFrame.render(this, this.x(), this.y(), this.z());
        return true;
    }

    public boolean doesTick() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addDestroyEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IIcon[] icons = new IIcon[6];
        for (int i = 0; i < 6; ++i) {
            IIcon icon = ModifierRegistry.INST.getCrossTexture(Arrays.asList(this.getModifiers()), ForgeDirection.getOrientation((int)hit.field_72310_e));
            if (icon == null) {
                IIcon iIcon = icon = this.isSideBlocked(ForgeDirection.getOrientation((int)hit.field_72310_e)) ? IconProvider.iconFrameCrossBlocked : IconProvider.iconFrameCross;
            }
            if (icon == null) {
                icon = IconProvider.iconNothing;
            }
            icons[i] = icon;
        }
        EntityDigIconFX.addBlockDestroyEffects((World)this.world(), (Cuboid6)Cuboid6.full.copy().add(Vector3.fromTileEntity((TileEntity)this.tile())), (IIcon[])icons, (EffectRenderer)effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IIcon icon = ModifierRegistry.INST.getCrossTexture(Arrays.asList(this.getModifiers()), ForgeDirection.getOrientation((int)hit.field_72310_e));
        if (icon == null) {
            icon = this.isSideBlocked(ForgeDirection.getOrientation((int)hit.field_72310_e)) ? IconProvider.iconFrameCrossBlocked : IconProvider.iconFrameCross;
        }
        EntityDigIconFX.addBlockHitEffects((World)this.world(), (Cuboid6)Cuboid6.full.copy().add(Vector3.fromTileEntity((TileEntity)this.tile())), (int)hit.field_72310_e, (IIcon)icon, (EffectRenderer)effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBreaking(RenderBlocks renderBlocks) {
        RenderBlocks rb2 = RenderFrame.rb;
        RenderFrame.rb = renderBlocks;
        this.renderStatic(new Vector3(), 0);
        RenderFrame.rb = rb2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean drawHighlight(MovingObjectPosition hit, EntityPlayer player, float frame) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GL11.glLineWidth((float)2.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glPushMatrix();
        RenderUtils.translateToWorldCoords((Entity)player, (float)frame);
        GL11.glTranslated((double)this.x(), (double)this.y(), (double)this.z());
        RenderUtils.drawCuboidOutline((Cuboid6)new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).expand(0.001));
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        return true;
    }

    public ExtendedMOP collisionRayTrace(Vec3 start, Vec3 end) {
        ItemStack item;
        ExtendedMOP mop = super.collisionRayTrace(start, end);
        boolean center = false;
        EntityPlayer player = null;
        for (Object o : this.world().field_73010_i) {
            EntityPlayer p = (EntityPlayer)o;
            if (RayTracer.getEndVec((EntityPlayer)p).func_72438_d(end) != 0.0) continue;
            player = p;
            break;
        }
        if (player != null && (item = player.func_71045_bC()) != null && item.func_77973_b() instanceof ItemMicroPart) {
            center = true;
        }
        if (mop != null) {
            Vec3 click = mop.field_72307_f.func_72441_c((double)(-mop.field_72311_b), (double)(-mop.field_72312_c), (double)(-mop.field_72309_d));
            ForgeDirection face = ForgeDirection.getOrientation((int)mop.field_72310_e);
            if (face == ForgeDirection.EAST || face == ForgeDirection.WEST) {
                if (center) {
                    click.field_72448_b = 0.5;
                    click.field_72449_c = 0.5;
                }
                click.field_72450_a = click.field_72450_a * 0.5 + 0.25;
            }
            if (face == ForgeDirection.UP || face == ForgeDirection.DOWN) {
                if (center) {
                    click.field_72450_a = 0.5;
                    click.field_72449_c = 0.5;
                }
                click.field_72448_b = click.field_72448_b * 0.5 + 0.25;
            }
            if (face == ForgeDirection.NORTH || face == ForgeDirection.SOUTH) {
                if (center) {
                    click.field_72450_a = 0.5;
                    click.field_72448_b = 0.5;
                }
                click.field_72449_c = click.field_72449_c * 0.5 + 0.25;
            }
            mop.field_72307_f = click.func_72441_c((double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d);
        }
        return mop;
    }

    private ItemStack getItem() {
        ArrayList<String> modifiers = new ArrayList<String>();
        for (IFrameModifier m : this.modifiers) {
            modifiers.add(m.getIdentifier());
        }
        return FramezApi.inst().getModifierRegistry().getFrameStack(modifiers.toArray(new String[0]));
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    public Iterable<ItemStack> getDrops() {
        this.onUpdate(1);
        return Arrays.asList(this.getItem());
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        this.writeModifiersToNBT(tag);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            tag.func_74757_a("blocked_" + d.name().toLowerCase(), this.isSideBlocked(d));
        }
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        try {
            this.readModifiersFromNBT(tag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this.blocked[d.ordinal()] = tag.func_74767_n("blocked_" + d.name().toLowerCase());
        }
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeModifiersToNBT(tag);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            tag.func_74757_a("blocked_" + d.name().toLowerCase(), this.isSideBlocked(d));
        }
        packet.writeNBTTagCompound(tag);
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        NBTTagCompound tag = packet.readNBTTagCompound();
        try {
            this.readModifiersFromNBT(tag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this.blocked[d.ordinal()] = tag.func_74767_n("blocked_" + d.name().toLowerCase());
        }
        try {
            this.onUpdate(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        ItemStack item = player.func_71045_bC();
        double strength = 1.0;
        if (item != null) {
            Block b = null;
            for (IFrameModifier m : this.getModifiers()) {
                Block mat = m.getMaterialType();
                if (mat == null) continue;
                b = mat;
                break;
            }
            if (b == null) {
                b = Blocks.field_150344_f;
            }
            strength = item.func_77973_b().getDigSpeed(item, b, 0);
        }
        for (IFrameModifier m : this.getModifiers()) {
            strength /= m.getHardnessMultiplier();
        }
        return (float)strength;
    }

    public void onAdded() {
        super.onAdded();
        this.onUpdate(0);
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        this.onUpdate(0);
    }

    public void onRemoved() {
        super.onRemoved();
        this.onUpdate(1);
    }

    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.onUpdate(2);
        this.sendDescUpdate();
    }

    public void onPartChanged(TMultiPart part) {
        super.onPartChanged(part);
        this.onUpdate(3);
    }

    private void onUpdate(int mode) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection face = ForgeDirection.getOrientation((int)i);
            if (mode != 1) {
                this.connections[i] = this.getObjectOnSide(face);
            }
            if (mode == 2 || this.connections[i] == null || !(this.connections[i] instanceof PartFrame)) continue;
            ((PartFrame)this.connections[i]).onUpdate(2);
            for (Object o : ((PartFrame)this.connections[i]).connections) {
                if (o == null || !(o instanceof PartFrame)) continue;
                ((PartFrame)o).onUpdate(2);
            }
        }
        this.updateRenderer();
    }

    private void updateRenderer() {
        this.render[0] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.WEST);
        this.render[1] = !this.hasModifier("connected") || this.hasModifier("connected") && !this.isConnected(ForgeDirection.NORTH) && !this.isConnected(ForgeDirection.DOWN);
        this.render[2] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.EAST);
        this.render[3] = !this.hasModifier("connected") || this.hasModifier("connected") && !this.isConnected(ForgeDirection.EAST) && !this.isConnected(ForgeDirection.DOWN);
        this.render[4] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.EAST);
        this.render[5] = !this.hasModifier("connected") || this.hasModifier("connected") && !this.isConnected(ForgeDirection.SOUTH) && !this.isConnected(ForgeDirection.DOWN);
        this.render[6] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.WEST);
        this.render[7] = !this.hasModifier("connected") || this.hasModifier("connected") && !this.isConnected(ForgeDirection.WEST) && !this.isConnected(ForgeDirection.DOWN);
        this.render[8] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.WEST);
        this.render[9] = !this.hasModifier("connected") || this.hasModifier("connected") && !this.isConnected(ForgeDirection.NORTH) && !this.isConnected(ForgeDirection.UP);
        this.render[10] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.EAST);
        this.render[11] = !this.hasModifier("connected") || this.hasModifier("connected") && !this.isConnected(ForgeDirection.EAST) && !this.isConnected(ForgeDirection.UP);
        this.render[12] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST);
        this.render[13] = !this.hasModifier("connected") || this.hasModifier("connected") && !this.isConnected(ForgeDirection.SOUTH) && !this.isConnected(ForgeDirection.UP);
        this.render[14] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.WEST);
        this.render[15] = !this.hasModifier("connected") || this.hasModifier("connected") && !this.isConnected(ForgeDirection.WEST) && !this.isConnected(ForgeDirection.UP);
        this.render[16] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.UNKNOWN, ForgeDirection.NORTH, ForgeDirection.WEST);
        this.render[17] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.UNKNOWN, ForgeDirection.NORTH, ForgeDirection.EAST);
        this.render[18] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.UNKNOWN, ForgeDirection.SOUTH, ForgeDirection.EAST);
        this.render[19] = !this.hasModifier("connected") || this.hasModifier("connected") && this.shouldRenderCorner(ForgeDirection.UNKNOWN, ForgeDirection.SOUTH, ForgeDirection.WEST);
    }

    private Object getObjectOnSide(ForgeDirection face) {
        int x = this.x() + face.offsetX;
        int y = this.y() + face.offsetY;
        int z = this.z() + face.offsetZ;
        int mbThis = Utils.getMicroblockSize(this.tile(), face);
        if (mbThis > 0) {
            return mbThis;
        }
        int mbOther = Utils.getMicroblockSize(Utils.getMultipartTile(this.world(), x, y, z), face.getOpposite());
        if (mbOther > 0) {
            return mbOther;
        }
        IFrame f = Utils.getFrame(this.world(), x, y, z);
        if (f != null) {
            return f;
        }
        if (this.world().func_147439_a(x, y, z).isSideSolid((IBlockAccess)this.world(), x, y, z, face.getOpposite())) {
            return true;
        }
        return null;
    }

    @Override
    public IFrameModifier[] getModifiers() {
        return this.modifiers.toArray(new IFrameModifier[0]);
    }

    @Override
    public void addModifier(IFrameModifier modifier) {
        if (modifier == null) {
            return;
        }
        for (IFrameModifier m : this.getModifiers()) {
            if (!m.getIdentifier().equals(modifier.getIdentifier())) continue;
            return;
        }
        this.modifiers.add(modifier);
    }

    @Override
    public void addModifiers(IFrameModifier ... modifiers) {
        for (IFrameModifier m : modifiers) {
            this.addModifier(m);
        }
    }

    @Override
    public void removeModifier(String modifier) {
        IFrameModifier mod = null;
        for (IFrameModifier m : this.getModifiers()) {
            if (!m.getIdentifier().equals(modifier)) continue;
            mod = m;
            break;
        }
        if (mod != null) {
            this.modifiers.remove(mod);
        }
    }

    @Override
    public boolean hasModifier(String modifier) {
        for (IFrameModifier m : this.getModifiers()) {
            if (!m.getIdentifier().equals(modifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readModifiersFromNBT(NBTTagCompound tag) {
        ArrayList<IFrameModifier> unedited = new ArrayList<IFrameModifier>();
        unedited.addAll(Arrays.asList(this.getModifiers()));
        NBTTagList list = tag.func_150295_c("modifiers", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            String type = t.func_74779_i("__type");
            IFrameModifier modifier = null;
            for (IFrameModifier m : unedited) {
                if (m == null || !m.getIdentifier().equals(type)) continue;
                modifier = m;
                break;
            }
            if (modifier == null) {
                for (IFrameModifierProvider p : FramezApi.inst().getModifierRegistry().getProviders()) {
                    if (!p.getIdentifier().equals(type)) continue;
                    modifier = p.instantiate(this);
                    break;
                }
                this.addModifier(modifier);
            } else {
                unedited.remove(modifier);
            }
            modifier.readFromNBT(t);
        }
        this.modifiers.removeAll(unedited);
        unedited.clear();
    }

    @Override
    public void writeModifiersToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (IFrameModifier m : this.getModifiers()) {
            NBTTagCompound t = new NBTTagCompound();
            m.writeToNBT(t);
            t.func_74778_a("__type", m.getIdentifier());
            list.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("modifiers", (NBTBase)list);
    }

    @Override
    public Object[] getConnections() {
        return this.connections;
    }

    public boolean[] getRender() {
        return this.render;
    }

    @Override
    public boolean isSideBlocked(ForgeDirection side) {
        return this.blocked[side.ordinal()];
    }

    @Override
    public boolean toggleBlock(ForgeDirection side) {
        if (!this.world().field_72995_K) {
            this.blocked[side.ordinal()] = !this.isSideBlocked(side);
            this.sendDescUpdate();
            return true;
        }
        return false;
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        if (!this.world().field_72995_K) {
            return false;
        }
        if (item == null || !(item.func_77973_b() instanceof IFramezWrench)) {
            return false;
        }
        ArrayList<TMultiPart> parts = new ArrayList<TMultiPart>();
        for (TMultiPart p : this.tile().jPartList()) {
            if (p instanceof Microblock || p == this) continue;
            parts.add(p);
        }
        int side = hit.field_72310_e;
        if (Keyboard.isKeyDown((int)29)) {
            side ^= 1;
        }
        NormallyOccludedPart nop = new NormallyOccludedPart(new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.125, 1.0).apply(Rotation.sideRotations[side].at(Vector3.center)));
        boolean can = false;
        for (TMultiPart p : parts) {
            if (p.occlusionTest((TMultiPart)nop) && nop.occlusionTest(p)) continue;
            can = true;
            break;
        }
        if (can) {
            NetworkHandler.sendToServer(new PacketBlockSide(this.x(), this.y(), this.z(), ForgeDirection.getOrientation((int)side)));
        }
        return can;
    }

    @Override
    public int getMaxCarriedBlocks() {
        int max = -1;
        for (IFrameModifier m : this.getModifiers()) {
            max = Math.max(max, m.getMaxCarriedBlocks());
        }
        return max == -1 ? 3 : max;
    }
}

