/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.movement;

import com.amadornes.framez.api.movement.BlockMovementType;
import com.amadornes.framez.api.movement.HandlingPriority;
import com.amadornes.framez.api.movement.IMovementApi;
import com.amadornes.framez.api.movement.IMovementHandler;
import com.amadornes.framez.api.movement.IMovingBlock;
import com.amadornes.framez.movement.handler.BlockHandler;
import com.amadornes.framez.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class MovementApi
implements IMovementApi {
    public static final MovementApi INST = new MovementApi();
    private List<IMovementHandler> handlers = new ArrayList<IMovementHandler>();

    private MovementApi() {
    }

    @Override
    public void registerMovementHandler(IMovementHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    @Override
    public IMovementHandler[] getRegisteredHandlers() {
        return this.handlers.toArray(new IMovementHandler[0]);
    }

    @Override
    public void setBlockMovementType(Block block, BlockMovementType type) {
        this.registerMovementHandler(new BlockHandler(block, type));
    }

    @Override
    public void setBlockMovementType(Block block, int metadata, BlockMovementType type) {
        this.registerMovementHandler(new BlockHandler(block, metadata, type));
    }

    public BlockMovementType getMovementType(World world, int x, int y, int z) {
        for (IMovementHandler h : this.getSortedHandlersForType()) {
            BlockMovementType t = h.getMovementType(world, x, y, z);
            if (t == null) continue;
            return t;
        }
        return BlockMovementType.MOVABLE;
    }

    public boolean handlePlacement(IMovingBlock block) {
        for (IMovementHandler h : this.getSortedHandlersForMovement(true)) {
            if (!h.handleFinishMoving(block)) continue;
            return true;
        }
        return false;
    }

    public boolean handleRemoval(IMovingBlock block) {
        for (IMovementHandler h : this.getSortedHandlersForMovement(false)) {
            if (!h.handleStartMoving(block)) continue;
            return true;
        }
        return false;
    }

    private List<IMovementHandler> getSortedHandlersForMovement(boolean placing) {
        HashMap<IMovementHandler, HandlingPriority.Priority> handlers = new HashMap<IMovementHandler, HandlingPriority.Priority>();
        for (IMovementHandler h : this.getRegisteredHandlers()) {
            handlers.put(h, this.getPriorityForMovement(h, placing));
        }
        List<IMovementHandler> sorted = Utils.sortByPriority(handlers);
        handlers.clear();
        handlers = null;
        return sorted;
    }

    private List<IMovementHandler> getSortedHandlersForType() {
        HashMap<IMovementHandler, HandlingPriority.Priority> handlers = new HashMap<IMovementHandler, HandlingPriority.Priority>();
        for (IMovementHandler h : this.getRegisteredHandlers()) {
            handlers.put(h, this.getPriorityForType(h));
        }
        List<IMovementHandler> sorted = Utils.sortByPriority(handlers);
        handlers.clear();
        handlers = null;
        return sorted;
    }

    private HandlingPriority.Priority getPriorityForMovement(IMovementHandler handler, boolean placing) {
        try {
            Method m = null;
            m = placing ? handler.getClass().getDeclaredMethod("handleFinishMoving", IMovingBlock.class) : handler.getClass().getDeclaredMethod("handleStartMoving", IMovingBlock.class);
            if (m != null) {
                return m.getAnnotation(HandlingPriority.class).value();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return HandlingPriority.Priority.LOW;
    }

    private HandlingPriority.Priority getPriorityForType(IMovementHandler handler) {
        try {
            Method m = handler.getClass().getDeclaredMethod("getMovementType", World.class, Integer.class, Integer.class, Integer.class);
            if (m != null) {
                return m.getAnnotation(HandlingPriority.class).value();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return HandlingPriority.Priority.LOW;
    }
}

