/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.movement;

import codechicken.lib.vec.BlockCoord;
import com.amadornes.framez.movement.MovingBlock;
import com.amadornes.framez.movement.MovingStructure;
import com.amadornes.framez.tile.TileMotor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MovedBlockHandler {
    private static List<Map.Entry<World, BlockCoord>> blocks = new ArrayList<Map.Entry<World, BlockCoord>>();

    public static boolean canMoveBlockAt(World world, int x, int y, int z) {
        return MovedBlockHandler.canMoveBlockAt(world, new BlockCoord(x, y, z));
    }

    public static boolean canMoveBlockAt(World world, BlockCoord location) {
        for (Map.Entry<World, BlockCoord> e : new ArrayList<Map.Entry<World, BlockCoord>>(blocks)) {
            if (e.getKey() != world || !e.getValue().equals((Object)location)) continue;
            return false;
        }
        return true;
    }

    public static void onStructureFinishMoving(MovingStructure structure) {
        ForgeDirection dir = structure.getDirection();
        int dX = dir.offsetX;
        int dY = dir.offsetY;
        int dZ = dir.offsetZ;
        for (MovingBlock b : structure.getBlocks()) {
            blocks.add(new AbstractMap.SimpleEntry<World, BlockCoord>(structure.getWorld(), b.getLocation().copy().add(dX, dY, dZ)));
        }
    }

    public static void worldTick(World world) {
        Iterator<Map.Entry<World, BlockCoord>> iterator = new ArrayList<Map.Entry<World, BlockCoord>>(blocks).iterator();
        while (iterator.hasNext()) {
            Map.Entry<World, BlockCoord> e = iterator.next();
            if (e.getKey() != world) continue;
            iterator.remove();
        }
    }

    public boolean canMotorRun(TileMotor motor) {
        return MovedBlockHandler.canMoveBlockAt(motor.func_145831_w(), motor.field_145851_c, motor.field_145848_d, motor.field_145849_e);
    }
}

