/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.init;

import com.amadornes.framez.Framez;
import com.amadornes.framez.api.FramezApi;
import com.amadornes.framez.api.IFrameModifierProvider;
import com.amadornes.framez.api.IFrameModifierRecipe;
import com.amadornes.framez.api.IModifierRegistry;
import com.amadornes.framez.init.FramezBlocks;
import com.amadornes.framez.init.FramezItems;
import com.amadornes.framez.util.SorterModifierProvider;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Recipes {
    public static void init() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FramezItems.framepart, 5, 0), new Object[]{"s s", " s ", "s s", Character.valueOf('s'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FramezItems.framepart, 1, 1), new Object[]{" s ", "scs", " s ", Character.valueOf('s'), "stickWood", Character.valueOf('c'), new ItemStack(FramezItems.framepart, 1, 0)}));
        ItemStack side = new ItemStack(FramezItems.framepart, 1, 1);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(FramezApi.inst().getModifierRegistry().getFrameStack(8, new String[0]), new Object[]{side, side, side, side, side, side}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FramezItems.framepart, 5, 2), new Object[]{"s s", " s ", "s s", Character.valueOf('s'), "stickIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FramezItems.framepart, 1, 3), new Object[]{" s ", "scs", " s ", Character.valueOf('s'), "stickIron", Character.valueOf('c'), new ItemStack(FramezItems.framepart, 1, 2)}));
        side = new ItemStack(FramezItems.framepart, 1, 3);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(FramezApi.inst().getModifierRegistry().getFrameStack(8, "iron"), new Object[]{side, side, side, side, side, side}));
        if (FramezItems.ironstick != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FramezItems.ironstick, 4), new Object[]{"i", "i", Character.valueOf('i'), "ingotIron"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FramezBlocks.motorcore), new Object[]{"rsr", "sRs", "rsr", Character.valueOf('r'), "dustRedstone", Character.valueOf('R'), "blockRedstone", Character.valueOf('s'), "stone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FramezItems.wrench), new Object[]{" i ", " si", "s  ", Character.valueOf('s'), "stickWood", Character.valueOf('i'), "stickIron"}));
        Framez.log.info("Starting to generate recipes!");
        Recipes.generateFrameRecipes();
        Framez.log.info("Finished generating recipes!");
    }

    private static void generateFrameRecipes() {
        IModifierRegistry reg = FramezApi.inst().getModifierRegistry();
        for (ItemStack frame : reg.getAllPossibleCombinations()) {
            Framez.log.debug("Generating recipes for " + frame.field_77990_d);
            for (IFrameModifierProvider m : reg.getModifiers(frame)) {
                Framez.log.debug(" Without " + m.getIdentifier());
                IFrameModifierRecipe recipe = m.getRecipeProvider();
                Framez.log.debug("   Recipe: " + recipe);
                if (recipe == null) continue;
                ItemStack without = Recipes.getWithoutModifier(frame, m);
                Framez.log.debug("   NoMod: " + without);
                if (without == null) continue;
                ArrayList<Object> r = new ArrayList<Object>();
                HashMap<Object, Character> chars = new HashMap<Object, Character>();
                char c = '0';
                int frames = 0;
                for (int x = 0; x < 3; ++x) {
                    String row = "";
                    for (int y = 0; y < 3; ++y) {
                        int slot = x + y * 3;
                        Object o = recipe.getItemInCraftingSlot(slot);
                        if (recipe.isShapeless()) {
                            if (o == null) continue;
                            if (o instanceof Boolean) {
                                r.add(without);
                                ++frames;
                                continue;
                            }
                            r.add(o);
                            continue;
                        }
                        if (o == null) {
                            row = row + " ";
                            continue;
                        }
                        if (o instanceof Boolean) {
                            row = row + "x";
                            if (!chars.containsKey(o)) {
                                chars.put(without, Character.valueOf('x'));
                            }
                            ++frames;
                            continue;
                        }
                        if (chars.containsKey(o)) {
                            row = row + chars.get(o);
                            continue;
                        }
                        chars.put(o, Character.valueOf(c));
                        row = row + "" + c;
                        c = (char)(c + '\u0001');
                    }
                    if (recipe.isShapeless()) continue;
                    r.add(row);
                }
                Framez.log.debug("   Frames: " + frames);
                if (frames == 0) {
                    r.clear();
                    chars.clear();
                    continue;
                }
                if (!recipe.isShapeless()) {
                    for (Object o : chars.keySet()) {
                        r.add(Character.valueOf(((Character)chars.get(o)).charValue()));
                        r.add(o);
                    }
                }
                if (recipe.isShapeless()) {
                    if (recipe.shouldReturnAllFrames()) {
                        ItemStack is = frame.func_77946_l();
                        is.field_77994_a = frames;
                        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(is, r.toArray()));
                    } else {
                        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(frame.func_77946_l(), r.toArray()));
                    }
                } else {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(frame.func_77946_l(), r.toArray()));
                }
                Framez.log.debug("   ADDED!!! :D");
            }
        }
    }

    private static ItemStack getWithoutModifier(ItemStack frame, IFrameModifierProvider modifier) {
        IModifierRegistry reg = FramezApi.inst().getModifierRegistry();
        ArrayList<IFrameModifierProvider> modifiers = new ArrayList<IFrameModifierProvider>();
        modifiers.addAll(Arrays.asList(reg.getModifiers(frame)));
        modifiers.remove(modifier);
        Collections.sort(modifiers, new SorterModifierProvider());
        String[] mods = new String[modifiers.size()];
        int i = 0;
        for (IFrameModifierProvider p : modifiers) {
            mods[i] = p.getIdentifier();
            ++i;
        }
        return reg.getFrameStack(mods);
    }
}

