/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.compat.pc;

import com.amadornes.framez.config.Config;
import com.amadornes.framez.tile.TileMotor;
import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.tileentity.AirHandlerSupplier;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IPneumaticMachine;

public class TileMotorPC
extends TileMotor
implements IPneumaticMachine {
    private IAirHandler handler;
    private double oldPower;

    @Override
    public boolean shouldMove() {
        return this.isBeingPowered();
    }

    @Override
    public boolean hasEnoughFramezPower(double power) {
        return (double)this.handler.getPressure(ForgeDirection.UNKNOWN) >= power;
    }

    @Override
    public double getMovementSpeed() {
        return 1.0;
    }

    @Override
    public void consumeFramezPower(double power) {
        this.getAirHandler().addAir(-((int)(power * Config.PowerRatios.pcPressure)), ForgeDirection.UNKNOWN);
        this.stored = (double)this.getAirHandler().getCurrentAir(ForgeDirection.UNKNOWN) / (double)this.getAirHandler().getMaxPressure() * this.maxStored;
    }

    @Override
    public Map.Entry<Double, Double> getExtraInfo() {
        return new AbstractMap.SimpleEntry<Double, Double>(Double.valueOf(this.getAirHandler().getMaxPressure()), Double.valueOf(this.getAirHandler().getPressure(ForgeDirection.UNKNOWN)));
    }

    @Override
    public void writeUpdatePacket(NBTTagCompound tag) {
        super.writeUpdatePacket(tag);
        this.getAirHandler().writeToNBTI(tag);
    }

    @Override
    public void readUpdatePacket(NBTTagCompound tag) {
        super.readUpdatePacket(tag);
        this.getAirHandler().readFromNBTI(tag);
    }

    public IAirHandler getAirHandler() {
        this.initializeAirHandlerIfNeeded();
        return this.handler;
    }

    public boolean isConnectedTo(ForgeDirection dir) {
        return this.getFace() != dir;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.getAirHandler().updateEntityI();
        this.oldPower = this.stored;
        this.stored = (double)this.getAirHandler().getCurrentAir(ForgeDirection.UNKNOWN) / (double)this.getAirHandler().getMaxPressure() * this.maxStored;
        if (this.stored != this.oldPower) {
            this.sendUpdatePacket();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.getAirHandler().validateI((TileEntity)this);
    }

    private void initializeAirHandlerIfNeeded() {
        if (this.handler == null) {
            this.handler = AirHandlerSupplier.getAirHandler((float)20.0f, (float)25.0f, (int)20000);
        }
    }
}

