/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.amtgenerators.tileentity;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glassmaker.amtgenerators.networking.NetworkHandler;
import glassmaker.amtgenerators.networking.message.MessageGeneratorRunning;
import glassmaker.amtgenerators.networking.message.MessageUpdateManaTransHud;
import glassmaker.amtgenerators.tileentity.TileEntityBaseGenerator;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.botania.api.mana.IManaReceiver;

@Optional.Interface(modid="Botania", iface="vazkii.botania.api.mana.IManaReceiver")
public class TileEntityManaTransformer
extends TileEntityBaseGenerator
implements IManaReceiver {
    private int currentMana = 0;
    private int maxMana = 1000;
    private int ticks = 0;
    private static final int TRANSFORM_RATE = 20;
    private static final double MANA_EXCHANGE_RATE = 1.5;
    private static final int TICKS_PER_OPERATION = 4;
    private boolean active = false;
    private boolean barsVisiable = false;
    private int lastMana = 0;
    private int lastCharge = 0;

    public TileEntityManaTransformer() {
        super(26500);
    }

    @Optional.Method(modid="Botania")
    public int getCurrentMana() {
        return this.currentMana;
    }

    @Optional.Method(modid="Botania")
    public boolean isFull() {
        return this.currentMana >= this.maxMana;
    }

    @Optional.Method(modid="Botania")
    public void recieveMana(int mana) {
        this.currentMana += mana;
        if (this.currentMana < 0) {
            this.currentMana = 0;
        }
        if (this.currentMana > this.maxMana) {
            this.currentMana = this.maxMana;
        }
    }

    @Optional.Method(modid="Botania")
    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        nbtTag.func_74768_a("currentMana", this.currentMana);
        nbtTag.func_74757_a("active", this.active);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        this.currentMana = nbtTag.func_74762_e("currentMana");
        this.active = nbtTag.func_74767_n("active");
    }

    public void func_145845_h() {
        boolean transforming;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = transforming = this.currentCharge < this.maxCharge && this.currentMana >= 20;
        if (this.ticks > 4) {
            if (transforming && this.active) {
                this.currentMana -= 20;
                if (this.currentMana < 0) {
                    this.currentMana = 0;
                }
                this.currentCharge = (int)((double)this.currentCharge + 30.0);
                if (this.currentCharge > this.maxCharge) {
                    this.currentCharge = this.maxCharge;
                }
            }
            if (this.isRunning() != (transforming && this.active)) {
                this.setRunning(transforming && this.active);
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0);
                NetworkHandler.CHANNEL.sendToAllAround((IMessage)new MessageGeneratorRunning(this), point);
            }
            this.ticks = 0;
        }
        ++this.ticks;
    }

    public void toggleActive() {
        this.active = !this.active;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void sendSyncStorage() {
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0);
        NetworkHandler.CHANNEL.sendToAllAround((IMessage)new MessageUpdateManaTransHud(this), point);
    }

    @SideOnly(value=Side.CLIENT)
    public void syncStorage(int mana, int charge) {
        this.barsVisiable = true;
        this.lastMana = mana;
        this.lastCharge = charge;
    }

    @SideOnly(value=Side.CLIENT)
    public int scaleMana(int scale) {
        return this.lastMana > 0 ? (int)Math.floor(this.lastMana * scale / this.maxMana) : 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int scaleCurrentCharge(int scale) {
        return this.lastCharge > 0 ? (int)Math.floor(this.lastCharge * scale / this.maxCharge) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean areBarsVisiable() {
        return this.barsVisiable;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isActive() {
        return this.active;
    }
}

