/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.amtgenerators.tileentity;

import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import glassmaker.amtgenerators.networking.NetworkHandler;
import glassmaker.amtgenerators.networking.message.MessageGeneratorRunning;
import glassmaker.amtgenerators.tileentity.TileEntityBaseGenerator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

@Optional.Interface(modid="AWWayofTime", iface="WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler")
public class TileEntityLPTransformer
extends TileEntityBaseGenerator {
    private int maxEsseance = 1000;
    private int currentEssance = 0;
    private int SyphonRate = 40;
    private static final int TRANSFORM_RATE = 20;
    private static final double ESSEANCE_EXCHANGE_RATE = 0.5;
    private int ticks = 0;
    private static final int TICKS_PER_OPERATION = 20;
    private boolean active = false;
    private String ownerName = "";

    public TileEntityLPTransformer() {
        super(26500);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        nbtTag.func_74768_a("currentEsseance", this.currentEssance);
        nbtTag.func_74768_a("ticks", this.ticks);
        nbtTag.func_74757_a("active", this.active);
        nbtTag.func_74778_a("ownerName", this.ownerName);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        this.currentEssance = nbtTag.func_74762_e("currentEsseance");
        this.ticks = nbtTag.func_74762_e("ticks");
        this.active = nbtTag.func_74767_n("active");
        this.ownerName = nbtTag.func_74779_i("ownerName");
    }

    @Optional.Method(modid="AWWayofTime")
    public void setOwner(EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        if (this.isOwnerSet() && !this.isOwner(player)) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.amtgen.notOwnerMessage", new Object[0]));
            this.field_145850_b.func_72956_a((Entity)player, "random.eat", 0.5f + 0.5f * (float)player.func_70681_au().nextInt(2), (player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.07f);
            SoulNetworkHandler.hurtPlayer((EntityPlayer)player, (float)3.0f);
            return;
        }
        this.ownerName = SoulNetworkHandler.getUsername((EntityPlayer)player);
        player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.amtgen.newOwnerMessage", new Object[]{this.ownerName}));
        SoulNetworkHandler.hurtPlayer((EntityPlayer)player, (float)1.0f);
    }

    @Optional.Method(modid="AWWayofTime")
    public boolean isOwner(EntityPlayerMP player) {
        return player != null ? SoulNetworkHandler.getUsername((EntityPlayer)player).equals(this.ownerName) : false;
    }

    public boolean isOwnerSet() {
        return !this.ownerName.equals("");
    }

    public void toggleActity() {
        this.active = !this.active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void showStats(EntityPlayerMP player) {
        if (!this.isOwner(player)) {
            return;
        }
        player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.amtgen.lpStats", new Object[]{this.currentEssance}));
        player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.amtgen.chargeStats", new Object[]{this.currentCharge}));
    }

    @Optional.Method(modid="AWWayofTime")
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.ticks > 20) {
            this.ticks = 0;
            boolean transformed = false;
            if (this.isOwnerSet() && this.currentCharge < this.maxCharge && this.active) {
                int drained = 0;
                if (this.currentEssance < this.maxEsseance) {
                    drained = SoulNetworkHandler.syphonFromNetwork((String)this.ownerName, (int)this.SyphonRate);
                }
                if (drained <= 0 && this.currentEssance < 20) {
                    SoulNetworkHandler.causeNauseaToPlayer((String)this.ownerName);
                } else {
                    this.currentEssance += drained;
                    if (this.currentEssance > this.maxEsseance) {
                        this.currentEssance = this.maxEsseance;
                    }
                    this.currentEssance -= 20;
                    if (this.currentEssance < 0) {
                        this.currentEssance = 0;
                    }
                    this.currentCharge = (int)((double)this.currentCharge + 10.0);
                    if (this.currentCharge > this.maxCharge) {
                        this.currentCharge = this.maxCharge;
                    }
                    transformed = true;
                }
            }
            boolean transforming = this.currentCharge < this.maxCharge && transformed;
            if (this.isRunning() != (transforming && this.active)) {
                this.setRunning(transforming && this.active);
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0);
                NetworkHandler.CHANNEL.sendToAllAround((IMessage)new MessageGeneratorRunning(this), point);
            }
        }
        ++this.ticks;
    }
}

