/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.amtgenerators.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glassmaker.amtgenerators.AmtGenerators;
import glassmaker.amtgenerators.tileentity.TileEntityBaseGenerator;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockBaseGenerator
extends BlockContainer {
    private IIcon icon_front;
    private IIcon icon_on;
    private IIcon icon_side;
    private IIcon icon_top;
    private IIcon icon_bottom;
    private String base_texture_name;

    protected BlockBaseGenerator(Material material) {
        super(material);
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
        this.func_149647_a(AmtGenerators.amtgenCreativeTab);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase livingEntity, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, livingEntity, itemStack);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null || !(tileEntity instanceof TileEntityBaseGenerator)) {
            return;
        }
        int facing = MathHelper.func_76128_c((double)((double)(livingEntity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 0: {
                facing = 2;
                break;
            }
            case 1: {
                facing = 5;
                break;
            }
            case 2: {
                facing = 3;
                break;
            }
            case 3: {
                facing = 4;
                break;
            }
            default: {
                facing = 2;
            }
        }
        ((TileEntityBaseGenerator)tileEntity).setFacing(facing);
    }

    protected void setBaseTextureName(String textureName) {
        this.base_texture_name = "amtgen:" + textureName;
        this.func_149658_d(this.base_texture_name + "_front");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icon_front = register.func_94245_a(this.base_texture_name + "_front");
        this.icon_on = register.func_94245_a(this.base_texture_name + "_on");
        this.icon_side = register.func_94245_a(this.base_texture_name + "_side");
        this.icon_top = register.func_94245_a(this.base_texture_name + "_top");
        this.icon_bottom = register.func_94245_a(this.base_texture_name + "_bottom");
        super.func_149651_a(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return this.icon_bottom;
        }
        if (side == 1) {
            return this.icon_top;
        }
        if (side == 3) {
            return this.icon_front;
        }
        return this.icon_side;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        int facing = ((TileEntityBaseGenerator)tileEntity).getFacing();
        boolean running = ((TileEntityBaseGenerator)tileEntity).isRunning();
        if (side == 0) {
            return this.icon_bottom;
        }
        if (side == 1) {
            return this.icon_top;
        }
        if (side == facing) {
            if (running) {
                return this.icon_on;
            }
            return this.icon_front;
        }
        return this.icon_side;
    }
}

