/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.block.IBlock;
import minetweaker.api.block.IBlockPattern;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.api.ReplacementBlock;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mfr.Planter")
@ModOnly(value={"MineFactoryReloaded"})
public class Planter {
    private static final IBlockPattern GRASS_OR_DIRT;

    @ZenMethod
    public static void addPlantable(IItemStack seed, @Optional IBlockPattern canPlantOn) {
        IBlock block = seed.asBlock();
        if (block == null) {
            MineTweakerAPI.logError("The given seed has no block equivalant");
        }
        Planter.addPlantable(seed, block, canPlantOn);
    }

    @ZenMethod
    public static void addPlantable(IIngredient seed, IBlock block, @Optional IBlockPattern canPlantOn) {
        if (canPlantOn == null) {
            canPlantOn = GRASS_OR_DIRT;
        }
        if (seed.getItems() == null) {
            MineTweakerAPI.logError("Seed must be a defined ingredient and cannot be <*>");
        } else {
            MineTweakerAPI.apply(new AddPlantableAction(new TweakerPlantable(seed, block, canPlantOn)));
        }
    }

    @ZenMethod
    public static void removePlantable(IIngredient seed) {
        MineTweakerAPI.apply(new RemovePlantableAction(seed));
    }

    static {
        IBlock blockDirt = MineTweakerMC.getBlockAnyMeta((Block)Block.field_149771_c.func_82594_a("minecraft:dirt"));
        IBlock blockGrass = MineTweakerMC.getBlockAnyMeta((Block)Block.field_149771_c.func_82594_a("minecraft:grass"));
        GRASS_OR_DIRT = blockDirt.or(blockGrass);
    }

    private static class RemovePlantableAction
    implements IUndoableAction {
        private final IIngredient seed;
        private final Map<Item, IFactoryPlantable> removed;

        private RemovePlantableAction(IIngredient seed) {
            this.seed = seed;
            this.removed = new HashMap<Item, IFactoryPlantable>();
            for (IItemStack iItem : seed.getItems()) {
                Item item = MineTweakerMC.getItemStack(iItem).func_77973_b();
                if (this.removed.containsKey(item) || !MFRRegistry.getPlantables().containsKey(item)) continue;
                this.removed.put(item, (IFactoryPlantable)MFRRegistry.getPlantables().get(item));
            }
        }

        @Override
        public void apply() {
            for (Item seedItem : this.removed.keySet()) {
                MFRRegistry.getPlantables().remove(seedItem);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            for (Map.Entry<Item, IFactoryPlantable> removedEntry : this.removed.entrySet()) {
                MFRRegistry.getPlantables().put(removedEntry.getKey(), removedEntry.getValue());
            }
        }

        @Override
        public String describe() {
            return "Removing MFR Planter seed " + this.seed;
        }

        @Override
        public String describeUndo() {
            return "Restoring MFR Planter seed " + this.seed;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddPlantableAction
    implements IUndoableAction {
        private final TweakerPlantable plantable;

        private AddPlantableAction(TweakerPlantable plantable) {
            this.plantable = plantable;
        }

        @Override
        public void apply() {
            for (IItemStack iitem : this.plantable.seed.getItems()) {
                Item item = MineTweakerMC.getItemStack(iitem).func_77973_b();
                if (MFRRegistry.getPlantables().containsKey(item)) {
                    IFactoryPlantable existing = (IFactoryPlantable)MFRRegistry.getPlantables().get(item);
                    if (existing instanceof TweakerPlantablePartial) {
                        ((TweakerPlantablePartial)existing).plantables.add(this.plantable);
                        continue;
                    }
                    MineTweakerAPI.logError("Existing non-MineTweaker plantable already exists for seed ID " + Item.field_150901_e.func_148750_c((Object)item));
                    continue;
                }
                MFRRegistry.registerPlantable((IFactoryPlantable)new TweakerPlantablePartial(item, this.plantable));
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            for (IItemStack iItem : this.plantable.seed.getItems()) {
                Item item = MineTweakerMC.getItemStack(iItem).func_77973_b();
                IFactoryPlantable existing = (IFactoryPlantable)MFRRegistry.getPlantables().get(item);
                if (!(existing instanceof TweakerPlantablePartial)) continue;
                ((TweakerPlantablePartial)existing).plantables.remove(this.plantable);
            }
        }

        @Override
        public String describe() {
            return "Adding MFR Plantable for seed " + this.plantable.seed;
        }

        @Override
        public String describeUndo() {
            return "Removing MFR Plantable for seed " + this.plantable.seed;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class TweakerPlantablePartial
    implements IFactoryPlantable {
        private final Item seed;
        private final List<TweakerPlantable> plantables;

        public TweakerPlantablePartial(Item seed) {
            this.seed = seed;
            this.plantables = new ArrayList<TweakerPlantable>();
        }

        public TweakerPlantablePartial(Item seed, TweakerPlantable plantable) {
            this(seed);
            this.plantables.add(plantable);
        }

        public Item getSeed() {
            return this.seed;
        }

        public boolean canBePlanted(ItemStack is, boolean bln) {
            IItemStack iSeed = MineTweakerMC.getIItemStack(is);
            for (TweakerPlantable plantable : this.plantables) {
                if (!plantable.seed.matches(iSeed)) continue;
                return true;
            }
            return false;
        }

        public ReplacementBlock getPlantedBlock(World world, int i, int i1, int i2, ItemStack seed) {
            IItemStack iSeed = MineTweakerMC.getIItemStack(seed);
            for (TweakerPlantable plantable : this.plantables) {
                if (!plantable.seed.matches(iSeed)) continue;
                return new ReplacementBlock(MineTweakerMC.getBlock(plantable.block)).setMeta(plantable.block.getMeta());
            }
            return null;
        }

        public boolean canBePlantedHere(World world, int x, int y, int z, ItemStack seed) {
            if (!world.func_147437_c(x, y, z)) {
                return false;
            }
            for (TweakerPlantable plantable : this.plantables) {
                if (!plantable.seed.matches(MineTweakerMC.getIItemStack(seed))) {
                    return false;
                }
                if (plantable.canPlantOn.matches(MineTweakerMC.getBlock((IBlockAccess)world, x, y - 1, z))) continue;
                return false;
            }
            return true;
        }

        public void prePlant(World world, int i, int i1, int i2, ItemStack is) {
        }

        public void postPlant(World world, int i, int i1, int i2, ItemStack is) {
        }
    }

    private static class TweakerPlantable {
        private final IIngredient seed;
        private final IBlock block;
        private final IBlockPattern canPlantOn;

        public TweakerPlantable(IIngredient seed, IBlock block, IBlockPattern canPlantOn) {
            this.seed = seed;
            this.block = block;
            this.canPlantOn = canPlantOn;
        }
    }
}

