/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.gregtech.machines;

import gregtech.api.GregTech_API;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Sonictron")
@ModOnly(value={"gregtech"})
public class Sonictron {
    @ZenMethod
    public static void addSound(IItemStack itemStack, String soundName) {
        MineTweakerAPI.apply(new AddSoundAction(itemStack, soundName));
    }

    private static class AddSoundAction
    extends OneWayAction {
        private final IItemStack itemStack;
        private final String soundName;

        public AddSoundAction(IItemStack itemStack, String soundName) {
            this.itemStack = itemStack;
            this.soundName = soundName;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addSonictronSound(MineTweakerMC.getItemStack(this.itemStack), this.soundName);
        }

        @Override
        public String describe() {
            return "Adding sonictron sound " + this.soundName;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.itemStack != null ? this.itemStack.hashCode() : 0);
            hash = 79 * hash + (this.soundName != null ? this.soundName.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddSoundAction other = (AddSoundAction)obj;
            if (!(this.itemStack == other.itemStack || this.itemStack != null && this.itemStack.equals(other.itemStack))) {
                return false;
            }
            return !(this.soundName == null ? other.soundName != null : !this.soundName.equals(other.soundName));
        }
    }
}

