/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.oredict;

import java.util.List;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientOr;
import minetweaker.api.item.IngredientStack;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.api.player.IPlayer;
import minetweaker.util.ArrayUtil;

public class IngredientOreDict
implements IIngredient {
    private final IOreDictEntry entry;
    private final String mark;
    private final IItemCondition[] conditions;
    private final IItemTransformer[] transformers;

    public IngredientOreDict(IOreDictEntry entry, String mark, IItemCondition[] conditions, IItemTransformer[] transformers) {
        this.entry = entry;
        this.mark = mark;
        this.conditions = conditions;
        this.transformers = transformers;
    }

    @Override
    public String getMark() {
        return this.mark;
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public List<IItemStack> getItems() {
        return this.entry.getItems();
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this, amount);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientOreDict(this.entry, this.mark, this.conditions, ArrayUtil.append(this.transformers, transformer));
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientOreDict(this.entry, this.mark, ArrayUtil.append(this.conditions, condition), this.transformers);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientOreDict(this.entry, mark, this.conditions, this.transformers);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        if (!this.entry.matches(item)) {
            return false;
        }
        for (IItemCondition condition : this.conditions) {
            if (condition.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        return this.entry.contains(ingredient);
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        for (IItemTransformer transformer : this.transformers) {
            item = transformer.transform(item, byPlayer);
        }
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return this.transformers.length > 0;
    }

    @Override
    public Object getInternal() {
        return this.entry.getInternal();
    }
}

