/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.GT_Packet_Block_Event;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class BaseTileEntity
extends TileEntity
implements IHasWorldObjectAndCoords {
    public boolean ignoreUnloadedChunks = true;
    public boolean isDead = false;
    private final TileEntity[] mBufferedTileEntities = new TileEntity[6];

    private final void clearNullMarkersFromTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            if (this.mBufferedTileEntities[i] != this) continue;
            this.mBufferedTileEntities[i] = null;
        }
    }

    protected final void clearTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            this.mBufferedTileEntities[i] = null;
        }
    }

    @Override
    public final World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public final int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public final short getYCoord() {
        return (short)this.field_145848_d;
    }

    @Override
    public final int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public final int getOffsetX(byte aSide, int aMultiplier) {
        return this.field_145851_c + ForgeDirection.getOrientation((int)aSide).offsetX * aMultiplier;
    }

    @Override
    public final short getOffsetY(byte aSide, int aMultiplier) {
        return (short)(this.field_145848_d + ForgeDirection.getOrientation((int)aSide).offsetY * aMultiplier);
    }

    @Override
    public final int getOffsetZ(byte aSide, int aMultiplier) {
        return this.field_145849_e + ForgeDirection.getOrientation((int)aSide).offsetZ * aMultiplier;
    }

    @Override
    public final boolean isServerSide() {
        return !this.field_145850_b.field_72995_K;
    }

    @Override
    public final boolean isClientSide() {
        return this.field_145850_b.field_72995_K;
    }

    @Override
    public final boolean openGUI(EntityPlayer aPlayer) {
        return this.openGUI(aPlayer, 0);
    }

    @Override
    public final boolean openGUI(EntityPlayer aPlayer, int aID) {
        if (aPlayer == null) {
            return false;
        }
        aPlayer.openGui((Object)GregTech_API.gregtech, aID, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public final int getRandomNumber(int aRange) {
        return this.field_145850_b.field_73012_v.nextInt(aRange);
    }

    @Override
    public final BiomeGenBase getBiome(int aX, int aZ) {
        return this.field_145850_b.func_72807_a(aX, aZ);
    }

    @Override
    public final BiomeGenBase getBiome() {
        return this.getBiome(this.field_145851_c, this.field_145849_e);
    }

    @Override
    public final Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final Block getBlockAtSide(byte aSide) {
        return this.getBlockAtSideAndDistance(aSide, 1);
    }

    @Override
    public final Block getBlockAtSideAndDistance(byte aSide, int aDistance) {
        return this.getBlock(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final byte getMetaIDOffset(int aX, int aY, int aZ) {
        return this.getMetaID(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final byte getMetaIDAtSide(byte aSide) {
        return this.getMetaIDAtSideAndDistance(aSide, 1);
    }

    @Override
    public final byte getMetaIDAtSideAndDistance(byte aSide, int aDistance) {
        return this.getMetaID(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final byte getLightLevelOffset(int aX, int aY, int aZ) {
        return this.getLightLevel(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final byte getLightLevelAtSide(byte aSide) {
        return this.getLightLevelAtSideAndDistance(aSide, 1);
    }

    @Override
    public final byte getLightLevelAtSideAndDistance(byte aSide, int aDistance) {
        return this.getLightLevel(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final boolean getOpacityOffset(int aX, int aY, int aZ) {
        return this.getOpacity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final boolean getOpacityAtSide(byte aSide) {
        return this.getOpacityAtSideAndDistance(aSide, 1);
    }

    @Override
    public final boolean getOpacityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getOpacity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final boolean getSkyAtSide(byte aSide) {
        return this.getSkyAtSideAndDistance(aSide, 1);
    }

    @Override
    public final boolean getSkyAtSideAndDistance(byte aSide, int aDistance) {
        return this.getSky(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final boolean getAirAtSide(byte aSide) {
        return this.getAirAtSideAndDistance(aSide, 1);
    }

    @Override
    public final boolean getAirAtSideAndDistance(byte aSide, int aDistance) {
        return this.getAir(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.getTileEntity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final TileEntity getTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        if (aDistance == 1) {
            return this.getTileEntityAtSide(aSide);
        }
        return this.getTileEntity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final IInventory getIInventory(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainer(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntity(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final Block getBlock(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return Blocks.field_150350_a;
        }
        return this.field_145850_b.func_147439_a(aX, aY, aZ);
    }

    @Override
    public final byte getMetaID(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return 0;
        }
        return (byte)this.field_145850_b.func_72805_g(aX, aY, aZ);
    }

    @Override
    public final byte getLightLevel(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return 0;
        }
        return (byte)(this.field_145850_b.func_72801_o(aX, aY, aZ) * 15.0f);
    }

    @Override
    public final boolean getSky(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return true;
        }
        return this.field_145850_b.func_72937_j(aX, aY, aZ);
    }

    @Override
    public final boolean getOpacity(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return false;
        }
        return GT_Utility.isOpaqueBlock((World)this.field_145850_b, (int)aX, (int)aY, (int)aZ);
    }

    @Override
    public final boolean getAir(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return true;
        }
        return GT_Utility.isAirBlock((World)this.field_145850_b, (int)aX, (int)aY, (int)aZ);
    }

    @Override
    public final TileEntity getTileEntity(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return null;
        }
        return this.field_145850_b.func_147438_o(aX, aY, aZ);
    }

    @Override
    public final TileEntity getTileEntityAtSide(byte aSide) {
        if (aSide < 0 || aSide >= 6 || this.mBufferedTileEntities[aSide] == this) {
            return null;
        }
        int tX = this.getOffsetX(aSide, 1);
        short tY = this.getOffsetY(aSide, 1);
        int tZ = this.getOffsetZ(aSide, 1);
        if (this.crossedChunkBorder(tX, tZ)) {
            this.mBufferedTileEntities[aSide] = null;
            if (this.ignoreUnloadedChunks && !this.field_145850_b.func_72899_e(tX, (int)tY, tZ)) {
                return null;
            }
        }
        if (this.mBufferedTileEntities[aSide] == null) {
            this.mBufferedTileEntities[aSide] = this.field_145850_b.func_147438_o(tX, (int)tY, tZ);
            if (this.mBufferedTileEntities[aSide] == null) {
                this.mBufferedTileEntities[aSide] = this;
                return null;
            }
            return this.mBufferedTileEntities[aSide];
        }
        if (this.mBufferedTileEntities[aSide].func_145837_r()) {
            this.mBufferedTileEntities[aSide] = null;
            return this.getTileEntityAtSide(aSide);
        }
        if (this.mBufferedTileEntities[aSide].field_145851_c == tX && this.mBufferedTileEntities[aSide].field_145848_d == tY && this.mBufferedTileEntities[aSide].field_145849_e == tZ) {
            return this.mBufferedTileEntities[aSide];
        }
        return null;
    }

    public void func_145841_b(NBTTagCompound aNBT) {
        super.func_145841_b(aNBT);
    }

    @Override
    public boolean isDead() {
        return this.isDead || this.isInvalidTileEntity();
    }

    public void func_145829_t() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145829_t();
    }

    public void func_145843_s() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.onChunkUnload();
        this.isDead = true;
    }

    public void func_145845_h() {
        this.isDead = false;
    }

    public final void onAdjacentBlockChange(int aX, int aY, int aZ) {
        this.clearNullMarkersFromTileEntityBuffer();
    }

    @Override
    public final void sendBlockEvent(byte aID, byte aValue) {
        GregTech_API.sNetworkHandler.sendPacketToAllPlayersInRange(this.field_145850_b, (GT_Packet)new GT_Packet_Block_Event(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, aID, aValue), this.field_145851_c, this.field_145849_e);
    }

    private boolean crossedChunkBorder(int aX, int aZ) {
        return aX >> 4 != this.field_145851_c >> 4 || aZ >> 4 != this.field_145849_e >> 4;
    }
}

