/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.recipes.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.aobd.items.AOBDItemBlock;
import ganymedes01.aobd.lib.CompatType;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobd.recipes.RecipesModule;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.Smeltery;
import tconstruct.smeltery.TinkerSmeltery;

public class TinkersConstruct
extends RecipesModule {
    public TinkersConstruct() {
        super(CompatType.TINKERS_CONSTRUCT, "iron", "gold", "aluminium", "cobalt", "ardite", "platinum", "nickel", "silver", "lead", "copper", "tin", "steel", "endium");
    }

    @Override
    public void initOre(Ore ore) {
        Fluid fluid = this.getFluid(ore);
        int temp = (int)ore.energy(600.0);
        int blockLiquidValue = 1296;
        int oreLiquidValue = 288;
        int ingotLiquidValue = 144;
        int nuggetLiquidValue = 16;
        ItemStack block = null;
        for (ItemStack b : OreDictionary.getOres((String)("block" + ore.name()))) {
            if (!(b.func_77973_b() instanceof ItemBlock)) continue;
            block = b;
        }
        if (block == null) {
            throw new RuntimeException("Couldn't find a block" + ore.name() + " that was actually a block. This error should not happen. Please report it!");
        }
        this.addMeltingRecipe(block, temp, new FluidStack(fluid, blockLiquidValue));
        TConstructRegistry.getBasinCasting().addCastingRecipe(block, new FluidStack(fluid, blockLiquidValue), 50);
        this.addMeltingRecipe(TinkersConstruct.getOreStack("ore", ore), temp, new FluidStack(fluid, oreLiquidValue));
        Smeltery.addMelting((ItemStack)TinkersConstruct.getOreStack("ingot", ore), (Block)Block.func_149634_a((Item)block.func_77973_b()), (int)block.func_77960_j(), (int)temp, (FluidStack)new FluidStack(fluid, ingotLiquidValue));
        TConstructRegistry.getTableCasting().addCastingRecipe(TinkersConstruct.getOreStack("ingot", ore), new FluidStack(fluid, ingotLiquidValue), new ItemStack(TinkerSmeltery.metalPattern), 50);
        this.tryAddMelting("nugget", ore, block, fluid, temp, nuggetLiquidValue);
        this.tryAddCasting("nugget", ore, new FluidStack(fluid, nuggetLiquidValue), 27);
        this.tryAddMelting("dust", ore, block, fluid, temp, ingotLiquidValue);
        this.tryAddMelting("crushed", ore, block, fluid, temp, ingotLiquidValue);
        this.tryAddMelting("cluster", ore, block, fluid, temp, 2 * ingotLiquidValue);
        if (block.func_77973_b() instanceof AOBDItemBlock) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(block, new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "ingot" + ore.name()}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkersConstruct.getOreStack("ingot", ore, 9), new Object[]{"block" + ore.name()}));
        }
    }

    private void addMeltingRecipe(ItemStack input, int temp, FluidStack output) {
        if (input.func_77973_b() instanceof ItemBlock) {
            Smeltery.addMelting((ItemStack)input, (int)temp, (FluidStack)output);
        } else {
            Smeltery.addMelting((ItemStack)input, (Block)Blocks.field_150339_S, (int)0, (int)temp, (FluidStack)output);
        }
    }

    private void tryAddMelting(String prefix, Ore ore, ItemStack block, Fluid fluid, int temp, int fluidAmount) {
        try {
            Smeltery.addMelting((ItemStack)TinkersConstruct.getOreStack(prefix, ore), (Block)Block.func_149634_a((Item)block.func_77973_b()), (int)block.func_77960_j(), (int)temp, (FluidStack)new FluidStack(fluid, fluidAmount));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void tryAddCasting(String prefix, Ore ore, FluidStack fluid, int patternMeta) {
        try {
            TConstructRegistry.getTableCasting().addCastingRecipe(TinkersConstruct.getOreStack(prefix, ore), fluid, new ItemStack(TinkerSmeltery.metalPattern, 1, patternMeta), 50);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

