/*
 * Decompiled with CFR 0.152.
 */
package ak.potionextension.asm;

import ak.potionextension.asm.PotionExtensionCorePlugin;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class PotionArrayTransformer
implements IClassTransformer,
Opcodes {
    private static final String TARGET_CLASS_NAME = "net.minecraft.potion.Potion";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.equals(TARGET_CLASS_NAME)) {
            return basicClass;
        }
        try {
            PotionExtensionCorePlugin.outputModifiedClassFile(basicClass, "Potion");
            ClassReader classReader = new ClassReader(basicClass);
            ClassWriter classWriter = new ClassWriter(1);
            classReader.accept((ClassVisitor)new CustomVisitor(name, (ClassVisitor)classWriter), 8);
            return PotionExtensionCorePlugin.outputModifiedClassFile(classWriter.toByteArray(), "Potion-mod");
        }
        catch (Exception e) {
            throw new RuntimeException("failed : PotionArrayTransformer loading", e);
        }
    }

    class CustomMethodVisitor2
    extends MethodVisitor {
        boolean check;

        public CustomMethodVisitor2(int api, MethodVisitor mv) {
            super(api, mv);
            this.check = false;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (this.check || opcode != 178 || !owner.equals("net/minecraft/potion/Potion")) {
                super.visitFieldInsn(opcode, owner, name, desc);
            } else {
                this.check = true;
                PotionExtensionCorePlugin.LOGGER.debug("init:check potion id.");
                Label l1 = new Label();
                this.visitLabel(l1);
                this.visitFieldInsn(178, "ak/potionextension/asm/PotionExtensionCorePlugin", "checkPotion", "Z");
                Label l2 = new Label();
                this.visitJumpInsn(153, l2);
                super.visitFieldInsn(opcode, owner, name, desc);
                this.visitVarInsn(21, 1);
                this.visitInsn(50);
                this.mv.visitJumpInsn(198, l2);
                Label l3 = new Label();
                this.visitLabel(l3);
                this.visitTypeInsn(187, "java/lang/IllegalArgumentException");
                this.visitInsn(89);
                this.visitLdcInsn("ID %d is already used!!");
                this.visitInsn(4);
                this.visitTypeInsn(189, "java/lang/Object");
                this.visitInsn(89);
                this.visitInsn(3);
                this.visitVarInsn(21, 0);
                this.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                this.visitInsn(83);
                this.visitMethodInsn(184, "java/lang/String", "format", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
                this.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
                this.visitInsn(191);
                this.visitLabel(l2);
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }
    }

    class CustomMethodVisitor
    extends MethodVisitor {
        static final int targetOpcode = 16;
        static final int targetOperand = 32;
        static final int newOperand = 127;

        public CustomMethodVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (16 == opcode && 32 == operand) {
                PotionExtensionCorePlugin.LOGGER.debug("Change BIPUSH 32 to BIPUSH BYTE.MAX_VALUE");
                super.visitFieldInsn(178, "ak/potionextension/asm/PotionExtensionCorePlugin", "maxPotionArray", "I");
            } else {
                super.visitIntInsn(opcode, operand);
            }
        }
    }

    class CustomVisitor
    extends ClassVisitor {
        String owner;
        static final String targetMethodName = "<clinit>";
        static final String targetMethodDesc = "()V";
        static final String targetMethodName2 = "<init>";
        static final String targetMethodDesc2 = "(IZI)V";

        public CustomVisitor(String owner, ClassVisitor cv) {
            super(262144, cv);
            this.owner = owner;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (targetMethodName.equals(name) && targetMethodDesc.equals(desc)) {
                return new CustomMethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            if (targetMethodName2.equals(name) && targetMethodDesc2.equals(desc)) {
                return new CustomMethodVisitor2(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

