/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWood;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemDrawers
extends ItemMultiTexture {
    public ItemDrawers(Block block) {
        super(block, block, BlockWood.field_150096_a);
    }

    protected ItemDrawers(Block block, String[] names) {
        super(block, block, names);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            return false;
        }
        TileEntityDrawers tile = (TileEntityDrawers)world.func_147438_o(x, y, z);
        if (tile != null) {
            if (side > 1) {
                tile.setDirection(side);
            }
            BlockDrawers block = (BlockDrawers)this.field_150939_a;
            if (tile instanceof TileEntityDrawersStandard) {
                ((TileEntityDrawersStandard)tile).setDrawerCount(block.drawerCount);
            }
            tile.setDrawerCapacity(this.getCapacityForBlock((Block)block));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        list.add(StatCollector.func_74837_a((String)"storageDrawers.drawers.description", (Object[])new Object[]{this.getCapacityForBlock(block)}));
    }

    protected int getCapacityForBlock(Block block) {
        ConfigManager config = StorageDrawers.config;
        int count = 0;
        if (!(block instanceof BlockDrawers)) {
            return 0;
        }
        BlockDrawers drawer = (BlockDrawers)block;
        if (drawer.drawerCount == 1) {
            count = config.getBlockBaseStorage("fulldrawers1");
        } else if (drawer.drawerCount == 2 && !drawer.halfDepth) {
            count = config.getBlockBaseStorage("fulldrawers2");
        } else if (drawer.drawerCount == 4 && !drawer.halfDepth) {
            count = config.getBlockBaseStorage("fulldrawers4");
        } else if (drawer.drawerCount == 2 && drawer.halfDepth) {
            count = config.getBlockBaseStorage("halfdrawers2");
        } else if (drawer.drawerCount == 4 && drawer.halfDepth) {
            count = config.getBlockBaseStorage("halfdrawers4");
        } else if (drawer.drawerCount == 3) {
            count = config.getBlockBaseStorage("compDrawers");
        }
        return count;
    }
}

