/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.ModularBoxRenderer;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelper;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class DrawersRenderer
implements ISimpleBlockRenderingHandler {
    private static final double unit = 0.0625;
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();
    private double[] boxCoord = new double[6];
    private static final int[] cut = new int[]{59, 55, 47, 31};
    private static final float[][] drawerXYWH1 = new float[][]{{0.0f, 0.0f, 16.0f, 16.0f}};
    private static final float[][] drawerXYWH2 = new float[][]{{0.0f, 8.0f, 16.0f, 8.0f}, {0.0f, 0.0f, 16.0f, 8.0f}};
    private static final float[][] drawerXYWH4 = new float[][]{{0.0f, 8.0f, 8.0f, 8.0f}, {0.0f, 0.0f, 8.0f, 8.0f}, {8.0f, 8.0f, 8.0f, 8.0f}, {8.0f, 0.0f, 8.0f, 8.0f}};
    private static final float[][] drawerXYWH3 = new float[][]{{0.0f, 8.0f, 16.0f, 8.0f}, {0.0f, 0.0f, 8.0f, 8.0f}, {8.0f, 0.0f, 8.0f, 8.0f}};

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockDrawers)) {
            return;
        }
        this.renderInventoryBlock((BlockDrawers)block, metadata, modelId, renderer);
    }

    private void renderInventoryBlock(BlockDrawers block, int metadata, int modelId, RenderBlocks renderer) {
        int side = 4;
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        for (int i = 0; i < 6; ++i) {
            this.boxRenderer.setIcon(block.func_149691_a(i, metadata), i);
        }
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        switch (side - 2) {
            case 0: {
                renderer.field_147867_u = 3;
                break;
            }
            case 1: {
                renderer.field_147867_u = 0;
                break;
            }
            case 2: {
                renderer.field_147867_u = 1;
                break;
            }
            case 3: {
                renderer.field_147867_u = 2;
            }
        }
        this.renderExterior(block, 0, 0, 0, side, renderer);
        renderer.field_147867_u = 0;
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setInteriorIcon(block.func_149691_a(side, metadata), ForgeDirection.OPPOSITES[side]);
        this.renderInterior(block, 0, 0, 0, side, renderer);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockDrawers)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockDrawers)block, modelId, renderer);
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockDrawers block, int modelId, RenderBlocks renderer) {
        TileEntityDrawers tile = block.getTileEntity(world, x, y, z);
        if (tile == null) {
            return false;
        }
        int side = tile.getDirection();
        int meta = world.func_72805_g(x, y, z);
        switch (side - 2) {
            case 0: {
                renderer.field_147867_u = 3;
                break;
            }
            case 1: {
                renderer.field_147867_u = 0;
                break;
            }
            case 2: {
                renderer.field_147867_u = 1;
                break;
            }
            case 3: {
                renderer.field_147867_u = 2;
            }
        }
        this.boxRenderer.setUnit(block.trimWidth);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        for (int i = 0; i < 6; ++i) {
            this.boxRenderer.setExteriorIcon(block.func_149673_e(world, x, y, z, i), i);
        }
        this.boxRenderer.setCutIcon(block.getIconTrim(meta));
        this.boxRenderer.setInteriorIcon(block.getIconTrim(meta));
        this.renderExterior(block, x, y, z, side, renderer);
        renderer.field_147867_u = 0;
        int maxStorageLevel = tile.getMaxStorageLevel();
        if (maxStorageLevel > 1 && StorageDrawers.config.cache.renderStorageUpgrades) {
            for (int i = 0; i < 6; ++i) {
                this.boxRenderer.setExteriorIcon(block.getOverlayIcon(world, x, y, z, i, maxStorageLevel), i);
            }
            this.boxRenderer.setCutIcon(block.getOverlayIconTrim(maxStorageLevel));
            this.boxRenderer.setInteriorIcon(block.getOverlayIconTrim(maxStorageLevel));
            this.renderExterior(block, x, y, z, side, renderer);
        }
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setInteriorIcon(block.func_149673_e(world, x, y, z, side), ForgeDirection.OPPOSITES[side]);
        this.renderInterior(block, x, y, z, side, renderer);
        if (StorageDrawers.config.cache.enableIndicatorUpgrades) {
            this.renderIndicator(block, x, y, z, side, renderer, tile.getEffectiveStatusLevel());
        }
        if (StorageDrawers.config.cache.enableLockUpgrades) {
            this.renderLock(block, x, y, z, side, renderer, tile.isLocked(LockAttribute.LOCK_POPULATED));
        }
        if (StorageDrawers.config.cache.enableVoidUpgrades) {
            this.renderVoid(block, x, y, z, side, renderer, tile.isVoid());
        }
        this.renderShroud(block, x, y, z, side, renderer, tile.isShrouded());
        return true;
    }

    private void renderLock(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer, boolean locked) {
        if (!locked) {
            return;
        }
        double depth = block.halfDepth ? 0.5 : 1.0;
        IIcon iconLock = block.getLockIcon();
        RenderHelper.instance.setRenderBounds(0.46875, 0.9375, 0.0, 0.53125, 1.0, depth + 0.005);
        RenderHelper.instance.state.setRotateTransform(3, side);
        RenderHelper.instance.renderPartialFace(3, renderer.field_147845_a, (Block)block, x, y, z, iconLock, 0.0, 0.0, 1.0, 1.0);
        RenderHelper.instance.state.clearRotateTransform();
    }

    private void renderVoid(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer, boolean voided) {
        if (!voided) {
            return;
        }
        double depth = block.halfDepth ? 0.5 : 1.0;
        IIcon iconVoid = block.getVoidIcon();
        RenderHelper.instance.setRenderBounds(0.9375, 0.9375, 0.0, 1.0, 1.0, depth + 0.005);
        RenderHelper.instance.state.setRotateTransform(3, side);
        RenderHelper.instance.renderPartialFace(3, renderer.field_147845_a, (Block)block, x, y, z, iconVoid, 0.0, 0.0, 1.0, 1.0);
        RenderHelper.instance.state.clearRotateTransform();
    }

    private void renderShroud(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer, boolean shrouded) {
        if (!shrouded || side < 2 || side > 5) {
            return;
        }
        TileEntityDrawers tile = block.getTileEntity(renderer.field_147845_a, x, y, z);
        double depth = block.halfDepth ? 8.0 : 16.0;
        double depthAdj = block.trimDepth * 16.0f;
        int count = 0;
        float w = 2.0f;
        float h = 2.0f;
        float[][] xywhSet = null;
        if (block.drawerCount == 1) {
            count = 1;
            w = 4.0f;
            h = 4.0f;
            xywhSet = drawerXYWH1;
        } else if (block.drawerCount == 2) {
            count = 2;
            xywhSet = drawerXYWH2;
        } else if (block.drawerCount == 3) {
            count = 3;
            xywhSet = drawerXYWH3;
        } else if (block.drawerCount == 4) {
            count = 4;
            xywhSet = drawerXYWH4;
        }
        IIcon icon = block.getIconTrim(renderer.field_147845_a.func_72805_g(x, y, z));
        for (int i = 0; i < count; ++i) {
            IDrawer drawer = tile.getDrawer(i);
            if (drawer == null || drawer.isEmpty()) continue;
            float[] xywh = xywhSet[i];
            float subX = xywh[0] + (xywh[2] - w) / 2.0f;
            float subY = xywh[1] + (xywh[3] - h) / 2.0f;
            this.setCoord(this.boxCoord, (double)subX * 0.0625, (double)subY * 0.0625, (depth - depthAdj) * 0.0625, (double)(subX + w) * 0.0625, (double)(subY + h) * 0.0625, (depth - depthAdj + 0.05) * 0.0625, side);
            this.boxRenderer.setExteriorIcon(icon);
            this.boxRenderer.renderExterior(renderer, (Block)block, x, y, z, this.boxCoord[0], this.boxCoord[1], this.boxCoord[2], this.boxCoord[3], this.boxCoord[4], this.boxCoord[5], 0, cut[side - 2]);
        }
    }

    private void renderIndicator(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer, int level) {
        if (level <= 0 || side < 2 || side > 5) {
            return;
        }
        TileEntityDrawers tile = block.getTileEntity(renderer.field_147845_a, x, y, z);
        double depth = block.halfDepth ? 8.0 : 16.0;
        double depthAdj = block.trimDepth * 16.0f;
        int count = 0;
        float[][] xywhSet = null;
        if (block.drawerCount == 1) {
            count = 1;
            xywhSet = drawerXYWH1;
        } else if (block.drawerCount == 2) {
            count = 2;
            xywhSet = drawerXYWH2;
        } else if (block.drawerCount == 4) {
            count = 4;
            xywhSet = drawerXYWH4;
        }
        IIcon iconOff = block.getIndicatorIcon(count, false);
        IIcon iconOn = block.getIndicatorIcon(count, true);
        for (int i = 0; i < count; ++i) {
            IDrawer drawer = tile.getDrawer(i);
            if (drawer == null) continue;
            float[] xywh = xywhSet[i];
            this.setCoord(this.boxCoord, (double)xywh[0] * 0.0625, (double)xywh[1] * 0.0625, (depth - depthAdj) * 0.0625, (double)(xywh[0] + xywh[2]) * 0.0625, (double)(xywh[1] + xywh[3]) * 0.0625, (depth - depthAdj + 0.05) * 0.0625, side);
            this.boxRenderer.setExteriorIcon(iconOff);
            this.boxRenderer.renderExterior(renderer, (Block)block, x, y, z, this.boxCoord[0], this.boxCoord[1], this.boxCoord[2], this.boxCoord[3], this.boxCoord[4], this.boxCoord[5], 0, cut[side - 2]);
            if (level == 1 && drawer.getMaxCapacity() > 0 && drawer.getRemainingCapacity() == 0) {
                this.setCoord(this.boxCoord, (double)xywh[0] * 0.0625, (double)xywh[1] * 0.0625, (depth - depthAdj) * 0.0625, (double)(xywh[0] + xywh[2]) * 0.0625, (double)(xywh[1] + xywh[3]) * 0.0625, (depth - depthAdj + 0.06) * 0.0625, side);
                this.boxRenderer.setExteriorIcon(iconOn);
                this.boxRenderer.renderExterior(renderer, (Block)block, x, y, z, this.boxCoord[0], this.boxCoord[1], this.boxCoord[2], this.boxCoord[3], this.boxCoord[4], this.boxCoord[5], 0, cut[side - 2]);
                continue;
            }
            if (level < 2) continue;
            double indStart = (double)xywh[0] + (double)block.indStart / 0.0625;
            double indEnd = (double)xywh[0] + (double)block.indEnd / 0.0625;
            double indCur = this.getIndEnd(block, tile, i, indStart, (double)(block.indEnd - block.indStart) / 0.0625);
            if (!(indCur > indStart)) continue;
            if (indCur >= indEnd) {
                indCur = xywh[0] + xywh[2];
            }
            this.setCoord(this.boxCoord, (double)xywh[0] * 0.0625, (double)xywh[1] * 0.0625, (depth - depthAdj) * 0.0625, indCur * 0.0625, (double)(xywh[1] + xywh[3]) * 0.0625, (depth - depthAdj + 0.06) * 0.0625, side);
            if (side == 2 || side == 5) {
                renderer.field_147842_e = true;
            }
            this.boxRenderer.setExteriorIcon(iconOn);
            this.boxRenderer.renderExterior(renderer, (Block)block, x, y, z, this.boxCoord[0], this.boxCoord[1], this.boxCoord[2], this.boxCoord[3], this.boxCoord[4], this.boxCoord[5], 0, cut[side - 2]);
            renderer.field_147842_e = false;
        }
    }

    private double getIndEnd(BlockDrawers block, TileEntityDrawers tile, int slot, double x, double w) {
        IDrawer drawer = tile.getDrawer(slot);
        if (drawer == null) {
            return x;
        }
        int cap = drawer.getMaxCapacity();
        int count = drawer.getStoredItemCount();
        if (cap == 0 || count == 0) {
            return x;
        }
        int step = block.indSteps > 0 ? block.indSteps : 1000;
        float fillAmt = (float)(step * count / cap) / (float)step;
        return x + w * (double)fillAmt;
    }

    private void setCoord(double[] coords, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        coords[0] = xMin;
        coords[1] = yMin;
        coords[2] = zMin;
        coords[3] = xMax;
        coords[4] = yMax;
        coords[5] = zMax;
    }

    private void setCoord(double[] coords, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, int side) {
        this.setCoord(coords, xMin, yMin, zMin, xMax, yMax, zMax);
        this.transformCoord(coords, side);
    }

    private void transformCoord(double[] coords, int side) {
        switch (side) {
            case 2: {
                double tmpX = coords[0];
                coords[0] = 1.0 - coords[3];
                coords[3] = 1.0 - tmpX;
                double tmpZ = coords[2];
                coords[2] = 1.0 - coords[5];
                coords[5] = 1.0 - tmpZ;
                return;
            }
            case 3: {
                return;
            }
            case 4: {
                double tmpX = coords[0];
                double tmpZ = coords[3];
                coords[0] = 1.0 - coords[5];
                coords[3] = 1.0 - coords[2];
                coords[2] = tmpX;
                coords[5] = tmpZ;
                return;
            }
            case 5: {
                double tmpX = coords[0];
                double tmpZ = coords[3];
                coords[0] = coords[2];
                coords[3] = coords[5];
                coords[2] = 1.0 - tmpZ;
                coords[5] = 1.0 - tmpX;
                return;
            }
        }
    }

    private void renderExterior(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer) {
        double depth = block.halfDepth ? 0.5 : 1.0;
        double xMin = 0.0;
        double xMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        switch (side) {
            case 2: {
                xMin = 0.0;
                xMax = 1.0;
                zMin = 1.0 - depth;
                zMax = 1.0;
                break;
            }
            case 3: {
                xMin = 0.0;
                xMax = 1.0;
                zMin = 0.0;
                zMax = depth;
                break;
            }
            case 4: {
                xMin = 1.0 - depth;
                xMax = 1.0;
                zMin = 0.0;
                zMax = 1.0;
                break;
            }
            case 5: {
                xMin = 0.0;
                xMax = depth;
                zMin = 0.0;
                zMax = 1.0;
            }
        }
        this.boxRenderer.renderExterior(renderer, (Block)block, x, y, z, xMin, 0.0, zMin, xMax, 1.0, zMax, 0, ModularBoxRenderer.sideCut[side]);
    }

    private void renderInterior(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer) {
        double unit = block.trimDepth;
        double depth = block.halfDepth ? 0.5 : 1.0;
        double xMin = 0.0;
        double xMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        switch (side) {
            case 2: {
                xMin = unit;
                xMax = 1.0 - unit;
                zMin = 1.0 - depth;
                zMax = 1.0 - depth + unit;
                break;
            }
            case 3: {
                xMin = unit;
                xMax = 1.0 - unit;
                zMin = depth - unit;
                zMax = depth;
                break;
            }
            case 4: {
                xMin = 1.0 - depth;
                xMax = 1.0 - depth + unit;
                zMin = unit;
                zMax = 1.0 - unit;
                break;
            }
            case 5: {
                xMin = depth - unit;
                xMax = depth;
                zMin = unit;
                zMax = 1.0 - unit;
            }
        }
        this.boxRenderer.renderInterior(renderer, (Block)block, x, y, z, xMin, unit, zMin, xMax, 1.0 - unit, zMax, 0, ModularBoxRenderer.sideCut[side]);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return StorageDrawers.proxy.drawersRenderID;
    }
}

