/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.world;

import flaxbeard.steamcraft.world.SimplexNoise;
import java.util.Random;

public abstract class NoiseGen {
    public static final int OFFSET_RANGE = 50000;
    protected final int xOffset;
    protected final int zOffset;
    protected final double scale;

    public NoiseGen(Random rand, double scale) {
        this.scale = scale;
        this.xOffset = rand.nextInt(50000) - 25000;
        this.zOffset = rand.nextInt(50000) - 25000;
    }

    public abstract double noise(double var1, double var3);

    public boolean isLessThan(double x, double z, double level) {
        return this.noise(x, z) < level;
    }

    public boolean isGreaterThan(double x, double z, double level) {
        return this.noise(x, z) > level;
    }

    public static class NoiseGenSimplex
    extends NoiseGen {
        public NoiseGenSimplex(Random rand, double scale) {
            super(rand, scale);
        }

        @Override
        public double noise(double x, double z) {
            return SimplexNoise.noise((x + (double)this.xOffset) * this.scale, (z + (double)this.zOffset) * this.scale);
        }
    }
}

