/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.IEngineerable;
import flaxbeard.steamcraft.api.ISteamChargable;
import flaxbeard.steamcraft.api.exosuit.ExosuitPlate;
import flaxbeard.steamcraft.api.exosuit.ExosuitSlot;
import flaxbeard.steamcraft.api.exosuit.IExosuitTank;
import flaxbeard.steamcraft.api.exosuit.IExosuitUpgrade;
import flaxbeard.steamcraft.api.exosuit.UtilPlates;
import flaxbeard.steamcraft.client.render.model.exosuit.ExosuitModelCache;
import flaxbeard.steamcraft.client.render.model.exosuit.ModelExosuit;
import flaxbeard.steamcraft.gui.GuiEngineeringTable;
import flaxbeard.steamcraft.handler.SteamcraftEventHandler;
import flaxbeard.steamcraft.integration.BotaniaIntegration;
import flaxbeard.steamcraft.item.BlockTankItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.MutablePair;
import vazkii.botania.api.item.IPixieSpawner;

@Optional.Interface(iface="vazkii.botania.api.item.IPixieSpawner", modid="Botania")
public class ItemExosuitArmor
extends ItemArmor
implements IPixieSpawner,
ISpecialArmor,
IEngineerable,
ISteamChargable {
    public static final ResourceLocation largeIcons = new ResourceLocation("steamcraft:textures/gui/engineering2.png");
    public int slot;
    public IIcon grey;

    public ItemExosuitArmor(int i, ItemArmor.ArmorMaterial mat) {
        super(mat, 1, i);
        this.slot = i;
        this.func_77656_e(0);
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public int getPlateReqs() {
        switch (this.slot) {
            case 0: {
                return 5;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    public String getString() {
        return this.field_111218_cA;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack.func_77973_b() == SteamcraftItems.exoArmorLegs) {
            return "steamcraft:textures/models/armor/exo_2.png";
        }
        return "steamcraft:textures/models/armor/exo_1.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        UtilPlates.registerPlatesForItem(par1IconRegister, this);
        this.grey = par1IconRegister.func_94245_a(this.field_111218_cA + "_grey");
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return this.getStackInSlot(stack, 2) != null && this.getStackInSlot(stack, 2).func_77973_b() == SteamcraftItems.enderShroud;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            return this.field_77791_bV;
        }
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("plate") && pass > 1) {
            return UtilPlates.getIconFromPlate(stack.field_77990_d.func_74779_i("plate"), this);
        }
        if (this.getStackInSlot(stack, 2) != null) {
            Item vanity = this.getStackInSlot(stack, 2).func_77973_b();
            int[] ids = OreDictionary.getOreIDs((ItemStack)this.getStackInSlot(stack, 2));
            int dye = -1;
            block0: for (int id : ids) {
                String str = OreDictionary.getOreName((int)id);
                if (!str.contains("dye")) continue;
                for (int i = 0; i < ModelExosuit.DYES.length; ++i) {
                    if (!ModelExosuit.DYES[i].equals(str.substring(3))) continue;
                    dye = 15 - i;
                    break block0;
                }
            }
            if (dye != -1) {
                return this.grey;
            }
            return this.field_77791_bV;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (this.getStackInSlot(stack, 2) != null && (pass == 1 || pass > 1 && !stack.field_77990_d.func_74764_b("plate"))) {
            Item vanity = this.getStackInSlot(stack, 2).func_77973_b();
            int[] ids = OreDictionary.getOreIDs((ItemStack)this.getStackInSlot(stack, 2));
            int dye = -1;
            block0: for (int id : ids) {
                String str = OreDictionary.getOreName((int)id);
                if (!str.contains("dye")) continue;
                for (int i = 0; i < ModelExosuit.DYES.length; ++i) {
                    if (!ModelExosuit.DYES[i].equals(str.substring(3))) continue;
                    dye = 15 - i;
                    break block0;
                }
            }
            if (dye != -1) {
                float[] color = EntitySheep.field_70898_d[dye];
                return new Color(color[0], color[1], color[2]).getRGB();
            }
        }
        return super.func_82790_a(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return null;
        }
        ModelExosuit modelExosuit = ExosuitModelCache.INSTANCE.getModel((EntityPlayer)entityLiving, armorSlot);
        modelExosuit.field_78116_c.field_78806_j = armorSlot == 0;
        modelExosuit.field_78114_d.field_78806_j = armorSlot == 0;
        modelExosuit.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
        modelExosuit.field_78112_f.field_78806_j = armorSlot == 1;
        modelExosuit.field_78113_g.field_78806_j = armorSlot == 1;
        modelExosuit.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
        modelExosuit.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
        return modelExosuit;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int armorType) {
        ItemArmor armorStack = (ItemArmor)armor.func_77973_b();
        if (armor.func_77942_o() && armor.field_77990_d.func_74764_b("plate")) {
            ExosuitPlate plate = UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate"));
            return new ISpecialArmor.ArmorProperties(0, (double)plate.getDamageReductionAmount(armorType, source) / 25.0, ItemArmor.ArmorMaterial.IRON.func_78046_a(armorType));
        }
        return new ISpecialArmor.ArmorProperties(0, (double)ItemArmor.ArmorMaterial.IRON.func_78044_b(armorType) / 25.0, ItemArmor.ArmorMaterial.IRON.func_78046_a(armorType));
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.field_77990_d.func_74764_b("steamFill")) {
            stack.field_77990_d.func_74768_a("steamFill", 0);
        }
        if (!stack.field_77990_d.func_74764_b("maxFill")) {
            stack.field_77990_d.func_74768_a("maxFill", 0);
        }
        return 1.0 - (double)stack.field_77990_d.func_74762_e("steamFill") / (double)stack.field_77990_d.func_74762_e("maxFill");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.field_77990_d.func_74764_b("maxFill")) {
            stack.field_77990_d.func_74768_a("maxFill", 0);
        }
        return stack.field_77990_d.func_74762_e("maxFill") > 0;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int armorType) {
        ItemArmor armorStack = (ItemArmor)armor.func_77973_b();
        if (armor.func_77942_o() && armor.field_77990_d.func_74764_b("plate")) {
            ExosuitPlate plate = UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate"));
            return plate.getDamageReductionAmount(armorType, DamageSource.field_76377_j);
        }
        return ItemArmor.ArmorMaterial.CLOTH.func_78044_b(armorType);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (this.slot == 1) {
            SteamcraftEventHandler.drainSteam(stack, damage * 40);
        }
    }

    @Override
    public MutablePair<Integer, Integer>[] engineerCoordinates() {
        if (this.slot == 0) {
            return new MutablePair[]{MutablePair.of((Object)1, (Object)19), MutablePair.of((Object)1, (Object)1), MutablePair.of((Object)39, (Object)16), MutablePair.of((Object)59, (Object)36)};
        }
        if (this.slot == 2) {
            return new MutablePair[]{MutablePair.of((Object)1, (Object)19), MutablePair.of((Object)1, (Object)1), MutablePair.of((Object)60, (Object)12), MutablePair.of((Object)37, (Object)40)};
        }
        if (this.slot == 1) {
            return new MutablePair[]{MutablePair.of((Object)1, (Object)19), MutablePair.of((Object)1, (Object)1), MutablePair.of((Object)49, (Object)33), MutablePair.of((Object)75, (Object)26), MutablePair.of((Object)1, (Object)37)};
        }
        if (this.slot == 3) {
            return new MutablePair[]{MutablePair.of((Object)1, (Object)19), MutablePair.of((Object)1, (Object)1), MutablePair.of((Object)60, (Object)18), MutablePair.of((Object)28, (Object)40)};
        }
        return new MutablePair[]{MutablePair.of((Object)49, (Object)26)};
    }

    public boolean hasPlates(ItemStack me) {
        if (this.getStackInSlot(me, 1) != null) {
            if (!me.func_77942_o()) {
                me.func_77982_d(new NBTTagCompound());
            }
            ItemStack clone = this.getStackInSlot(me, 1).func_77946_l();
            clone.field_77994_a = 1;
            if (UtilPlates.getPlate(clone) != null) {
                me.field_77990_d.func_74778_a("plate", UtilPlates.getPlate(clone).getIdentifier());
                return true;
            }
            if (me.field_77990_d.func_74764_b("plate")) {
                me.field_77990_d.func_82580_o("plate");
            }
            return false;
        }
        if (!me.func_77942_o()) {
            me.func_77982_d(new NBTTagCompound());
        }
        if (me.field_77990_d.func_74764_b("plate")) {
            me.field_77990_d.func_82580_o("plate");
        }
        return false;
    }

    @Override
    public ItemStack getStackInSlot(ItemStack me, int var1) {
        if (me.func_77942_o() && me.field_77990_d.func_74764_b("inv") && me.field_77990_d.func_74775_l("inv").func_74764_b(Integer.toString(var1))) {
            return ItemStack.func_77949_a((NBTTagCompound)me.field_77990_d.func_74775_l("inv").func_74775_l(Integer.toString(var1)));
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(ItemStack me, int var1, ItemStack stack) {
        if (!me.func_77942_o()) {
            me.func_77982_d(new NBTTagCompound());
        }
        if (!me.field_77990_d.func_74764_b("inv")) {
            me.field_77990_d.func_74782_a("inv", (NBTBase)new NBTTagCompound());
        }
        if (me.field_77990_d.func_74775_l("inv").func_74764_b(Integer.toString(var1))) {
            me.field_77990_d.func_74775_l("inv").func_82580_o(Integer.toString(var1));
        }
        NBTTagCompound stc = new NBTTagCompound();
        if (stack != null) {
            stack.func_77955_b(stc);
            me.field_77990_d.func_74775_l("inv").func_74782_a(Integer.toString(var1), (NBTBase)stc);
            if (var1 == 5 && this.slot == 1) {
                me.field_77990_d.func_74768_a("steamFill", 0);
                me.field_77990_d.func_74768_a("maxFill", ((IExosuitTank)stack.func_77973_b()).getStorage(me));
                if (stack.func_77973_b() instanceof BlockTankItem && stack.func_77960_j() == 1) {
                    me.field_77990_d.func_74768_a("steamFill", me.field_77990_d.func_74762_e("maxFill"));
                }
            }
        }
        this.hasPlates(me);
    }

    @Override
    public boolean isItemValidForSlot(ItemStack me, int var1, ItemStack var2) {
        return true;
    }

    @Override
    public ItemStack decrStackSize(ItemStack me, int var1, int var2) {
        if (this.getStackInSlot(me, var1) != null) {
            if (this.getStackInSlot((ItemStack)me, (int)var1).field_77994_a <= var2) {
                ItemStack itemstack = this.getStackInSlot(me, var1);
                this.setInventorySlotContents(me, var1, null);
                this.hasPlates(me);
                return itemstack;
            }
            ItemStack stack2 = this.getStackInSlot(me, var1);
            ItemStack itemstack = stack2.func_77979_a(var2);
            this.setInventorySlotContents(me, var1, stack2);
            if (this.getStackInSlot((ItemStack)me, (int)var1).field_77994_a == 0) {
                this.setInventorySlotContents(me, var1, null);
            }
            this.hasPlates(me);
            return itemstack;
        }
        return null;
    }

    @Override
    public boolean canPutInSlot(ItemStack me, int slotNum, ItemStack upgrade) {
        if (slotNum == 0) {
            ItemStack clone = upgrade.func_77946_l();
            clone.field_77994_a = 1;
            return UtilPlates.getPlate(clone) != null;
        }
        if (upgrade.func_77973_b() instanceof IExosuitUpgrade) {
            IExosuitUpgrade upgradeItem = (IExosuitUpgrade)upgrade.func_77973_b();
            return upgradeItem.getSlot().armor == this.slot && upgradeItem.getSlot().slot == slotNum || upgradeItem.getSlot() == ExosuitSlot.vanity && upgradeItem.getSlot().slot == slotNum;
        }
        if (slotNum == ExosuitSlot.vanity.slot) {
            int[] ids;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)upgrade)) {
                String str = OreDictionary.getOreName((int)id);
                if (!str.contains("dye")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPower(ItemStack me, int powerNeeded) {
        if (this.slot == 1) {
            if (!me.func_77942_o()) {
                me.func_77982_d(new NBTTagCompound());
            }
            if (!me.field_77990_d.func_74764_b("steamFill")) {
                me.field_77990_d.func_74768_a("steamFill", 0);
            }
            if (!me.field_77990_d.func_74764_b("maxFill")) {
                me.field_77990_d.func_74768_a("maxFill", 0);
            }
            if (me.field_77990_d.func_74762_e("steamFill") > powerNeeded) {
                return true;
            }
        }
        return false;
    }

    public boolean hasUpgrade(ItemStack me, Item check) {
        if (check == null) {
            return false;
        }
        if (me.func_77942_o() && me.field_77990_d.func_74764_b("inv")) {
            for (int i = 1; i < 10; ++i) {
                ItemStack stack;
                if (!me.field_77990_d.func_74775_l("inv").func_74764_b(Integer.toString(i)) || (stack = ItemStack.func_77949_a((NBTTagCompound)me.field_77990_d.func_74775_l("inv").func_74775_l(Integer.toString(i)))).func_77973_b() != check) continue;
                return true;
            }
        }
        return false;
    }

    public IExosuitUpgrade[] getUpgrades(ItemStack me) {
        ArrayList<IExosuitUpgrade> upgrades = new ArrayList<IExosuitUpgrade>();
        if (me.func_77942_o() && me.field_77990_d.func_74764_b("inv")) {
            for (int i = 2; i < 10; ++i) {
                ItemStack stack;
                if (!me.field_77990_d.func_74775_l("inv").func_74764_b(Integer.toString(i)) || !((stack = ItemStack.func_77949_a((NBTTagCompound)me.field_77990_d.func_74775_l("inv").func_74775_l(Integer.toString(i)))).func_77973_b() instanceof IExosuitUpgrade)) continue;
                upgrades.add((IExosuitUpgrade)stack.func_77973_b());
            }
        }
        return upgrades.toArray(new IExosuitUpgrade[0]);
    }

    @Override
    public void drawSlot(GuiContainer guiEngineeringTable, int slotNum, int i, int j) {
        guiEngineeringTable.field_146297_k.func_110434_K().func_110577_a(GuiEngineeringTable.furnaceGuiTextures);
        if (this.slot == 0) {
            switch (slotNum) {
                case 0: {
                    guiEngineeringTable.func_73729_b(i, j, 194, 0, 18, 18);
                    break;
                }
                case 1: {
                    guiEngineeringTable.func_73729_b(i, j, 230, 36, 18, 18);
                    break;
                }
                default: {
                    guiEngineeringTable.func_73729_b(i, j, 176, 0, 18, 18);
                }
            }
        }
        if (this.slot == 1) {
            switch (slotNum) {
                case 0: {
                    guiEngineeringTable.func_73729_b(i, j, 194, 0, 18, 18);
                    break;
                }
                case 1: {
                    guiEngineeringTable.func_73729_b(i, j, 230, 36, 18, 18);
                    break;
                }
                case 4: {
                    guiEngineeringTable.func_73729_b(i, j, 176, 36, 18, 18);
                    break;
                }
                default: {
                    guiEngineeringTable.func_73729_b(i, j, 176, 0, 18, 18);
                }
            }
        }
        if (this.slot == 2) {
            switch (slotNum) {
                case 0: {
                    guiEngineeringTable.func_73729_b(i, j, 194, 0, 18, 18);
                    break;
                }
                case 1: {
                    guiEngineeringTable.func_73729_b(i, j, 230, 36, 18, 18);
                    break;
                }
                default: {
                    guiEngineeringTable.func_73729_b(i, j, 176, 0, 18, 18);
                }
            }
        }
        if (this.slot == 3) {
            switch (slotNum) {
                case 0: {
                    guiEngineeringTable.func_73729_b(i, j, 194, 0, 18, 18);
                    break;
                }
                case 1: {
                    guiEngineeringTable.func_73729_b(i, j, 230, 36, 18, 18);
                    break;
                }
                default: {
                    guiEngineeringTable.func_73729_b(i, j, 176, 0, 18, 18);
                }
            }
        }
    }

    public int getMaxDamage(ItemStack stack) {
        if (this.slot == 1) {
            return 10000;
        }
        return 0;
    }

    public int getDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.field_77990_d.func_74764_b("steamFill")) {
            stack.field_77990_d.func_74768_a("steamFill", 0);
        }
        if (!stack.field_77990_d.func_74764_b("maxFill")) {
            stack.field_77990_d.func_74768_a("maxFill", 0);
        }
        return (int)((double)stack.field_77990_d.func_74762_e("steamFill") / (double)stack.field_77990_d.func_74762_e("maxFill") * 10000.0);
    }

    @Override
    public int steamPerDurability() {
        return Config.exoConsumption;
    }

    @Override
    public boolean canCharge(ItemStack stack) {
        ItemExosuitArmor item;
        if (this.slot == 1 && (item = (ItemExosuitArmor)stack.func_77973_b()).getStackInSlot(stack, 5) != null && item.getStackInSlot(stack, 5).func_77973_b() instanceof IExosuitTank) {
            IExosuitTank tank = (IExosuitTank)item.getStackInSlot(stack, 5).func_77973_b();
            return tank.canFill(stack);
        }
        return false;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        if (Loader.isModLoaded((String)"Botania")) {
            map = BotaniaIntegration.addModifiers((Multimap)map, stack, this.field_77881_a);
        }
        if (((ItemExosuitArmor)stack.func_77973_b()).hasPlates(stack) && UtilPlates.getPlate(stack.field_77990_d.func_74779_i("plate")).getIdentifier() == "Lead") {
            map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(new UUID(776437L, this.field_77881_a), "Lead exosuit " + this.field_77881_a, 0.25, 0));
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack me, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(me, player, list, par4);
        if (me.func_77942_o()) {
            if (this.hasPlates(me) && UtilPlates.getPlate(me.field_77990_d.func_74779_i("plate")).getIdentifier() != "Thaumium" && UtilPlates.getPlate(me.field_77990_d.func_74779_i("plate")).getIdentifier() != "Terrasteel") {
                list.add(EnumChatFormatting.BLUE + UtilPlates.getPlate(me.field_77990_d.func_74779_i("plate")).effect());
            }
            if (me.field_77990_d.func_74764_b("inv")) {
                for (int i = 3; i < 10; ++i) {
                    if (!me.field_77990_d.func_74775_l("inv").func_74764_b(Integer.toString(i))) continue;
                    ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)me.field_77990_d.func_74775_l("inv").func_74775_l(Integer.toString(i)));
                    list.add(EnumChatFormatting.RED + stack.func_82833_r());
                }
            }
            if (me.field_77990_d.func_74775_l("inv").func_74764_b("2")) {
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)me.field_77990_d.func_74775_l("inv").func_74775_l("2"));
                if (stack.func_77973_b() != null && stack.func_77973_b() == SteamcraftItems.enderShroud) {
                    list.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"steamcraft.exosuit.shroud"));
                } else {
                    int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
                    int dye = -1;
                    block1: for (int id : ids) {
                        String str = OreDictionary.getOreName((int)id);
                        if (!str.contains("dye")) continue;
                        for (int i = 0; i < ModelExosuit.DYES.length; ++i) {
                            if (!ModelExosuit.DYES[i].equals(str.substring(3))) continue;
                            dye = 15 - i;
                            break block1;
                        }
                    }
                    if (dye != -1) {
                        list.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)("steamcraft.color." + ModelExosuit.DYES[15 - dye].toLowerCase())));
                    } else {
                        list.add(EnumChatFormatting.DARK_GREEN + stack.func_82833_r());
                    }
                }
            }
        }
        if (!me.func_77942_o()) {
            me.func_77982_d(new NBTTagCompound());
        }
        if (!me.field_77990_d.func_74764_b("steamFill")) {
            me.field_77990_d.func_74768_a("steamFill", 0);
        }
        if (!me.field_77990_d.func_74764_b("maxFill")) {
            me.field_77990_d.func_74768_a("maxFill", 0);
        }
        if (this.slot == 1) {
            list.add(EnumChatFormatting.WHITE + "" + me.field_77990_d.func_74762_e("steamFill") * 5 + "/" + me.field_77990_d.func_74762_e("maxFill") * 5 + " SU");
        }
    }

    @Optional.Method(modid="Botania")
    public float getPixieChance(ItemStack stack) {
        if (((ItemExosuitArmor)stack.func_77973_b()).hasPlates(stack) && UtilPlates.getPlate(stack.field_77990_d.func_74779_i("plate")).getIdentifier() == "Elementium") {
            switch (this.field_77881_a) {
                case 0: {
                    return 0.025f;
                }
                case 1: {
                    return 0.04f;
                }
                case 2: {
                    return 0.035f;
                }
                case 3: {
                    return 0.02f;
                }
            }
        }
        return 0.0f;
    }

    @Override
    public void drawBackground(GuiEngineeringTable guiEngineeringTable, int i, int j, int k) {
        guiEngineeringTable.field_146297_k.func_110434_K().func_110577_a(largeIcons);
        guiEngineeringTable.func_73729_b(j + 26, k + 3, 0 + 64 * this.slot, 0, 64, 64);
    }
}

