/*
 * Decompiled with CFR 0.152.
 */
package com.vapourdrive.magtools.world.feature;

import com.vapourdrive.magtools.blocks.MagBlocks;
import com.vapourdrive.magtools.config.ConfigInfo;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenMagTree
extends WorldGenAbstractTree {
    public boolean worldGenTree;

    public WorldGenMagTree(boolean doNotify, boolean worldgentree) {
        super(doNotify);
        this.worldGenTree = worldgentree;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        boolean hasGems = false;
        if (!this.checkGenQuality(world, x, y, z)) {
            return false;
        }
        if (!this.worldGenTree && ConfigInfo.EnableSaplingGem && rand.nextInt(ConfigInfo.SaplingGemChance) == 0) {
            hasGems = true;
        }
        this.genBase(world, x, y, z, this.worldGenTree, hasGems);
        this.genSecondHalf(world, x, y + 6, z, this.worldGenTree, hasGems);
        this.genBranches(world, x, y + 6, z);
        return true;
    }

    public boolean checkGenQuality(World world, int x, int y, int z) {
        return this.checkAirSpace(world, x, y, z) && this.checkLevelGround(world, x, y, z);
    }

    public void genBase(World world, int x, int y, int z, boolean worldGenTree, boolean hasGems) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = 0; k <= 5; ++k) {
                    if (i == 0 && j == 0) {
                        this.placeGemChance(world, x + i, y + k, z + j, worldGenTree, hasGems);
                    } else {
                        world.func_147465_d(x + i, y + k, z + j, MagBlocks.MagLog, 0, 3);
                    }
                    if (k != 0) continue;
                    this.fillGroundGap(world, x + i, y - 1, z + j);
                }
            }
        }
        for (int k = 0; k <= 3; ++k) {
            world.func_147465_d(x + 2, y + k, z, MagBlocks.MagLog, 0, 3);
            world.func_147465_d(x - 2, y + k, z, MagBlocks.MagLog, 0, 3);
            world.func_147465_d(x, y + k, z + 2, MagBlocks.MagLog, 0, 3);
            world.func_147465_d(x, y + k, z - 2, MagBlocks.MagLog, 0, 3);
        }
        world.func_147465_d(x + 3, y, z, MagBlocks.MagLog, 4, 3);
        world.func_147465_d(x - 3, y, z, MagBlocks.MagLog, 4, 3);
        world.func_147465_d(x, y, z + 3, MagBlocks.MagLog, 8, 3);
        world.func_147465_d(x, y, z - 3, MagBlocks.MagLog, 8, 3);
        this.fillGroundGap(world, x + 3, y - 1, z);
        this.fillGroundGap(world, x - 3, y - 1, z);
        this.fillGroundGap(world, x, y - 1, z + 3);
        this.fillGroundGap(world, x, y - 1, z - 3);
        this.fillGroundGap(world, x + 2, y - 1, z);
        this.fillGroundGap(world, x - 2, y - 1, z);
        this.fillGroundGap(world, x, y - 1, z + 2);
        this.fillGroundGap(world, x, y - 1, z - 2);
    }

    public void genSecondHalf(World world, int x, int y, int z, boolean worldGenTree, boolean hasGems) {
        int i;
        for (i = 0; i <= 12; ++i) {
            world.func_147465_d(x + 1, y + i, z, MagBlocks.MagLog, 0, 3);
            world.func_147465_d(x - 1, y + i, z, MagBlocks.MagLog, 0, 3);
            world.func_147465_d(x, y + i, z + 1, MagBlocks.MagLog, 0, 3);
            world.func_147465_d(x, y + i, z - 1, MagBlocks.MagLog, 0, 3);
            this.placeGemChance(world, x, y + i, z, worldGenTree, hasGems);
        }
        for (i = 0; i <= 2; ++i) {
            world.func_147465_d(x, y + i + 12, z, MagBlocks.MagLog, 0, 3);
        }
        this.genLeafNode(world, x, y + 14, z);
    }

    public void genBranches(World world, int x, int y, int z) {
        this.planBranch(world, x + 2, y, z, 1, 0);
        this.planBranch(world, x - 2, y, z, -1, 0);
        this.planBranch(world, x, y, z + 2, 0, 1);
        this.planBranch(world, x, y, z - 2, 0, -1);
        this.planBranch(world, x + 1, y, z + 1, 1, 1);
        this.planBranch(world, x - 1, y, z - 1, -1, -1);
        this.planBranch(world, x - 1, y, z + 1, -1, 1);
        this.planBranch(world, x + 1, y, z - 1, 1, -1);
    }

    public void planBranch(World world, int x, int y, int z, int xWalk, int zWalk) {
        for (int i = 0; i <= 12; ++i) {
            if (world.field_73012_v.nextInt(5) <= 2) continue;
            int length = (14 - i) / 4;
            if (length <= 0) {
                length = 1;
            }
            this.genBranch(world, x, y + i, z, xWalk, zWalk, length);
            ++i;
        }
    }

    public void genBranch(World world, int x, int y, int z, int xWalk, int zWalk, int length) {
        int meta = 8;
        if (xWalk != 0 && zWalk == 0) {
            meta = 4;
        }
        if (xWalk != 0 && zWalk != 0 && world.field_73012_v.nextFloat() >= 0.5f) {
            meta = 4;
        }
        for (int i = 0; i <= length; ++i) {
            world.func_147465_d(x + xWalk * i, y, z + zWalk * i, MagBlocks.MagLog, meta, 3);
        }
        this.genLeafNode(world, x + xWalk * length, y, z + zWalk * length);
    }

    public void genLeafNode(World world, int x, int y, int z) {
        int radius = 0;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    Block block;
                    radius = i * i + j * j + k * k + 1;
                    if (world.field_73012_v.nextInt(radius) >= 3 || radius >= 16 || !(block = world.func_147439_a(x + i, y + k, z + j)).canBeReplacedByLeaves((IBlockAccess)world, x + i, y + k, z + j)) continue;
                    world.func_147465_d(x + i, y + k, z + j, MagBlocks.MagLeaves, 0, 3);
                }
            }
        }
    }

    public void fillGroundGap(World world, int x, int y, int z) {
        for (int i = 0; i >= -4; --i) {
            Block block = world.func_147439_a(x, y + i, z);
            if (block.canBeReplacedByLeaves((IBlockAccess)world, x, y + i, z)) {
                world.func_147465_d(x, y + i, z, MagBlocks.MagLog, 0, 3);
                continue;
            }
            i = -5;
        }
    }

    public void placeGemChance(World world, int x, int y, int z, boolean worldGenTree, boolean hasGems) {
        int meta = 0;
        if (worldGenTree && world.field_73012_v.nextInt(ConfigInfo.WorldGenTreeGemLogChance) == 0) {
            meta = 1;
        }
        if (!worldGenTree && hasGems && world.field_73012_v.nextInt(ConfigInfo.SaplingGemChance) == 0) {
            meta = 1;
        }
        world.func_147465_d(x, y, z, MagBlocks.MagLog, meta, 3);
    }

    public boolean checkLevelGround(World world, int x, int y, int z) {
        int groundLevelThreshold = 0;
        int groundCount = 0;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                Material material;
                int height = world.func_72976_f(x + i, z + j);
                if (height < y) {
                    groundLevelThreshold += groundLevelThreshold - height;
                }
                if ((material = world.func_147439_a(x + i, height - 1, z + j).func_149688_o()) != Material.field_151578_c && material != Material.field_151577_b && material != Material.field_151579_a) {
                    return false;
                }
                if (material != Material.field_151577_b && material != Material.field_151578_c) continue;
                ++groundCount;
            }
        }
        return groundLevelThreshold <= 8 && groundCount >= 8;
    }

    public boolean checkAirSpace(World world, int x, int y, int z) {
        for (int i = -6; i <= 6; ++i) {
            for (int j = -6; j <= 6; ++j) {
                for (int k = 1; k <= 24; ++k) {
                    Block block = world.func_147439_a(i + x, k + y, j + z);
                    if (block.canBeReplacedByLeaves((IBlockAccess)world, x, y, z)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

