/*
 * Decompiled with CFR 0.152.
 */
package com.vapourdrive.magtools.config;

import com.vapourdrive.magtools.MagTools;
import com.vapourdrive.magtools.config.ConfigInfo;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class MagToolsConfigMain {
    public static Configuration config;
    private static final String ToolConfigs = "Tool Settings";
    private static final String MaterialConfigs = "Material Settings";
    private static final String OverrideDurability = "Override Durability";
    private static final String SpecialAbilitiesEnablement = "Special Tool Features Enablement";
    private static final String SpecialAbilitiesSettings = "Special Tool Feature Settings";
    private static final String ToolEnabling = "Enable Tools";
    private static final String WorldGen = "World Settings";
    private static final String WorldGenEnabling = "Enable Worldgen";
    private static final String TreeGenSettings = "TreeGen Settings";
    private static final String SaplingSettings = "Tree settings";

    public static void init(File mtconfig) {
        config = new Configuration(mtconfig);
        MagTools.log.log(Level.INFO, "Loading MagTools Main Config");
        config.load();
        config.setCategoryComment(WorldGen, "Here is where the world settings can be changed");
        config.setCategoryComment(ToolConfigs, "Here is where all the tool settings can be changed");
        MagToolsConfigMain.toolOptions();
        MagToolsConfigMain.worldOptions();
        config.save();
    }

    public static void worldOptions() {
        ConfigInfo.EnableSaplingGem = config.getBoolean("Enable Sapling-Tree GemSpawning", "World Settings.Enable Worldgen", false, "Enables a tree grown from a sapling to grow with gems in its core");
        ConfigInfo.EnableTreeGen = config.getBoolean("Enable Tree Gen", "World Settings.Enable Worldgen", true, "Enables the tree to generate in the world");
        ConfigInfo.EnableFlatWorldTree = config.getBoolean("Enable FlatWorld Tree Gen", "World Settings.Enable Worldgen", false, "Enables the tree to generate in a flat world type");
        ConfigInfo.TreeGenChance = config.getInt("Tree Gen Chance", "World Settings.TreeGen Settings", 50, 1, 1000, "Chance 1/x that a tree will attempt to generate in a chunk. \nThe conditions are strick, so 1/50 may mean 1 tree per 500 chunks");
        ConfigInfo.SaplingGemChance = config.getInt("Sapling GemTree Growth Chance", "World Settings.TreeGen Settings", 3, 1, 1000, "If saplings can grow trees with gems, there is a 1/x chance that the tree will have gems");
        ConfigInfo.SaplingTreeGemLogChance = config.getInt("Sapling-Tree Gem-Log Chance", "World Settings.TreeGen Settings", 4, 1, 20, "The 1/x chance that a center log will have a gem in a sapling grown tree (if enabled)");
        ConfigInfo.WorldGenTreeGemLogChance = config.getInt("WorldGen Tree Gem Chance", "World Settings.TreeGen Settings", 4, 1, 20, "The 1/x chance that a center log will have a gem in a worldgen tree");
        ConfigInfo.CanBonemealSapling = config.getBoolean("Enable Bonemeal Sapling", "World Settings.Tree settings", false, "Enables the sapling to grow via bonemealing");
        ConfigInfo.SaplingGrowthChanceNatural = config.getInt("Natural Sapling Growth Chance", "World Settings.Tree settings", 10, 1, 1000, "1/x chance that a sapling will age when it's block experiences an update naturally");
        ConfigInfo.SaplingGrowthChanceBonemeal = config.getInt("Bonemealed Sapling Growth Chance", "World Settings.Tree settings", 4, 1, 1000, "1/x chance that a sapling will age when it's block is bonemealed \nThe average number of bonemeal consumed per tree is this number * 15");
    }

    public static void toolOptions() {
        ConfigInfo.MagDurability = config.getInt("Magnanimous Material Durability", "Tool Settings.Material Settings", ConfigInfo.MagDurabilityDefault, 1, 100000, "Default base durability for the magnanimous material");
        ConfigInfo.MagEnchantability = config.getInt("Magnanimous Material Enchantability", "Tool Settings.Material Settings", ConfigInfo.MagEnchantabilityDefault, 1, 30, "Enchantability of the magnanimous material");
        ConfigInfo.MagMiningLevel = config.getInt("Magannimous Material Mining Level", "Tool Settings.Material Settings", ConfigInfo.MagMiningLevelDefault, 0, 5, "The Mining Level of the magnanimous material");
        ConfigInfo.MagEfficiency = config.getFloat("Magnanimous Material Efficiency", "Tool Settings.Material Settings", ConfigInfo.MagEfficiencyDefault, 0.0f, 20.0f, "The efficiency that the tools will have mining appropriate blocks");
        ConfigInfo.MagDamage = config.getFloat("Magnanimous Material Damage", "Tool Settings.Material Settings", ConfigInfo.MagDamageDefault, 0.0f, 10.0f, "The damage worth that these tools will have against mobs");
        ConfigInfo.MagPickDurability = config.getInt("Magnanimous Pick Durability", "Tool Settings.Override Durability", ConfigInfo.MagDurabilityDefault, 1, 100000, "Set specific durability for the Pick");
        ConfigInfo.MagHammerDurability = config.getInt("Magnanimous Hammer Durability", "Tool Settings.Override Durability", ConfigInfo.MagDurabilityDefault, 1, 100000, "Set specific durability for the Hammer");
        ConfigInfo.MagEarthMoverDurability = config.getInt("Magnanimous Earth Mover Durability", "Tool Settings.Override Durability", ConfigInfo.MagDurabilityDefault, 1, 100000, "Set specific durability for the Earth Mover");
        ConfigInfo.MagSwordDurability = config.getInt("Magnanimous Sword Durability", "Tool Settings.Override Durability", ConfigInfo.MagDurabilityDefault, 1, 100000, "Set specific durability for the Sword");
        ConfigInfo.EnableEarthMoverShiftOneBlock = config.getBoolean("EarthMover Sneak Mine", "Tool Settings.Special Tool Features Enablement", true, "Enables the player to mine one block while sneaking with the EarthMover");
        ConfigInfo.EnableHammerShiftOneBlock = config.getBoolean("Hammer Sneak Mine", "Tool Settings.Special Tool Features Enablement", true, "Enables the player to mine one block while sneaking with the Hammer");
        ConfigInfo.EnableXPSpeed = config.getBoolean("XP Speed Bonus Enabling", "Tool Settings.Special Tool Features Enablement", true, "This enables the speed boost you get from XPLevels");
        ConfigInfo.EnableSwordXPdamage = config.getBoolean("Sword XP Damage Enabling", "Tool Settings.Special Tool Features Enablement", true, "This enables the damage boost the sword gets from your XPLevels");
        ConfigInfo.EnablePickFortune = config.getBoolean("Pick Custom Fortune Enabling", "Tool Settings.Special Tool Features Enablement", true, "This enables the XP based extra drop chance");
        ConfigInfo.EarthMoverSneakMinXP = config.getInt("EarthMover SneakMine XP Requirement", "Tool Settings.Special Tool Feature Settings", ConfigInfo.EarthMoverSneakMinXP, 0, 200, "If the EarthMover sneak-mine-oneblock feature is enabled, this is the experience requirement");
        ConfigInfo.HammerSneakMinXP = config.getInt("Hammer SneakMine XP Requirement", "Tool Settings.Special Tool Feature Settings", ConfigInfo.EarthMoverSneakMinXP, 0, 200, "If the Hammer sneak-mine-oneblock feature is enabled, this is the experience requirement");
        ConfigInfo.EnableSword = config.getBoolean("Enable Mag Sword", "Tool Settings.Enable Tools", true, "If the Mag Sword is enabled");
        ConfigInfo.EnablePick = config.getBoolean("Enable Mag Pick", "Tool Settings.Enable Tools", true, "If the Mag Pick is enabled");
        ConfigInfo.EnableHammer = config.getBoolean("Enable Mag Hammer", "Tool Settings.Enable Tools", true, "If the Mag Hammer is enabled");
        ConfigInfo.EnableEarthMover = config.getBoolean("Enable Mag EarthMover", "Tool Settings.Enable Tools", true, "If the Mag EarthMover is enabled");
    }
}

