/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.loot;

import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.world.loot.IItemPostProcessor;
import chylex.hee.world.loot.LootItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class WeightedLootList
extends WeightedList<LootItemStack> {
    private static final long serialVersionUID = -491398574791344180L;
    private List<IItemPostProcessor> itemPostProcessors = new ArrayList<IItemPostProcessor>();

    public WeightedLootList(LootItemStack ... items) {
        super((IWeightProvider[])new LootItemStack[0]);
        for (LootItemStack item : items) {
            this.add(item);
        }
    }

    public WeightedLootList addAll(LootItemStack[] objArray) {
        super.addAll((IWeightProvider[])objArray);
        return this;
    }

    public WeightedLootList addItemPostProcessor(IItemPostProcessor itemPostProcessor) {
        this.itemPostProcessors.add(itemPostProcessor);
        return this;
    }

    public ItemStack generateIS(Random rand) {
        LootItemStack is = (LootItemStack)super.getRandomItem(rand);
        if (is == null) {
            return null;
        }
        ItemStack finalIS = is.getIS(rand);
        for (IItemPostProcessor postProcessor : this.itemPostProcessors) {
            finalIS = postProcessor.processItem(finalIS, rand);
        }
        return finalIS;
    }

    public WeightedLootList copy() {
        WeightedLootList copy = new WeightedLootList(new LootItemStack[0]);
        copy.addAll(this);
        copy.itemPostProcessors.addAll(this.itemPostProcessors);
        return copy;
    }
}

