/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.entity.mob.EntityMobSanctuaryOverseer;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntitySanctuaryBrain
extends TileEntity {
    private BlockPosM point1;
    private BlockPosM point2;
    private List<ConquerPointHandler> conquerPts = new ArrayList<ConquerPointHandler>();
    private byte checkTimer = (byte)5;
    private byte runTimer = 0;
    private boolean isIdle;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K || this.point1 == null || this.point2 == null) {
            return;
        }
        this.checkTimer = (byte)(this.checkTimer - 1);
        if (this.checkTimer < 0) {
            this.checkTimer = (byte)20;
            this.isIdle = this.field_145850_b.func_72872_a(EntityPlayer.class, BlockPosM.getBoundingBox(this.point1, this.point2).func_72314_b(8.0, 8.0, 8.0)).isEmpty();
        }
        if (!this.isIdle) {
            this.runTimer = (byte)(this.runTimer - 1);
            if (this.runTimer < 0) {
                this.runTimer = (byte)5;
                List list = this.field_145850_b.func_72872_a(EntityPlayer.class, BlockPosM.getBoundingBox(this.point1, this.point2).func_72314_b(0.9, 0.9, 0.9));
                for (EntityPlayer player : list) {
                    PotionEffect effJump = player.func_70660_b(Potion.field_76430_j);
                    player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 8, 4, true));
                    player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 215, 0, true));
                }
            }
            for (ConquerPointHandler point : this.conquerPts) {
                point.update();
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.point1 != null) {
            nbt.func_74772_a("p1", this.point1.toLong());
        }
        if (this.point2 != null) {
            nbt.func_74772_a("p2", this.point2.toLong());
        }
        NBTTagList ptsTag = new NBTTagList();
        for (ConquerPointHandler point : this.conquerPts) {
            ptsTag.func_74742_a((NBTBase)point.writeToNBT());
        }
        nbt.func_74782_a("conquer", (NBTBase)ptsTag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readCustomData(nbt);
    }

    public void readCustomData(NBTTagCompound nbt) {
        if (nbt.func_74764_b("p1")) {
            this.point1 = new BlockPosM(nbt.func_74763_f("p1"));
        }
        if (nbt.func_74764_b("p2")) {
            this.point2 = new BlockPosM(nbt.func_74763_f("p2"));
        }
        NBTTagList ptsTag = nbt.func_150295_c("conquer", 10);
        for (int a = 0; a < ptsTag.func_74745_c(); ++a) {
            ConquerPointHandler point = new ConquerPointHandler();
            point.readFromNBT(ptsTag.func_150305_b(a));
            this.conquerPts.add(point);
        }
    }

    private final class ConquerPointHandler {
        BlockPosM point1;
        BlockPosM point2;
        byte enemiesLeft = (byte)-128;
        byte runTimer = (byte)-1;
        byte startTimer = 0;
        boolean isConquered;

        private ConquerPointHandler() {
        }

        void update() {
            boolean hasPlayers;
            if (this.point1 == null || this.point2 == null || this.isConquered) {
                return;
            }
            BlockPosM.tmp(this.point1.x, this.point2.y + 8, this.point1.z).setBlock(TileEntitySanctuaryBrain.this.field_145850_b, Blocks.field_150357_h);
            AxisAlignedBB full = BlockPosM.getBoundingBox(this.point1, this.point2);
            boolean bl = hasPlayers = !TileEntitySanctuaryBrain.this.field_145850_b.func_72872_a(EntityPlayer.class, full.func_72314_b(0.9, 0.9, 0.9)).isEmpty();
            if (hasPlayers) {
                // empty if block
            }
            if (this.runTimer == -1) {
                if (!hasPlayers) {
                    this.startTimer = 0;
                } else {
                    this.startTimer = (byte)(this.startTimer + 1);
                    if (this.startTimer >= 12 + ((TileEntitySanctuaryBrain)TileEntitySanctuaryBrain.this).field_145850_b.field_73012_v.nextInt(20)) {
                        this.startTimer = 0;
                        this.runTimer = 0;
                        if (this.enemiesLeft == -128) {
                            this.enemiesLeft = (byte)(8 + ((TileEntitySanctuaryBrain)TileEntitySanctuaryBrain.this).field_145850_b.field_73013_u.func_151525_a() * 2 + ((TileEntitySanctuaryBrain)TileEntitySanctuaryBrain.this).field_145850_b.field_73012_v.nextInt(4));
                        }
                        this.updateBarriers(true);
                    }
                }
            } else if (this.runTimer >= 0) {
                if (!hasPlayers) {
                    this.runTimer = (byte)-1;
                    this.startTimer = 0;
                    this.updateBarriers(false);
                    for (EntityMobSanctuaryOverseer foe : TileEntitySanctuaryBrain.this.field_145850_b.func_72872_a(EntityMobSanctuaryOverseer.class, full.func_72314_b(0.9, 0.9, 0.9))) {
                        foe.func_70106_y();
                    }
                } else {
                    List foes = TileEntitySanctuaryBrain.this.field_145850_b.func_72872_a(EntityMobSanctuaryOverseer.class, full.func_72314_b(0.9, 0.9, 0.9));
                    this.runTimer = (byte)(this.runTimer + 1);
                    if (this.runTimer > 8) {
                        this.runTimer = 0;
                        if (foes.isEmpty()) {
                            Random rand = ((TileEntitySanctuaryBrain)TileEntitySanctuaryBrain.this).field_145850_b.field_73012_v;
                            int enemies = Math.min(this.enemiesLeft, 2 + rand.nextInt(2) + Math.min(2, rand.nextInt(1 + ((TileEntitySanctuaryBrain)TileEntitySanctuaryBrain.this).field_145850_b.field_73013_u.func_151525_a())));
                            for (int attempt = 0; enemies > 0 && attempt < 10; ++attempt) {
                                EntityMobSanctuaryOverseer mob = new EntityMobSanctuaryOverseer(TileEntitySanctuaryBrain.this.field_145850_b);
                                mob.func_70107_b((double)MathUtil.floor(full.field_72340_a + (double)rand.nextFloat() * (full.field_72336_d - full.field_72340_a)) + 0.5, full.field_72338_b + 1.0 + (double)rand.nextFloat() * (full.field_72337_e - full.field_72338_b - 2.0), (double)MathUtil.floor(full.field_72339_c + (double)rand.nextFloat() * (full.field_72334_f - full.field_72339_c)) + 0.5);
                                if (DragonUtil.getClosestEntity((Entity)mob, TileEntitySanctuaryBrain.this.field_145850_b.func_72872_a(EntityLivingBase.class, mob.field_70121_D.func_72314_b(1.5, 1.5, 1.5))) != null) continue;
                                TileEntitySanctuaryBrain.this.field_145850_b.func_72838_d((Entity)mob);
                                --enemies;
                            }
                        }
                    }
                    for (EntityMobSanctuaryOverseer overseer : foes) {
                        if (overseer.field_70725_aQ != 1) continue;
                        this.enemiesLeft = (byte)(this.enemiesLeft - 1);
                    }
                    if (this.enemiesLeft <= 0) {
                        this.isConquered = true;
                        this.updateBarriers(false);
                    }
                }
            }
        }

        private void updateBarriers(boolean block) {
        }

        NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.point1 != null) {
                tag.func_74772_a("p1", this.point1.toLong());
            }
            if (this.point2 != null) {
                tag.func_74772_a("p2", this.point2.toLong());
            }
            tag.func_74774_a("run", this.runTimer);
            tag.func_74774_a("enm", this.enemiesLeft);
            tag.func_74757_a("done", this.isConquered);
            return tag;
        }

        void readFromNBT(NBTTagCompound tag) {
            if (tag.func_74764_b("p1")) {
                this.point1 = new BlockPosM(tag.func_74763_f("p1"));
            }
            if (tag.func_74764_b("p2")) {
                this.point2 = new BlockPosM(tag.func_74763_f("p2"));
            }
            this.runTimer = tag.func_74764_b("run") ? tag.func_74771_c("run") : this.runTimer;
            this.enemiesLeft = tag.func_74764_b("enm") ? tag.func_74771_c("enm") : this.enemiesLeft;
            this.isConquered = tag.func_74764_b("done") ? tag.func_74767_n("done") : this.isConquered;
        }
    }
}

