/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.content.fragments;

import chylex.hee.gui.GuiEnderCompendium;
import chylex.hee.gui.helpers.GuiItemRenderHelper;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import chylex.hee.mechanics.compendium.util.KnowledgeUtils;
import chylex.hee.system.logging.Log;
import com.google.common.base.Joiner;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class KnowledgeFragmentCrafting
extends KnowledgeFragment {
    public static final ItemStack lockedItem = new ItemStack(ItemList.special_effects, 1, 18);
    private static final Map<KnowledgeFragmentCrafting, Pair<ItemStack, ItemStack[]>> tmpCraftingFragments = new HashMap<KnowledgeFragmentCrafting, Pair<ItemStack, ItemStack[]>>();
    private IRecipe referenceRecipe;
    private ItemStack[] items;
    private byte status;

    public static void verifyRecipes() {
        for (Map.Entry<KnowledgeFragmentCrafting, Pair<ItemStack, ItemStack[]>> entry : tmpCraftingFragments.entrySet()) {
            KnowledgeFragmentCrafting fragment = entry.getKey();
            IRecipe prevRecipe = fragment.referenceRecipe;
            fragment.setRecipeFromRegistry((ItemStack)entry.getValue().getLeft(), (ItemStack[])entry.getValue().getRight());
            if (fragment.referenceRecipe == null) {
                fragment.status = (byte)2;
                continue;
            }
            if (fragment.referenceRecipe == prevRecipe) continue;
            fragment.status = 1;
        }
        tmpCraftingFragments.clear();
    }

    public KnowledgeFragmentCrafting(int globalID) {
        super(globalID);
    }

    private KnowledgeFragmentCrafting setRecipe(IRecipe recipe, ItemStack[] ingredients) {
        this.referenceRecipe = recipe;
        this.items = new ItemStack[10];
        for (int a = 0; a < 9 && a < ingredients.length; ++a) {
            this.items[a] = ingredients[a];
        }
        this.items[9] = recipe.func_77571_b();
        return this;
    }

    public KnowledgeFragmentCrafting setRecipeFromRegistry(ItemStack outputToFind) {
        return this.setRecipeFromRegistry(outputToFind, null);
    }

    public KnowledgeFragmentCrafting setRecipeFromRegistry(ItemStack outputToFind, ItemStack[] ingredients) {
        this.referenceRecipe = null;
        this.items = null;
        List list = CraftingManager.func_77594_a().func_77592_b();
        tmpCraftingFragments.put(this, (Pair<ItemStack, ItemStack[]>)Pair.of((Object)outputToFind, (Object)ingredients));
        for (int a = list.size() - 1; a >= 0; --a) {
            ItemStack[] recipeIngredients;
            IRecipe recipe = (IRecipe)list.get(a);
            if (!ItemStack.func_77989_b((ItemStack)outputToFind, (ItemStack)recipe.func_77571_b()) || !(recipe instanceof ShapedRecipes ? this.checkIngredients(recipeIngredients = ((ShapedRecipes)recipe).field_77574_d, ingredients) : recipe instanceof ShapelessRecipes && this.checkIngredients(recipeIngredients = ((ShapelessRecipes)recipe).field_77579_b.toArray(new ItemStack[recipe.func_77570_a()]), ingredients))) continue;
            return this.setRecipe(recipe, recipeIngredients);
        }
        Log.warn("Could not find ItemStack $0 when registering recipe from registry.", outputToFind.toString());
        return this;
    }

    private boolean checkIngredients(ItemStack[] recipe, ItemStack[] target) {
        if (target == null) {
            return true;
        }
        if (recipe.length != target.length) {
            return false;
        }
        int matching = 0;
        block0: for (int recipeIndex = 0; recipeIndex < recipe.length; ++recipeIndex) {
            for (int targetIndex = 0; targetIndex < target.length; ++targetIndex) {
                ItemStack recipeIS = recipe[recipeIndex];
                ItemStack targetIS = target[targetIndex];
                if (recipeIS.func_77973_b() != targetIS.func_77973_b() || recipeIS.func_77960_j() != targetIS.func_77960_j()) continue;
                ++matching;
                continue block0;
            }
        }
        return matching == recipe.length;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getHeight(GuiEnderCompendium gui, boolean isUnlocked) {
        return 58;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onClick(GuiEnderCompendium gui, int x, int y, int mouseX, int mouseY, int buttonId, boolean isUnlocked) {
        if (this.items == null || !isUnlocked || buttonId != 0) {
            return false;
        }
        int xx = x;
        int yy = y;
        int cnt = 0;
        for (int a = 0; a < 10; ++a) {
            if (this.items[a] != null && mouseX >= xx + 1 && mouseX <= xx + 18 && mouseY >= yy + 1 && mouseY <= yy + 18) {
                KnowledgeObject<? extends IKnowledgeObjectInstance<?>> obj = KnowledgeUtils.tryGetFromItemStack(this.items[a]);
                if (obj == null) {
                    return false;
                }
                gui.showObject(obj);
                gui.moveToCurrentObject(true);
                return true;
            }
            if (a == 8) {
                xx = x + 94;
                yy = y + 19;
                continue;
            }
            xx += 19;
            if (++cnt < 3) continue;
            yy += 19;
            xx -= 57;
            cnt = 0;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRender(GuiEnderCompendium gui, int x, int y, int mouseX, int mouseY, boolean isUnlocked) {
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.field_146297_k.func_110434_K().func_110577_a(GuiEnderCompendium.texFragments);
        gui.func_73729_b(x, y, 0, 0, 88, 58);
        if (this.status > 0) {
            boolean unicode = gui.field_146297_k.field_71466_p.func_82883_a();
            gui.field_146297_k.field_71466_p.func_78276_b("?", x + 107, y + 8, -16777216);
            gui.field_146297_k.field_71466_p.func_78264_a(unicode);
            if (mouseX >= x + 106 && mouseY >= y + 7 && mouseX <= x + 112 && mouseY <= y + 16) {
                GuiItemRenderHelper.setupTooltip(mouseX, mouseY, I18n.func_135052_a((String)(this.status == 1 ? "compendium.crafting.changed" : "compendium.crafting.removed"), (Object[])new Object[0]));
            }
        }
        if (this.items == null) {
            return;
        }
        int xx = x;
        int yy = y;
        int cnt = 0;
        for (int a = 0; a < 10; ++a) {
            ItemStack is;
            ItemStack itemStack = is = isUnlocked ? this.items[a] : lockedItem;
            if (is != null) {
                GuiItemRenderHelper.renderItemIntoGUI(gui.field_146297_k.func_110434_K(), is, xx + 2, yy + 2);
                if (isUnlocked && mouseX >= xx + 1 && mouseX <= xx + 18 && mouseY >= yy + 1 && mouseY <= yy + 18) {
                    GuiItemRenderHelper.setupTooltip(mouseX, mouseY, Joiner.on((char)'\n').join(KnowledgeUtils.getCompendiumTooltip(is, (EntityPlayer)gui.field_146297_k.field_71439_g)));
                }
            }
            if (a == 8) {
                xx = x + 94;
                yy = y + 19;
                continue;
            }
            xx += 19;
            if (++cnt < 3) continue;
            yy += 19;
            xx -= 57;
            cnt = 0;
        }
    }
}

