/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.block;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.block.material.MaterialDungeonPuzzle;
import chylex.hee.entity.fx.FXType;
import chylex.hee.entity.technical.EntityTechnicalPuzzleChain;
import chylex.hee.entity.technical.EntityTechnicalPuzzleSolved;
import chylex.hee.init.BlockList;
import chylex.hee.item.block.ItemBlockWithSubtypes;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C20Effect;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.util.Direction;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDungeonPuzzle
extends Block
implements ItemBlockWithSubtypes.IBlockSubtypes {
    private static final Material dungeonPuzzle = new MaterialDungeonPuzzle();
    public static final byte minDungeonSize = 7;
    public static final byte maxDungeonSize = 13;
    public static final byte metaTriggerUnlit = 0;
    public static final byte metaTriggerLit = 1;
    public static final byte metaChainedUnlit = 2;
    public static final byte metaChainedLit = 3;
    public static final byte metaDistributorSpreadUnlit = 4;
    public static final byte metaDistributorSpreadLit = 5;
    public static final byte metaDistributorSquareUnlit = 6;
    public static final byte metaDistributorSquareLit = 7;
    public static final byte metaPortal = 11;
    public static final byte metaDisabled = 12;
    public static final byte metaWall = 13;
    public static final byte metaRock = 14;
    public static final byte metaCeiling = 15;
    public static final byte[] icons = new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 3, 3, 3, 10, 10, 0, 1, 3};
    public static final String[] names = new String[]{"trigger.unlit", "trigger.lit", "chained.unlit", "chained.lit", "distr.spread.unlit", "distr.spread.lit", "distr.square.unlit", "distr.square.lit", null, null, null, null, "disabled", "wall", "rock", "ceiling"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public static final boolean canTrigger(int meta) {
        return meta == 0 || meta == 1;
    }

    public static final int toggleState(int meta) {
        if (meta == 13 || meta == 14 || meta == 15 || meta == 12 || meta == 11) {
            return meta;
        }
        return (meta & 1) == 0 ? meta + 1 : meta - 1;
    }

    public static final boolean isLit(int meta) {
        return (meta & 1) != 0;
    }

    public static final int getUnlit(int meta) {
        return (meta & 1) != 0 ? meta - 1 : meta;
    }

    public BlockDungeonPuzzle() {
        super(dungeonPuzzle);
    }

    public boolean updateChain(World world, int x, int y, int z, byte chainDir) {
        int toggled;
        int meta = BlockPosM.tmp(x, y, z).getMetadata((IBlockAccess)world);
        if (meta != (toggled = BlockDungeonPuzzle.toggleState(meta))) {
            BlockPosM.tmp(x, y, z).setMetadata(world, toggled);
            int unlit = BlockDungeonPuzzle.getUnlit(meta);
            if (unlit == 4) {
                for (int dir = 0; dir < 4; ++dir) {
                    int tz;
                    int tx;
                    int distrMeta;
                    int distrToggled;
                    if (dir == Direction.rotateOpposite[chainDir] || (distrToggled = BlockDungeonPuzzle.toggleState(distrMeta = world.func_72805_g(x + (tx = Direction.offsetX[dir]), y, z + (tz = Direction.offsetZ[dir])))) == distrMeta || world.func_147439_a(x + tx, y, z + tz) != BlockList.dungeon_puzzle) continue;
                    world.func_72838_d((Entity)new EntityTechnicalPuzzleChain(world, x + tx, y, z + tz, dir));
                }
            } else if (unlit == 6) {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        int distrMeta = world.func_72805_g(x + xx, y, z + zz);
                        int distrToggled = BlockDungeonPuzzle.toggleState(distrMeta);
                        if (distrToggled == distrMeta || xx == 0 && zz == 0 || world.func_147439_a(x + xx, y, z + zz) != BlockList.dungeon_puzzle) continue;
                        PacketPipeline.sendToAllAround(world.field_73011_w.field_76574_g, (double)(x + xx) + 0.5, (double)y + 0.5, (double)(z + zz) + 0.5, 64.0, new C20Effect(FXType.Basic.DUNGEON_PUZZLE_BURN, (double)(x + xx) + 0.5, (double)y + 0.5, (double)(z + zz) + 0.5));
                        BlockPosM.tmp(x + xx, y, z + zz).setMetadata(world, distrToggled);
                    }
                }
            } else {
                return true;
            }
            PacketPipeline.sendToAllAround(world.field_73011_w.field_76574_g, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 64.0, new C20Effect(FXType.Basic.DUNGEON_PUZZLE_BURN, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
        }
        this.checkWinConditions(world, x, y, z);
        return false;
    }

    public void checkWinConditions(World world, int x, int y, int z) {
        if (world.func_72872_a(EntityTechnicalPuzzleChain.class, AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - 13.0), (double)y, (double)((double)z + 0.5 - 13.0), (double)((double)x + 0.5 + 13.0), (double)((double)y + 1.0), (double)((double)z + 0.5 + 13.0))).size() == 1) {
            int minX = x;
            int minZ = z;
            int maxX = x;
            int maxZ = z;
            int cnt = 0;
            BlockPosM tmpPos = BlockPosM.tmp();
            boolean isFinished = true;
            Stopwatch.time("BlockDungeonPuzzle - win detection - coords");
            while (tmpPos.set(--minX, y, z).getBlock((IBlockAccess)world) == this) {
            }
            while (tmpPos.set(x, y, --minZ).getBlock((IBlockAccess)world) == this) {
            }
            while (tmpPos.set(++maxX, y, z).getBlock((IBlockAccess)world) == this) {
            }
            while (tmpPos.set(x, y, ++maxZ).getBlock((IBlockAccess)world) == this) {
            }
            ++minZ;
            --maxX;
            --maxZ;
            int pz = z;
            for (int px = ++minX; px <= maxX; ++px) {
                while (tmpPos.set(px, y, --pz).getBlock((IBlockAccess)world) == this) {
                }
                if (pz + 1 < minZ) {
                    minZ = pz + 1;
                }
                pz = z;
                while (tmpPos.set(px, y, ++pz).getBlock((IBlockAccess)world) == this) {
                }
                if (pz - 1 <= maxZ) continue;
                maxZ = pz - 1;
            }
            int px = x;
            for (int pz2 = minZ; pz2 <= maxZ; ++pz2) {
                while (tmpPos.set(--px, y, pz2).getBlock((IBlockAccess)world) == this) {
                }
                if (px + 1 < minX) {
                    minX = px + 1;
                }
                px = x;
                while (tmpPos.set(++px, y, pz2).getBlock((IBlockAccess)world) == this) {
                }
                if (px - 1 <= maxX) continue;
                maxX = px - 1;
            }
            ++minX;
            ++minZ;
            --maxX;
            --maxZ;
            Stopwatch.finish("BlockDungeonPuzzle - win detection - coords");
            Stopwatch.time("BlockDungeonPuzzle - win detection - conditions");
            block10: for (int xx = minX; xx <= maxX; ++xx) {
                for (int zz = minZ; zz <= maxZ; ++zz) {
                    if (tmpPos.set(xx, y, zz).getBlock((IBlockAccess)world) != this) continue;
                    ++cnt;
                    if (!BlockDungeonPuzzle.isLit(BlockDungeonPuzzle.toggleState(tmpPos.getMetadata((IBlockAccess)world)))) continue;
                    isFinished = false;
                    xx = maxX + 1;
                    continue block10;
                }
            }
            Stopwatch.finish("BlockDungeonPuzzle - win detection - conditions");
            if (isFinished && (double)cnt > (double)((maxX - minX + 1) * (maxZ - minZ + 1)) * 0.9) {
                world.func_72838_d((Entity)new EntityTechnicalPuzzleSolved(world, minX + (maxX - minX + 1 >> 1), y, minZ + (maxZ - minZ + 1 >> 1), minX, minZ, maxX, maxZ));
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return BlockPosM.tmp(x, y, z).getMetadata(world) == 11 ? 15 : super.getLightValue(world, x, y, z);
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventID, int eventData) {
        if (eventID == 69) {
            for (int a = 0; a < (eventData == 0 ? 3 : 25); ++a) {
                world.func_72869_a("flame", (double)x + world.field_73012_v.nextDouble(), (double)y + (eventData == 0 ? 1.15 : 1.0 + world.field_73012_v.nextDouble() * 2.0), (double)z + world.field_73012_v.nextDouble(), (world.field_73012_v.nextDouble() - 0.5) * 0.1, (world.field_73012_v.nextDouble() - 0.5) * 0.1, (world.field_73012_v.nextDouble() - 0.5) * 0.1);
            }
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (BlockPosM.tmp(x, y, z).getMetadata((IBlockAccess)world) == 11) {
            for (int a = 0; a < 18; ++a) {
                HardcoreEnderExpansion.fx.portalColor(world, (double)x + 0.5 + (rand.nextDouble() - 0.5) * 0.3, (double)y + 1.0 + rand.nextDouble() * 2.0, (double)z + 0.5 + (rand.nextDouble() - 0.5) * 0.3, (rand.nextDouble() - 0.5) * 0.8, (rand.nextDouble() - 0.5) * 0.2, (rand.nextDouble() - 0.5) * 0.8, 0.6289f, 0.3359f, 0.0391f);
            }
            HardcoreEnderExpansion.fx.portalColor(world, (double)x + 0.5 + (rand.nextDouble() - 0.5) * 0.3, (double)y + 1.0 + rand.nextDouble() * 2.0, (double)z + 0.5 + (rand.nextDouble() - 0.5) * 0.3, (rand.nextDouble() - 0.5) * 0.8, (rand.nextDouble() - 0.5) * 0.2, (rand.nextDouble() - 0.5) * 0.8, 1.0f, 1.0f, 1.0f);
        }
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    protected ItemStack func_149644_j(int meta) {
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        int meta = BlockPosM.tmp(x, y, z).getMetadata((IBlockAccess)world);
        if (meta == 11) {
            meta = 12;
        }
        return new ItemStack((Block)this, 1, meta);
    }

    @Override
    public String getUnlocalizedName(ItemStack is) {
        String name = names[MathUtil.clamp(is.func_77960_j(), 0, names.length - 1)];
        return name == null ? "" : "tile.dungeonPuzzle." + name;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta >= 0 && meta < icons.length ? this.iconArray[icons[meta]] : this.iconArray[3];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (byte meta : new byte[]{13, 14, 15, 12, 0, 1, 2, 3, 4, 5, 6, 7}) {
            list.add(new ItemStack(item, 1, (int)meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconArray = new IIcon[11];
        this.iconArray[0] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_wall");
        this.iconArray[1] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_wall_rock");
        this.iconArray[2] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_trigger_unlit");
        this.iconArray[3] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_trigger_lit");
        this.iconArray[4] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_chained_unlit");
        this.iconArray[5] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_chained_lit");
        this.iconArray[6] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_distributor_spread_unlit");
        this.iconArray[7] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_distributor_spread_lit");
        this.iconArray[8] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_distributor_square_unlit");
        this.iconArray[9] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_distributor_square_lit");
        this.iconArray[10] = iconRegister.func_94245_a("hardcoreenderexpansion:dungeon_puzzle_disabled");
    }
}

