/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.TEDemonPortal;
import WayofTime.alchemicalWizardry.common.tileEntity.TEBellJar;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class RitualEffectDemonPortal
extends RitualEffect {
    public static final int neededAmount = 16000;
    public static final Random rand = new Random();
    public static final int drainRate = 50;
    public static final Reagent[] reagents = new Reagent[]{ReagentRegistry.aetherReagent, ReagentRegistry.aquasalusReagent, ReagentRegistry.terraeReagent, ReagentRegistry.incendiumReagent, ReagentRegistry.sanctusReagent, ReagentRegistry.tenebraeReagent, ReagentRegistry.magicalesReagent, ReagentRegistry.potentiaReagent};
    public static final Int3[] jarLocations = new Int3[]{new Int3(4, 5, 4), new Int3(-4, 5, 4), new Int3(4, 5, -4), new Int3(-4, 5, -4), new Int3(0, 5, 6), new Int3(0, 5, -6), new Int3(6, 5, 0), new Int3(-6, 5, 0)};

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            NBTTagCompound tag = ritualStone.getCustomRitualTag();
            boolean reagentsFulfilled = true;
            for (Reagent reagent : reagents) {
                int reagentAmount = tag.func_74762_e(ReagentRegistry.getKeyForReagent(reagent));
                if (reagentAmount >= 16000) continue;
                reagentsFulfilled = false;
                int drainAmount = Math.min(50, 16000 - reagentAmount);
                if (drainAmount <= 0 || !this.canDrainReagent(ritualStone, reagent, drainAmount, true)) continue;
                if (rand.nextInt(10) == 0) {
                    this.createRandomLightning(world, x, y, z);
                }
                tag.func_74768_a(ReagentRegistry.getKeyForReagent(reagent), reagentAmount += drainAmount);
                break;
            }
            ritualStone.setCustomRitualTag(tag);
            if (reagentsFulfilled && this.checkCreatePortal(ritualStone)) {
                world.func_147449_b(x, y + 1, z, ModBlocks.blockDemonPortal);
                TEDemonPortal portal = (TEDemonPortal)world.func_147438_o(x, y + 1, z);
                portal.start();
                ritualStone.setActive(false);
            }
            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
        }
    }

    public boolean checkCreatePortal(IMasterRitualStone ritualStone) {
        IBloodAltar altar;
        TileEntity entity = ritualStone.getWorld().func_147438_o(ritualStone.getXCoord(), ritualStone.getYCoord() + 1, ritualStone.getZCoord());
        return entity instanceof IBloodAltar && (altar = (IBloodAltar)entity).hasDemonBlood() && ritualStone.getWorld().func_147437_c(ritualStone.getXCoord(), ritualStone.getYCoord() + 2, ritualStone.getZCoord());
    }

    @Override
    public int getCostPerRefresh() {
        return 0;
    }

    public void createRandomLightning(World world, int x, int y, int z) {
        world.func_72942_c((Entity)new EntityLightningBolt(world, (double)(x + rand.nextInt(10) - rand.nextInt(10)), (double)(y + 1), (double)(z + rand.nextInt(10) - rand.nextInt(10))));
    }

    @Override
    public boolean startRitual(IMasterRitualStone ritualStone, EntityPlayer player) {
        if (!this.checkJars(ritualStone)) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("message.ritualdemonportal.missingjar", new Object[0]));
            return false;
        }
        return true;
    }

    public boolean checkJars(IMasterRitualStone ritualStone) {
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        for (Int3 pos : jarLocations) {
            if (ritualStone.getWorld().func_147438_o(x + pos.xCoord, y + pos.yCoord, z + pos.zCoord) instanceof TEBellJar) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> demonRitual = new ArrayList<RitualComponent>();
        this.addParallelRunes(demonRitual, 3, 0, 2);
        this.addParallelRunes(demonRitual, 5, 0, 2);
        this.addCornerRunes(demonRitual, 2, 0, 4);
        this.addCornerRunes(demonRitual, 3, 0, 5);
        this.addOffsetRunes(demonRitual, 3, 4, 0, 4);
        this.addCornerRunes(demonRitual, 4, 1, 0);
        this.addCornerRunes(demonRitual, 4, 2, 3);
        this.addCornerRunes(demonRitual, 4, 3, 3);
        this.addCornerRunes(demonRitual, 4, 4, 5);
        this.addParallelRunes(demonRitual, 6, 1, 0);
        this.addParallelRunes(demonRitual, 6, 2, 1);
        this.addParallelRunes(demonRitual, 6, 3, 1);
        this.addParallelRunes(demonRitual, 6, 4, 5);
        this.addOffsetRunes(demonRitual, 2, 6, 1, 2);
        this.addOffsetRunes(demonRitual, 2, 7, 1, 0);
        this.addOffsetRunes(demonRitual, 2, 8, 1, 2);
        this.addOffsetRunes(demonRitual, 2, 9, 1, 0);
        this.addOffsetRunes(demonRitual, 1, 9, 1, 4);
        this.addParallelRunes(demonRitual, 9, 2, 5);
        this.addCornerRunes(demonRitual, 6, 3, 0);
        this.addOffsetRunes(demonRitual, 6, 7, 3, 0);
        this.addOffsetRunes(demonRitual, 5, 7, 3, 4);
        this.addOffsetRunes(demonRitual, 4, 7, 3, 4);
        return demonRitual;
    }
}

