/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;

public class SigilOfGrowth
extends EnergyItems
implements ArmourUpgrade,
ISigil {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;
    private int tickDelay = 100;

    public SigilOfGrowth() {
        this.field_77777_bU = 1;
        this.setEnergyUsed(150);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.sigilofgrowth.desc1"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.sigilofgrowth.desc2"));
        if (par1ItemStack.func_77978_p() != null) {
            if (par1ItemStack.func_77978_p().func_74767_n("isActive")) {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.state.activated"));
            } else {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.state.deactivated"));
            }
            par3List.add(StatCollector.func_74838_a((String)"tooltip.owner.currentowner") + " " + par1ItemStack.func_77978_p().func_74779_i("ownerName"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:GrowthSigil_deactivated");
        this.activeIcon = iconRegister.func_94245_a("AlchemicalWizardry:GrowthSigil_activated");
        this.passiveIcon = iconRegister.func_94245_a("AlchemicalWizardry:GrowthSigil_deactivated");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tag;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tag = stack.func_77978_p()).func_74767_n("isActive")) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (par1 == 1) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        if (EnergyItems.checkAndSetItemOwner(par1ItemStack, par2EntityPlayer) && SigilOfGrowth.applyBonemeal(par1ItemStack, par3World, par4, par5, par6, par2EntityPlayer)) {
            EnergyItems.syphonBatteries(par1ItemStack, par2EntityPlayer, this.getEnergyUsed());
            if (par3World.field_72995_K) {
                par3World.func_72926_e(2005, par4, par5, par6, 0);
                return true;
            }
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        NBTTagCompound tag;
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.func_70093_af()) {
            return par1ItemStack;
        }
        if (par2World.field_72995_K) {
            return par1ItemStack;
        }
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        tag.func_74757_a("isActive", !(tag = par1ItemStack.func_77978_p()).func_74767_n("isActive"));
        if (tag.func_74767_n("isActive") && EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, this.getEnergyUsed())) {
            par1ItemStack.func_77964_b(1);
            tag.func_74768_a("worldTimeDelay", (int)(par2World.func_72820_D() - 1L) % this.tickDelay);
        } else {
            par1ItemStack.func_77964_b(par1ItemStack.func_77958_k());
        }
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer) || par2World.field_72995_K) {
            return;
        }
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        if (par1ItemStack.func_77978_p().func_74767_n("isActive")) {
            if (par2World.func_72820_D() % (long)this.tickDelay == (long)par1ItemStack.func_77978_p().func_74762_e("worldTimeDelay") && !EnergyItems.syphonBatteries(par1ItemStack, (EntityPlayer)par3Entity, this.getEnergyUsed())) {
                par1ItemStack.func_77978_p().func_74757_a("isActive", false);
            }
            int range = 3;
            int verticalRange = 2;
            int posX = (int)Math.round(par3Entity.field_70165_t - 0.5);
            int posY = (int)par3Entity.field_70163_u;
            int posZ = (int)Math.round(par3Entity.field_70161_v - 0.5);
            for (int ix = posX - range; ix <= posX + range; ++ix) {
                for (int iz = posZ - range; iz <= posZ + range; ++iz) {
                    for (int iy = posY - verticalRange; iy <= posY + verticalRange; ++iy) {
                        Block block = par2World.func_147439_a(ix, iy, iz);
                        if (!(block instanceof IPlantable) && !(block instanceof IGrowable) || par2World.field_73012_v.nextInt(50) != 0) continue;
                        block.func_149674_a(par2World, ix, iy, iz, par2World.field_73012_v);
                    }
                }
            }
        }
    }

    public static boolean applyBonemeal(ItemStack p_150919_0_, World p_150919_1_, int p_150919_2_, int p_150919_3_, int p_150919_4_, EntityPlayer player) {
        IGrowable igrowable;
        Block block = p_150919_1_.func_147439_a(p_150919_2_, p_150919_3_, p_150919_4_);
        BonemealEvent event = new BonemealEvent(player, p_150919_1_, block, p_150919_2_, p_150919_3_, p_150919_4_);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        if (block instanceof IGrowable && (igrowable = (IGrowable)block).func_149851_a(p_150919_1_, p_150919_2_, p_150919_3_, p_150919_4_, p_150919_1_.field_72995_K)) {
            if (!p_150919_1_.field_72995_K && igrowable.func_149852_a(p_150919_1_, p_150919_1_.field_73012_v, p_150919_2_, p_150919_3_, p_150919_4_)) {
                igrowable.func_149853_b(p_150919_1_, p_150919_1_.field_73012_v, p_150919_2_, p_150919_3_, p_150919_4_);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onArmourUpdate(World world, EntityPlayer player, ItemStack thisItemStack) {
        if (world.field_72995_K) {
            return;
        }
        int range = 5;
        int verticalRange = 2;
        int posX = (int)Math.round(player.field_70165_t - 0.5);
        int posY = (int)player.field_70163_u;
        int posZ = (int)Math.round(player.field_70161_v - 0.5);
        for (int ix = posX - range; ix <= posX + range; ++ix) {
            for (int iz = posZ - range; iz <= posZ + range; ++iz) {
                for (int iy = posY - verticalRange; iy <= posY + verticalRange; ++iy) {
                    Block block = world.func_147439_a(ix, iy, iz);
                    if (!(block instanceof IPlantable) || world.field_73012_v.nextInt(100) != 0) continue;
                    block.func_149674_a(world, ix, iy, iz, world.field_73012_v);
                }
            }
        }
    }

    @Override
    public boolean isUpgrade() {
        return true;
    }

    @Override
    public int getEnergyForTenSeconds() {
        return 50;
    }
}

