/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.api.tileentity.ISortingMember;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingInventoryHandler;
import com.dynious.refinedrelocation.helper.DirectionHelper;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.tileentity.TileSortingConnector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSortingInterface
extends TileSortingConnector
implements ISortingInventory,
IFilterTileGUI {
    public ItemStack[] bufferInventory = new ItemStack[1];
    private ISortingInventoryHandler sortingHandler = APIUtils.createSortingInventoryHandler(this);
    private IFilterGUI filter = APIUtils.createStandardFilter(this);
    private boolean isStuffed = false;
    private int counter;
    private ForgeDirection connectedSide = ForgeDirection.UNKNOWN;
    private ISortingInventory.Priority priority = ISortingInventory.Priority.NORMAL;

    @Override
    public boolean onActivated(EntityPlayer player, int side) {
        if (!this.field_145850_b.field_72995_K) {
            APIUtils.openFilteringGUI(player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public ISortingInventoryHandler getHandler() {
        return this.sortingHandler;
    }

    @Override
    public ItemStack putInInventory(ItemStack itemStack, boolean simulate) {
        TileEntity tile;
        if (!(this.connectedSide == ForgeDirection.UNKNOWN || (tile = DirectionHelper.getTileAtSide((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.connectedSide)) == null || tile instanceof ISortingMember || (itemStack = IOHelper.insert(tile, itemStack, this.connectedSide.getOpposite(), simulate)) != null && itemStack.field_77994_a != 0)) {
            return null;
        }
        return itemStack;
    }

    @Override
    public final boolean putStackInSlot(ItemStack itemStack, int slotIndex) {
        this.bufferInventory[0] = itemStack = this.putInInventory(itemStack, false);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public ISortingInventory.Priority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(ISortingInventory.Priority priority) {
        this.priority = priority;
    }

    @Override
    public IFilterGUI getFilter() {
        return this.filter;
    }

    @Override
    public void onFilterChanged() {
        this.func_70296_d();
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.bufferInventory[0] != null) {
            ++this.counter;
            if (this.counter % 22 == 0) {
                this.bufferInventory[0] = this.putInInventory(this.bufferInventory[0], false);
                if (this.bufferInventory[0] == null) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
    }

    public boolean isStuffed() {
        return this.isStuffed;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return this.bufferInventory[i];
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            this.func_70299_a(slotIndex, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.sortingHandler.setInventorySlotContents(slotIndex, itemStack);
    }

    public String func_145825_b() {
        return "sortingInterface";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.bufferInventory[0] == null;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.filter.readFromNBT(compound);
        this.setConnectedSide(ForgeDirection.getOrientation((int)compound.func_74771_c("side")));
        if (compound.func_74764_b("priority")) {
            this.setPriority(ISortingInventory.Priority.values()[compound.func_74771_c("priority")]);
        } else {
            this.setPriority(this.filter.isBlacklisting() ? ISortingInventory.Priority.LOW : ISortingInventory.Priority.NORMAL);
        }
        if (compound.func_74764_b("Items")) {
            NBTTagList tagList = compound.func_150295_c("Items", 10);
            this.bufferInventory[0] = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(0));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.filter.writeToNBT(compound);
        compound.func_74774_a("side", (byte)this.connectedSide.ordinal());
        compound.func_74774_a("priority", (byte)this.priority.ordinal());
        if (this.bufferInventory[0] != null) {
            NBTTagList nbttaglist = new NBTTagList();
            NBTTagCompound tag = new NBTTagCompound();
            this.bufferInventory[0].func_77955_b(tag);
            nbttaglist.func_74742_a((NBTBase)tag);
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.setConnectedSide(ForgeDirection.getOrientation((int)pkt.func_148857_g().func_74771_c("side")));
        this.isStuffed = pkt.func_148857_g().func_74767_n("stuffed");
    }

    @Override
    public Packet func_145844_m() {
        S35PacketUpdateTileEntity pkt = (S35PacketUpdateTileEntity)super.func_145844_m();
        NBTTagCompound tag = pkt.field_148860_e;
        tag.func_74774_a("side", (byte)this.connectedSide.ordinal());
        tag.func_74757_a("stuffed", this.bufferInventory[0] != null);
        return pkt;
    }

    public boolean rotateBlock() {
        this.setConnectedSide(ForgeDirection.getOrientation((int)((this.connectedSide.ordinal() + 1) % ForgeDirection.VALID_DIRECTIONS.length)));
        return true;
    }

    public ForgeDirection getConnectedSide() {
        return this.connectedSide;
    }

    public void setConnectedSide(ForgeDirection direction) {
        this.connectedSide = direction;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

