/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingInventoryHandler;
import com.dynious.refinedrelocation.block.BlockSortingChest;
import com.dynious.refinedrelocation.container.ContainerSortingChest;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSortingChest
extends TileEntity
implements ISortingInventory,
IFilterTileGUI {
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    public int ticksSinceSync;
    public ItemStack[] inventory;
    private int facing;
    private IFilterGUI filter = APIUtils.createStandardFilter(this);
    private boolean blacklist = true;
    private ISortingInventoryHandler sortingInventoryHandler = APIUtils.createSortingInventoryHandler(this);
    private boolean isFirstTick = true;
    private ISortingInventory.Priority priority = ISortingInventory.Priority.NORMAL;

    public TileSortingChest() {
        this.inventory = new ItemStack[this.func_70302_i_()];
    }

    public int func_70302_i_() {
        return 27;
    }

    public String func_145825_b() {
        return "container.sortingChest.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.inventory[par1] != null) {
            if (this.inventory[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.inventory[par1];
                this.inventory[par1] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.inventory[par1].func_77979_a(par2);
            if (this.inventory[par1].field_77994_a == 0) {
                this.inventory[par1] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.inventory[par1] != null) {
            ItemStack itemstack = this.inventory[par1];
            this.inventory[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.sortingInventoryHandler.setInventorySlotContents(i, itemstack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145845_h() {
        float f;
        if (this.isFirstTick) {
            this.sortingInventoryHandler.onTileAdded();
            this.isFirstTick = false;
        }
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numUsingPlayers = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - f), (double)((float)this.field_145848_d - f), (double)((float)this.field_145849_e - f), (double)((float)(this.field_145851_c + 1) + f), (double)((float)(this.field_145848_d + 1) + f), (double)((float)(this.field_145849_e + 1) + f)));
            for (Object aList : list) {
                IInventory iinventory;
                EntityPlayer entityplayer = (EntityPlayer)aList;
                if (!(entityplayer.field_71070_bA instanceof ContainerSortingChest) || (iinventory = ((ContainerSortingChest)entityplayer.field_71070_bA).getLowerChestInventory()) != this) continue;
                ++this.numUsingPlayers;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.field_145851_c + 0.5;
            double d0 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d0, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d0 = (double)this.field_145851_c + 0.5;
                double d2 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d0, (double)this.field_145848_d + 0.5, d2, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int facing) {
        this.facing = facing;
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1) {
            this.numUsingPlayers = par2;
            return true;
        }
        if (par1 == 2) {
            this.facing = par2;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.facing = pkt.func_148857_g().func_74771_c("facing");
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("facing", (byte)this.facing);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void func_70295_k_() {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
    }

    public void func_70305_f() {
        if (this.func_145838_q() != null && this.func_145838_q() instanceof BlockSortingChest) {
            --this.numUsingPlayers;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        }
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.filter.readFromNBT(compound);
        this.blacklist = compound.func_74767_n("blacklist");
        this.facing = compound.func_74771_c("facing");
        if (compound.func_74764_b("priority")) {
            this.setPriority(ISortingInventory.Priority.values()[compound.func_74771_c("priority")]);
        } else {
            this.setPriority(this.filter.isBlacklisting() ? ISortingInventory.Priority.LOW : ISortingInventory.Priority.NORMAL);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        this.filter.writeToNBT(compound);
        compound.func_74757_a("blacklist", this.blacklist);
        compound.func_74774_a("facing", (byte)this.facing);
        compound.func_74774_a("priority", (byte)this.priority.ordinal());
    }

    public void func_145843_s() {
        this.sortingInventoryHandler.onTileRemoved();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.sortingInventoryHandler.onTileRemoved();
        super.onChunkUnload();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.getHandler().onInventoryChange();
    }

    @Override
    public final boolean putStackInSlot(ItemStack itemStack, int slotIndex) {
        if (slotIndex >= 0 && slotIndex < this.inventory.length) {
            this.inventory[slotIndex] = itemStack;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack putInInventory(ItemStack itemStack, boolean simulate) {
        int emptySlot = -1;
        for (int slot = 0; slot < this.func_70302_i_() && itemStack != null && itemStack.field_77994_a > 0; ++slot) {
            int max;
            if (!this.func_94041_b(slot, itemStack)) continue;
            ItemStack itemstack1 = this.func_70301_a(slot);
            if (itemstack1 == null) {
                if (simulate) {
                    return null;
                }
                if (emptySlot != -1) continue;
                emptySlot = slot;
                continue;
            }
            if (!ItemStackHelper.areItemStacksEqual(itemstack1, itemStack) || (max = Math.min(itemStack.func_77976_d(), this.func_70297_j_())) <= itemstack1.field_77994_a) continue;
            int l = Math.min(itemStack.field_77994_a, max - itemstack1.field_77994_a);
            itemStack.field_77994_a -= l;
            if (simulate) continue;
            itemstack1.field_77994_a += l;
            this.func_70296_d();
        }
        if (itemStack != null && itemStack.field_77994_a != 0 && emptySlot != -1) {
            this.inventory[emptySlot] = itemStack;
            itemStack = null;
            this.func_70296_d();
        }
        return itemStack;
    }

    @Override
    public IFilterGUI getFilter() {
        return this.filter;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public void onFilterChanged() {
        this.func_70296_d();
    }

    @Override
    public ISortingInventory.Priority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(ISortingInventory.Priority priority) {
        this.priority = priority;
    }

    @Override
    public ISortingInventoryHandler getHandler() {
        return this.sortingInventoryHandler;
    }

    public void rotateAround(ForgeDirection axis) {
        this.setFacing((byte)ForgeDirection.getOrientation((int)this.facing).getRotation(axis).ordinal());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

