/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.mods.waila;

import codechicken.multipart.TileMultipart;
import com.dynious.refinedrelocation.api.relocator.IRelocatorModule;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleRegistry;
import com.dynious.refinedrelocation.grid.relocator.RelocatorMultiModule;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.dynious.refinedrelocation.lib.Mods;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.IRelocator;
import com.dynious.refinedrelocation.tileentity.TileRelocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.text.WordUtils;

public class RelocatorHUDHandler
implements IWailaDataProvider {
    public static final int TICKS_BETWEEN_STUFFED_ITEM_UPDATE = 5;
    private static final int TICKS_BETWEEN_ITEM_CHANGE = 20;
    public static int tick = 0;
    public static ArrayList<ItemStack> stuffedItems = null;
    private int currentStackShown = 0;

    public static void addStack(ArrayList<ItemStack> stacks, ItemStack stack) {
        boolean stacksContains = false;
        for (ItemStack needleStack : stacks) {
            if (!ItemStackHelper.areItemStacksEqual(needleStack, stack)) continue;
            needleStack.field_77994_a += stack.field_77994_a;
            stacksContains = true;
        }
        if (!stacksContains) {
            stacks.add(stack);
        }
    }

    public ItemStack getWailaStack(IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        if (!(iWailaDataAccessor.getTileEntity() instanceof IRelocator)) {
            return null;
        }
        if (tick >= 20) {
            ++this.currentStackShown;
            tick = 0;
        }
        if (tick <= 20) {
            IRelocator relocator = this.getTileEntity(iWailaDataAccessor);
            int side = iWailaDataAccessor.getPosition().subHit;
            if (side >= 6 || relocator == null) {
                return null;
            }
            int stackAmount = this.getItemStacks(iWailaDataAccessor, side).size();
            if (this.currentStackShown > stackAmount) {
                this.currentStackShown = 0;
            }
            if (this.currentStackShown == stackAmount) {
                return null;
            }
            return this.getItemStacks(iWailaDataAccessor, side).get(this.currentStackShown);
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> strings, IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        return strings;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> strings, IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        int side = iWailaDataAccessor.getPosition().subHit;
        if (side >= 6 || !(iWailaDataAccessor.getTileEntity() instanceof IRelocator)) {
            return strings;
        }
        NBTTagList moduleList = this.getModuleTagList(iWailaDataAccessor);
        if (moduleList != null) {
            ArrayList<String> allModuleInformation = new ArrayList<String>();
            for (int i = 0; i < moduleList.func_74745_c(); ++i) {
                NBTTagCompound moduleCompound = moduleList.func_150305_b(i);
                if (moduleCompound.func_74771_c("place") != side) continue;
                IRelocatorModule module = RelocatorModuleRegistry.getModule(moduleCompound.func_74779_i("clazzIdentifier"));
                if (module instanceof RelocatorMultiModule) {
                    allModuleInformation.add(module.getDisplayName());
                    List<List<String>> moduleInformationList = ((RelocatorMultiModule)module).getModuleInformation(moduleCompound);
                    for (List<String> moduleInformation : moduleInformationList) {
                        this.addModuleInformation(allModuleInformation, moduleInformation);
                    }
                    continue;
                }
                List<String> moduleInformation = module.getWailaInformation(moduleList.func_150305_b(i));
                allModuleInformation.add(module.getDisplayName());
                this.addModuleInformation(allModuleInformation, moduleInformation);
            }
            strings.addAll(allModuleInformation);
        }
        ArrayList<String> stuffedStrings = new ArrayList<String>();
        for (ItemStack stack : this.getItemStacks(iWailaDataAccessor, side)) {
            String modifier = "";
            if (ItemStackHelper.areItemStacksEqual(itemStack, stack)) {
                modifier = modifier + EnumChatFormatting.UNDERLINE;
            }
            stuffedStrings.add(modifier + stack.func_82833_r() + " x " + stack.field_77994_a + EnumChatFormatting.RESET);
        }
        for (int i = 0; i < stuffedStrings.size(); ++i) {
            String finalString = "";
            if (i == 0) {
                finalString = finalString + StatCollector.func_74838_a((String)Strings.RELOCATOR_STUFFED) + " ";
            }
            strings.add(finalString + SpecialChars.TAB + SpecialChars.ALIGNRIGHT + (String)stuffedStrings.get(i));
        }
        return strings;
    }

    private void addModuleInformation(List<String> strings, List<String> moduleInformation) {
        for (String wailaLine : moduleInformation) {
            if (wailaLine.isEmpty()) continue;
            String[] indentedLines = WordUtils.wrap((String)wailaLine, (int)40, (String)"\n", (boolean)true).split("\\n");
            for (int j = 0; j < indentedLines.length; ++j) {
                indentedLines[j] = SpecialChars.TAB + indentedLines[j];
            }
            Collections.addAll(strings, indentedLines);
        }
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> strings, IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        return strings;
    }

    private ArrayList<ItemStack> getItemStacks(IWailaDataAccessor iWailaDataAccessor, int side) {
        IRelocator relocator = this.getTileEntity(iWailaDataAccessor);
        if (!relocator.isStuffedOnSide(side)) {
            stuffedItems = new ArrayList();
        }
        if (stuffedItems != null) {
            return stuffedItems;
        }
        NBTTagCompound compound = this.getCompound(iWailaDataAccessor);
        if (compound != null) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            if (compound.func_74764_b("StuffedItems")) {
                NBTTagList nbttaglist = compound.func_150295_c("StuffedItems", 10);
                for (int x = 0; x < nbttaglist.func_74745_c(); ++x) {
                    NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(x);
                    byte stackSide = nbttagcompound1.func_74771_c("Side");
                    if (stackSide != side) continue;
                    RelocatorHUDHandler.addStack(itemStacks, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
                }
            }
            stuffedItems = itemStacks;
            return itemStacks;
        }
        return new ArrayList<ItemStack>();
    }

    private NBTTagCompound getCompound(IWailaDataAccessor iWailaDataAccessor) {
        int side = iWailaDataAccessor.getPosition().subHit;
        TileEntity tileentity = iWailaDataAccessor.getTileEntity();
        if (tileentity instanceof TileRelocator) {
            return iWailaDataAccessor.getNBTData();
        }
        if (Mods.IS_FMP_LOADED && tileentity instanceof TileMultipart) {
            if (!iWailaDataAccessor.getNBTData().func_74764_b("parts")) {
                return null;
            }
            if (side < 6) {
                NBTTagList parts = iWailaDataAccessor.getNBTData().func_150295_c("parts", 10);
                for (int i = 0; i < parts.func_74745_c(); ++i) {
                    NBTTagCompound subtag = parts.func_150305_b(i);
                    String id = subtag.func_74779_i("id");
                    if (!id.contains("tile.relocator")) continue;
                    return subtag.func_74775_l("relocator");
                }
            }
        }
        return null;
    }

    private NBTTagList getModuleTagList(IWailaDataAccessor iWailaDataAccessor) {
        NBTTagCompound relocatorCompound = this.getCompound(iWailaDataAccessor);
        if (relocatorCompound != null) {
            return relocatorCompound.func_150295_c("modules", 10);
        }
        return null;
    }

    IRelocator getTileEntity(IWailaDataAccessor iWailaDataAccessor) {
        TileEntity tileentity = iWailaDataAccessor.getTileEntity();
        if (tileentity instanceof IRelocator) {
            return (IRelocator)tileentity;
        }
        return null;
    }
}

