/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.mods.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.PartMap;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import com.dynious.refinedrelocation.api.relocator.IRelocatorModule;
import com.dynious.refinedrelocation.client.renderer.RendererRelocator;
import com.dynious.refinedrelocation.grid.relocator.TravellingItem;
import com.dynious.refinedrelocation.lib.RelocatorData;
import com.dynious.refinedrelocation.mods.FMPHelper;
import com.dynious.refinedrelocation.tileentity.IRelocator;
import com.dynious.refinedrelocation.tileentity.TileRelocator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;

public class PartRelocator
extends JCuboidPart
implements IRelocator,
ISidedInventory,
JNormalOcclusion,
TSlottedPart,
IRedstonePart {
    public static final String RELOCATOR_TYPE = "tile.relocator";
    private TileRelocator relocator;

    public PartRelocator(TileRelocator tile) {
        this.relocator = tile;
    }

    public PartRelocator() {
        this(new TileRelocator());
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        this.initRelocator();
    }

    public Cuboid6 getBounds() {
        return RelocatorData.middleCuboid;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        ArrayList<IndexedCuboid6> list = new ArrayList<IndexedCuboid6>();
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (!this.relocator.connectsToSide(i)) continue;
            list.add(new IndexedCuboid6((Object)i, RelocatorData.sideCuboids[i]));
        }
        list.add(new IndexedCuboid6((Object)6, RelocatorData.middleCuboid));
        return list;
    }

    public String getType() {
        return RELOCATOR_TYPE;
    }

    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.initRelocator();
        this.relocator.onBlocksChanged();
    }

    public void onPartChanged(TMultiPart part) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.relocator.onBlocksChanged();
        }
    }

    public Iterable<ItemStack> getDrops() {
        List<ItemStack> items = this.relocator.getDrops();
        items.add(new ItemStack(FMPHelper.partRelocator));
        return items;
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack(FMPHelper.partRelocator);
    }

    public void update() {
        super.update();
        this.relocator.func_145845_h();
    }

    public void initRelocator() {
        if (this.relocator.func_145831_w() == null) {
            this.relocator.func_145834_a(this.world());
            this.relocator.field_145851_c = this.x();
            this.relocator.field_145848_d = this.y();
            this.relocator.field_145849_e = this.z();
            this.relocator.func_145829_t();
        }
    }

    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            RendererRelocator.instance.func_147500_a(this.relocator, pos.x, pos.y, pos.z, frame);
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        return this.relocator.onActivated(player, hit, item);
    }

    public void click(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        if (hit != null) {
            this.relocator.leftClick(player, hit, player.func_70694_bm());
        }
        super.click(player, hit, item);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        ArrayList<Cuboid6> list = new ArrayList<Cuboid6>();
        list.add(RelocatorData.middleCuboid);
        return list;
    }

    public boolean occlusionTest(TMultiPart part) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)part);
    }

    public int getSlotMask() {
        return PartMap.CENTER.mask;
    }

    public int strongPowerLevel(int i) {
        return this.relocator.isProvidingStrongPower(i);
    }

    public int weakPowerLevel(int i) {
        return this.strongPowerLevel(i);
    }

    public boolean canConnectRedstone(int i) {
        return this.relocator.shouldConnectToRedstone();
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        NBTTagCompound compound = new NBTTagCompound();
        this.relocator.func_145841_b(compound);
        tag.func_74782_a("relocator", (NBTBase)compound);
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.relocator.func_145839_a(tag.func_74775_l("relocator"));
    }

    public void writeDesc(MCDataOutput packet) {
        S35PacketUpdateTileEntity p = (S35PacketUpdateTileEntity)this.relocator.func_145844_m();
        packet.writeNBTTagCompound(p.field_148860_e);
    }

    public void readDesc(MCDataInput packet) {
        this.relocator.onDataPacket(null, new S35PacketUpdateTileEntity(0, 0, 0, 0, packet.readNBTTagCompound()));
    }

    @Override
    public TileEntity[] getConnectedInventories() {
        return this.relocator.getConnectedInventories();
    }

    @Override
    public IRelocator[] getConnectedRelocators() {
        return this.relocator.getConnectedRelocators();
    }

    @Override
    public boolean canConnectOnSide(int side) {
        return this.tile().canAddPart((TMultiPart)new NormallyOccludedPart(RelocatorData.sideCuboids[side]));
    }

    @Override
    public boolean connectsToSide(int side) {
        return this.relocator.connectsToSide(side);
    }

    @Override
    public boolean isStuffedOnSide(int side) {
        return this.relocator.isStuffedOnSide(side);
    }

    @Override
    public IRelocatorModule getRelocatorModule(int side) {
        return this.relocator.getRelocatorModule(side);
    }

    @Override
    public boolean getRedstoneState() {
        return this.relocator.getRedstoneState();
    }

    @Override
    public boolean passesFilter(ItemStack itemStack, int side, boolean input, boolean simulate) {
        return this.relocator.passesFilter(itemStack, side, input, simulate);
    }

    @Override
    public ItemStack insert(ItemStack itemStack, int side, boolean simulate) {
        return this.relocator.insert(itemStack, side, simulate);
    }

    @Override
    public void receiveTravellingItem(TravellingItem item) {
        this.relocator.receiveTravellingItem(item);
    }

    @Override
    public List<TravellingItem> getItems(boolean includeItemsToAdd) {
        return this.relocator.getItems(includeItemsToAdd);
    }

    @Override
    public TileEntity getTileEntity() {
        return this.relocator;
    }

    @Override
    public GuiScreen getGUI(int side, EntityPlayer player) {
        return this.relocator.getGUI(side, player);
    }

    @Override
    public Container getContainer(int side, EntityPlayer player) {
        return this.relocator.getContainer(side, player);
    }

    @Override
    public byte getRenderType() {
        return this.relocator.getRenderType();
    }

    @Override
    public ItemStack getItemStackWithId(byte id) {
        return this.relocator.getItemStackWithId(id);
    }

    public int[] func_94128_d(int var1) {
        return this.relocator.func_94128_d(var1);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.relocator.func_102007_a(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return this.relocator.func_102008_b(i, itemstack, j);
    }

    public int func_70302_i_() {
        return this.relocator.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.relocator.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.relocator.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.relocator.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.relocator.func_70299_a(i, itemstack);
    }

    public String func_145825_b() {
        return this.relocator.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.relocator.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.relocator.func_70297_j_();
    }

    public void func_70296_d() {
        this.relocator.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.relocator.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.relocator.func_70295_k_();
    }

    public void func_70305_f() {
        this.relocator.func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.relocator.func_94041_b(i, itemstack);
    }

    @Optional.Method(modid="CoFHAPI|transport")
    public ItemStack insertItem(ForgeDirection forgeDirection, ItemStack itemStack) {
        return this.insert(itemStack, forgeDirection.ordinal(), false);
    }
}

