/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.item;

import codechicken.lib.raytracer.RayTracer;
import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.lib.Mods;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Strings;
import ic2.api.item.ElectricItem;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ItemToolBox
extends Item {
    private static final String[] WRENCH_CLASS_NAMES = new String[]{"ic2.core.item.tool.ItemToolWrench", "ic2.core.item.tool.ItemToolMeter", "buildcraft.api.tools.IToolWrench", "appeng.api.implementations.items.IAEWrench", "thermalexpansion.item.tool.ItemWrench", "com.carpentersblocks.api.ICarpentersChisel", "com.carpentersblocks.api.ICarpentersHammer", "com.iconmaster.aec.item.ItemAetometer", "factorization.charge.ItemChargeMeter", "mekanism.common.item.ItemConfigurator", "mekanism.common.item.ItemNetworkReader", "mrtjp.projectred.api.IScrewdriver", "com.yogpc.qp.ItemTool", "redstonearsenal.item.tool.ItemWrenchRF", "redstonearsenal.item.tool.ItemWrenchBattleRF", "aroma1997.core.items.wrench.ItemWrench"};
    private static final List<Class<?>> WRENCH_CLASSES = new ArrayList();
    private static IIcon transparent;

    public ItemToolBox() {
        this.func_77655_b("toolbox");
        this.func_77637_a(RefinedRelocation.tabRefinedRelocation);
        this.func_77625_d(1);
        this.func_77642_a(this);
    }

    public static boolean isItemWrench(Item item) {
        for (Class<?> clazz : WRENCH_CLASSES) {
            if (!clazz.isAssignableFrom(item.getClass()) && !ArrayUtils.contains((Object[])item.getClass().getInterfaces(), clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesToolBoxContainWrench(NBTTagCompound toolBoxCompound, Item wrench) {
        NBTTagList list = toolBoxCompound.func_150295_c("wrenches", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)compound);
            if (stack.func_77973_b() != wrench) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getCurrentWrench(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagList list = stack.func_77978_p().func_150295_c("wrenches", 10);
            byte index = stack.func_77978_p().func_74771_c("index");
            if (list.func_74745_c() > index) {
                NBTTagCompound compound = list.func_150305_b((int)index);
                return ItemStack.func_77949_a((NBTTagCompound)compound);
            }
        }
        return null;
    }

    public static ArrayList<ItemStack> getWrenches(ItemStack stack) {
        if (stack.func_77942_o()) {
            ArrayList<ItemStack> wrenches = new ArrayList<ItemStack>();
            NBTTagList list = stack.func_77978_p().func_150295_c("wrenches", 10);
            for (int x = 0; x < list.func_74745_c(); ++x) {
                NBTTagCompound nbttagcompound1 = list.func_150305_b(x);
                wrenches.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
            }
            return wrenches;
        }
        return null;
    }

    public static void addWrenchAtIndex(ItemStack stack, ItemStack wrench, byte index) {
        NBTTagList list;
        if (wrench == null || wrench.field_77994_a == 0) {
            ItemToolBox.removeWrenchAtIndex(stack, index);
            return;
        }
        if (stack.func_77942_o() && (list = stack.func_77978_p().func_150295_c("wrenches", 10)).func_74745_c() > index) {
            NBTTagCompound compound = list.func_150305_b((int)index);
            wrench.func_77955_b(compound);
        }
    }

    public static void removeWrenchAtIndex(ItemStack stack, byte index) {
        NBTTagList list;
        if (stack.func_77942_o() && (list = stack.func_77978_p().func_150295_c("wrenches", 10)).func_74745_c() > index) {
            list.func_74744_a((int)index);
            index = (byte)(index - 1);
            if (index < 0) {
                index = 0;
            }
            stack.func_77978_p().func_74774_a("index", index);
        }
    }

    public static void addToolboxClass(Class clazz) {
        if (clazz != null && !WRENCH_CLASSES.contains(clazz)) {
            WRENCH_CLASSES.add(clazz);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition mop = RayTracer.reTrace((World)world, (EntityPlayer)player);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            if (!stack.func_77942_o()) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74782_a("wrenches", (NBTBase)new NBTTagList());
                compound.func_74774_a("index", (byte)0);
                stack.func_77982_d(compound);
            }
            if (player.func_70093_af()) {
                ArrayList<ItemStack> wrenches;
                ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
                for (int i = 0; i < mainInventory.length; ++i) {
                    ItemStack invStack = mainInventory[i];
                    if (invStack == null || !ItemToolBox.isItemWrench(invStack.func_77973_b()) || ItemToolBox.doesToolBoxContainWrench(stack.func_77978_p(), invStack.func_77973_b())) continue;
                    NBTTagList list = stack.func_77978_p().func_150295_c("wrenches", 10);
                    NBTTagCompound newTag = new NBTTagCompound();
                    ItemStack wrenchStack = invStack.func_77979_a(1);
                    wrenchStack.func_77955_b(newTag);
                    list.func_74742_a((NBTBase)newTag);
                    if (invStack.field_77994_a != 0) continue;
                    player.field_71071_by.func_70299_a(i, null);
                }
                byte index = stack.func_77978_p().func_74771_c("index");
                if ((index = (byte)(index + 1)) >= stack.func_77978_p().func_150295_c("wrenches", 10).func_74745_c()) {
                    index = 0;
                }
                stack.func_77978_p().func_74774_a("index", index);
                if (!world.field_72995_K && !(wrenches = ItemToolBox.getWrenches(stack)).isEmpty()) {
                    String wrenchText = StatCollector.func_74838_a((String)Strings.TOOLBOX_WRENCH_LIST_START) + " ";
                    for (int i = 0; i < wrenches.size(); ++i) {
                        ItemStack wrench = wrenches.get(i);
                        ItemStack currentWrench = ItemToolBox.getCurrentWrench(stack);
                        String modifier = wrench.func_77977_a().equals(currentWrench.func_77977_a()) ? "\u00a7a" : "";
                        wrenchText = wrenchText + modifier + StringUtils.join((Object[])wrench.func_82833_r().split(" "), (String)(" " + modifier)) + "\u00a7r";
                        wrenchText = i < wrenches.size() - 1 ? wrenchText + ", " : wrenchText + ".";
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText(wrenchText));
                }
            }
        }
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!stack.func_77942_o() || world.field_72995_K) {
            return false;
        }
        NBTTagCompound stackCompound = stack.func_77978_p();
        NBTTagList list = stackCompound.func_150295_c("wrenches", 10);
        byte index = stackCompound.func_74771_c("index");
        if (list.func_74745_c() > index) {
            NBTTagCompound compound = list.func_150305_b((int)index);
            ItemStack wrenchStack = ItemStack.func_77949_a((NBTTagCompound)compound);
            Block block = world.func_147439_a(x, y, z);
            if (block != null) {
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = wrenchStack;
                player.field_71069_bz.func_75142_b();
                if (!wrenchStack.func_77973_b().onItemUseFirst(wrenchStack, player, world, x, y, z, side, hitX, hitY, hitZ)) {
                    block.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
                }
                ItemToolBox.addWrenchAtIndex(stack, player.func_71045_bC(), index);
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = stack;
                player.field_71069_bz.func_75142_b();
                return true;
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        String[] info;
        ItemStack wrench = ItemToolBox.getCurrentWrench(stack);
        if (wrench != null) {
            String charge;
            String modName = Mods.IS_WAILA_LOADED ? " (" + SpecialChars.BLUE + SpecialChars.ITALIC + ModIdentification.nameFromStack((ItemStack)wrench) + SpecialChars.RESET + SpecialChars.GRAY + ")" : "";
            list.add(wrench.func_82833_r() + modName);
            wrench.func_77973_b().func_77624_a(wrench, player, list, bool);
            if (Mods.IS_IC2_LOADED && (charge = ElectricItem.manager.getToolTip(wrench)) != null) {
                list.add(charge);
            }
        }
        for (String line : info = StatCollector.func_74838_a((String)Strings.TOOLBOX_INFO).split("\\\\n")) {
            list.add("\u00a7f" + line);
        }
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack copiedStack = itemStack.func_77946_l();
        if (copiedStack.func_77942_o()) {
            NBTTagList list = copiedStack.func_77978_p().func_150295_c("wrenches", 10);
            byte index = copiedStack.func_77978_p().func_74771_c("index");
            if (list.func_74745_c() > index) {
                list.func_74744_a((int)index);
                index = (byte)(index - 1);
                if (index < 0) {
                    index = 0;
                }
                copiedStack.func_77978_p().func_74774_a("index", index);
            }
        }
        return copiedStack;
    }

    public int getDamage(ItemStack stack) {
        ItemStack wrench = ItemToolBox.getCurrentWrench(stack);
        return wrench == null ? super.getDamage(stack) : wrench.func_77973_b().getDamage(wrench);
    }

    public int getDisplayDamage(ItemStack stack) {
        ItemStack wrench = ItemToolBox.getCurrentWrench(stack);
        return wrench == null ? super.getDisplayDamage(stack) : wrench.func_77973_b().getDisplayDamage(wrench);
    }

    public int getMaxDamage(ItemStack stack) {
        ItemStack wrench = ItemToolBox.getCurrentWrench(stack);
        return wrench == null ? super.getMaxDamage(stack) : wrench.func_77973_b().getMaxDamage(wrench);
    }

    public boolean isDamaged(ItemStack stack) {
        ItemStack wrench = ItemToolBox.getCurrentWrench(stack);
        return wrench == null ? super.isDamaged(stack) : wrench.func_77973_b().isDamaged(wrench);
    }

    public void setDamage(ItemStack stack, int damage) {
        ItemStack wrench = ItemToolBox.getCurrentWrench(stack);
        if (wrench != null) {
            wrench.func_77973_b().setDamage(wrench, damage);
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        ItemStack wrench;
        if (pass == 0) {
            return this.field_77791_bV;
        }
        if (pass == 1 && (wrench = ItemToolBox.getCurrentWrench(stack)) != null) {
            return wrench.func_77973_b().getIcon(wrench, 0);
        }
        return transparent;
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(Resources.MOD_ID + ":" + "toolbox");
        transparent = register.func_94245_a(Resources.MOD_ID + ":" + "transparent");
    }

    static {
        for (String className : WRENCH_CLASS_NAMES) {
            try {
                WRENCH_CLASSES.add(Class.forName(className));
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
    }
}

