/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.item;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.IDisguisable;
import com.dynious.refinedrelocation.tileentity.TileWirelessBlockExtender;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemLinker
extends Item {
    private IIcon unlinkedIcon;
    private IIcon linkedIcon;

    public ItemLinker() {
        this.func_77655_b("linker");
        this.func_77637_a(RefinedRelocation.tabRefinedRelocation);
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (this.isLinked(stack)) {
            int x = stack.func_77978_p().func_74762_e("tileX");
            int y = stack.func_77978_p().func_74762_e("tileY");
            int z = stack.func_77978_p().func_74762_e("tileZ");
            list.add(StatCollector.func_74837_a((String)Strings.LINKED_POS, (Object[])new Object[]{x, y, z, BlockHelper.getBlockDisplayName(par2EntityPlayer.func_130014_f_(), x, y, z)}));
        } else {
            list.add(StatCollector.func_74838_a((String)Strings.UNLINKED));
        }
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof IDisguisable) {
            IDisguisable disguisable = (IDisguisable)tile;
            if (!disguisable.canDisguise()) {
                return false;
            }
            if (this.isLinked(itemStack)) {
                int linkedX = itemStack.func_77978_p().func_74762_e("tileX");
                int linkedY = itemStack.func_77978_p().func_74762_e("tileY");
                int linkedZ = itemStack.func_77978_p().func_74762_e("tileZ");
                int linkedBlockMetadata = world.func_72805_g(linkedX, linkedY, linkedZ);
                Block linkedBlock = world.func_147439_a(linkedX, linkedY, linkedZ);
                TileEntity linkedTile = world.func_147438_o(linkedX, linkedY, linkedZ);
                if (linkedTile != null && linkedTile instanceof IDisguisable) {
                    linkedBlock = ((IDisguisable)linkedTile).getDisguise();
                    linkedBlockMetadata = ((IDisguisable)linkedTile).getDisguiseMeta();
                }
                if (linkedBlock != null && disguisable.canDisguiseAs(linkedBlock, linkedBlockMetadata)) {
                    disguisable.setDisguise(linkedBlock, linkedBlockMetadata);
                    if (world.field_72995_K) {
                        entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.DISGUISED_AS, (Object[])new Object[]{BlockHelper.getBlockDisplayName(world, x, y, z), BlockHelper.getBlockDisplayName(linkedBlock, linkedBlockMetadata)})));
                    }
                } else if (world.field_72995_K) {
                    entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.CANNOT_DISGUISE_AS, (Object[])new Object[]{BlockHelper.getBlockDisplayName(world, linkedX, linkedY, linkedZ)})));
                }
            } else if (disguisable.getDisguise() != null) {
                disguisable.clearDisguise();
                if (world.field_72995_K) {
                    entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.UNDISGUISED) + " " + BlockHelper.getBlockDisplayName(world, x, y, z)));
                }
            } else {
                return false;
            }
            if (!world.field_72995_K) {
                return true;
            }
        }
        return false;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof TileWirelessBlockExtender) && (!(tile instanceof IDisguisable) || entityPlayer.func_70093_af())) {
            this.linkTileAtPosition(itemStack, x, y, z);
            if (world.field_72995_K) {
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.LINKER_SET, (Object[])new Object[]{x, y, z, BlockHelper.getBlockDisplayName(world, x, y, z)})));
            }
        }
        return true;
    }

    private void linkTileAtPosition(ItemStack stack, int x, int y, int z) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("tileX", x);
        stack.func_77978_p().func_74768_a("tileY", y);
        stack.func_77978_p().func_74768_a("tileZ", z);
    }

    private void unlink(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77982_d(null);
        }
    }

    public boolean isLinked(ItemStack stack) {
        return stack.func_77942_o();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer entityPlayer) {
        if (this.isLinked(stack)) {
            entityPlayer.func_71038_i();
            this.unlink(stack);
            if (world.field_72995_K) {
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.NO_LONGER_LINKED, (Object[])new Object[]{this.func_77653_i(stack)})));
            }
            return stack;
        }
        return super.func_77659_a(stack, world, entityPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = this.linkedIcon = par1IconRegister.func_94245_a(Resources.MOD_ID + ":" + "linker");
        this.unlinkedIcon = par1IconRegister.func_94245_a(Resources.MOD_ID + ":" + "linker" + "Unlinked");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    public IIcon func_77650_f(ItemStack stack) {
        return this.isLinked(stack) ? this.linkedIcon : this.unlinkedIcon;
    }
}

