/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.relocator.IItemRelocator;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleFilter;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.tileentity.TileRelocator;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class RelocatorModuleItemDetector
extends RelocatorModuleFilter {
    private static IIcon[] icons = new IIcon[4];
    private static boolean emitRedstoneSignal = false;
    private int tick = 0;

    @Override
    public void onUpdate(IItemRelocator relocator, int side) {
        if (this.tick > 0) {
            --this.tick;
            if (this.tick == 0) {
                emitRedstoneSignal = false;
                this.markRedstoneUpdate(relocator.getTileEntity());
            }
        }
        super.onUpdate(relocator, side);
    }

    @Override
    public int strongRedstonePower(int side) {
        return emitRedstoneSignal ? 15 : 0;
    }

    @Override
    public boolean connectsToRedstone() {
        return true;
    }

    @Override
    public boolean passesFilter(IItemRelocator relocator, int side, ItemStack stack, boolean input, boolean simulate) {
        if (!simulate && stack != null && super.passesFilter(relocator, side, stack, input, simulate)) {
            this.tick = 6;
            emitRedstoneSignal = true;
            this.markRedstoneUpdate(relocator.getTileEntity());
        }
        return true;
    }

    @Override
    public List<ItemStack> getDrops(IItemRelocator relocator, int side) {
        return Arrays.asList(new ItemStack((Item)ModItems.relocatorModule, 1, 9));
    }

    @Override
    public IIcon getIcon(IItemRelocator relocator, int side) {
        return emitRedstoneSignal ? icons[1] : icons[0];
    }

    @Override
    public void registerIcons(IIconRegister register) {
        RelocatorModuleItemDetector.icons[0] = register.func_94245_a(Resources.MOD_ID + ":" + "relocatorModuleItemDetector");
        RelocatorModuleItemDetector.icons[1] = register.func_94245_a(Resources.MOD_ID + ":" + "relocatorModuleItemDetectorDetected");
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"item.relocatorModule9.name");
    }

    private void markRedstoneUpdate(TileEntity relocator) {
        TileRelocator.markUpdateAndNotify(relocator.func_145831_w(), relocator.field_145851_c, relocator.field_145848_d, relocator.field_145849_e);
    }
}

