/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.config;

import com.dynious.refinedrelocation.lib.Settings;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static Configuration configFile;

    public static void init(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new ConfigHandler());
        configFile = new Configuration(event.getSuggestedConfigurationFile());
        ConfigHandler.syncConfig();
    }

    public static void syncConfig() {
        Settings.DISABLE_WIRELESS_BLOCK_EXTENDER = ConfigHandler.getConfiguration("Disable WBE", false, "Remove crafting recipe for Wireless Block Extender.");
        Settings.MAX_RANGE_WIRELESS_BLOCK_EXTENDER = ConfigHandler.getConfiguration("Max Range WBE", 16, "The maximum distance the Wireless Block Extender can connect to.");
        Settings.DISPLAY_VERSION_RESULT = ConfigHandler.getConfiguration("Check Version", true, "Show the version checker result on startup.");
        Settings.DISABLE_PLAYER_RELOCATOR = ConfigHandler.getConfiguration("Disable PR", false, "Remove crafting recipe for Player Relocator.");
        Settings.PLAYER_RELOCATOR_DISABLED_AGES = configFile.get("general", "Disabled Ages for PR", Settings.PLAYER_RELOCATOR_DISABLED_AGES_DEFAULT, "Ages from which the Player Relocator cannot teleport.").getIntList();
        Settings.PLAYER_RELOCATOR_COOLDOWN = ConfigHandler.getConfiguration("PR Cooldown Time", 600, "The Cooldown time between teleports using the Player Relocator, in seconds.");
        Settings.RELOCATOR_MIN_TICKS_BETWEEN_EXTRACTION = ConfigHandler.getConfiguration("Ticks between extractions", 10, "Minimum amount of time between Relocator extractions.");
        Settings.CRAFTING_MODULE_TICKS_BETWEEN_CRAFTING = ConfigHandler.getConfiguration("Ticks between crafting", 20, "Ticks between Crafting Module craft operations.");
        Settings.DISABLE_SORTING_TO_NORMAL = ConfigHandler.getConfiguration("Disable sorting to normal", false, "Disable sorting block to normal block downgrade recipe.");
        if (configFile.hasChanged()) {
            configFile.save();
        }
    }

    private static int getConfiguration(String setting, int defaultSetting, String comment) {
        return configFile.get("general", setting, defaultSetting, comment).getInt(defaultSetting);
    }

    private static boolean getConfiguration(String setting, boolean defaultSetting, String comment) {
        return configFile.get("general", setting, defaultSetting, comment).getBoolean(defaultSetting);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("RefinedRelocation")) {
            ConfigHandler.syncConfig();
        }
    }
}

