/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiWidgetBase;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessageInsertDirection;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import com.dynious.refinedrelocation.tileentity.TileAdvancedBuffer;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiInsertDirection
extends GuiWidgetBase {
    public static final int defaultSizeW = 16;
    public static final int defaultSizeH = 16;
    public ForgeDirection side;
    public ForgeDirection insertDirection;
    public ForgeDirection rotation;
    public ForgeDirection relativeSide;
    public boolean isConnected = false;
    protected IAdvancedTile tile;

    public GuiInsertDirection(IGuiParent parent, int x, int y, IAdvancedTile tile, ForgeDirection side, ForgeDirection relativeSide) {
        super(parent, x, y, 16, 16);
        this.relativeSide = relativeSide;
        this.side = side;
        this.tile = tile;
        this.insertDirection = ForgeDirection.getOrientation((int)tile.getInsertDirection()[side.ordinal()]);
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> tooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            TileEntity tile = (TileEntity)this.tile;
            tooltip.add(BlockHelper.getBlockDisplayName(tile.func_145831_w(), tile.field_145851_c + this.side.offsetX, tile.field_145848_d + this.side.offsetY, tile.field_145849_e + this.side.offsetZ, this.side));
            if (tile instanceof TileBlockExtender) {
                TileBlockExtender blockExtender = (TileBlockExtender)tile;
                boolean bl = this.isConnected = blockExtender.getConnectedDirection() == this.side;
                if (this.isConnected) {
                    String colorCode = "\u00a7";
                    String grayColor = colorCode + "7";
                    String yellowColor = colorCode + "e";
                    if (blockExtender.hasConnection()) {
                        tooltip.add(grayColor + StatCollector.func_74838_a((String)Strings.CONNECTED));
                        List<String> connections = blockExtender.getConnectionTypes();
                        for (int i = 0; i < connections.size(); ++i) {
                            connections.set(i, yellowColor + connections.get(i));
                        }
                        tooltip.addAll(connections);
                    } else {
                        tooltip.add(grayColor + StatCollector.func_74838_a((String)Strings.NOT_CONNECTED));
                    }
                }
            }
        }
        return tooltip;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        this.mc.func_110434_K().func_110577_a(Resources.GUI_SHARED);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FontRenderer fontRendererObj = this.mc.field_71466_p;
        boolean isHovered = this.isMouseInsideBounds(mouseX, mouseY);
        int textureOffset = (this.relativeSide != null ? this.relativeSide.ordinal() : this.side.ordinal()) + 1;
        if (this.tile instanceof TileBlockExtender) {
            TileBlockExtender blockExtender = (TileBlockExtender)((Object)this.tile);
            this.isConnected = blockExtender.getConnectedDirection() == this.side;
            boolean hasTile = blockExtender.getTiles()[this.side.ordinal()] != null;
            this.func_73729_b(this.x, this.y, this.isConnected ? 0 : textureOffset * this.w, 80 + (this.isConnected ? this.h * 2 : (isHovered ? this.h : (hasTile ? 0 : this.h * 2))), this.w, this.h);
            if (!this.isConnected) {
                this.insertDirection = ForgeDirection.getOrientation((int)this.tile.getInsertDirection()[this.side.ordinal()]);
                char letter = this.insertDirection.toString().charAt(0);
                fontRendererObj.func_85187_a(Character.toString(letter), this.x + this.w / 2 - fontRendererObj.func_78263_a(letter) / 2, this.y + this.h / 2 - fontRendererObj.field_78288_b / 2, hasTile || isHovered ? 0xFFFFFF : 0xAAAAAA, true);
            }
        } else if (this.tile instanceof TileAdvancedBuffer) {
            this.func_73729_b(this.x, this.y, this.isConnected ? 0 : textureOffset * this.w, 80 + (this.isConnected ? this.h * 2 : (isHovered ? this.h : 0)), this.w, this.h);
            TileAdvancedBuffer buffer = (TileAdvancedBuffer)this.tile;
            byte p = buffer.getPriority(this.side.ordinal());
            String priority = p == TileAdvancedBuffer.NULL_PRIORITY ? "--" : Byte.toString((byte)(p + 1));
            fontRendererObj.func_85187_a(priority, this.x + this.w / 2 - fontRendererObj.func_78256_a(priority) / 2, this.y + this.h / 2 - fontRendererObj.field_78288_b / 2, isHovered ? 0xFFFFFF : 0xAAAAAA, true);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if ((type == 0 || type == 1) && !this.isConnected && this.isMouseInsideBounds(mouseX, mouseY)) {
            byte step;
            if (this.tile instanceof TileBlockExtender) {
                step = (byte)(type == 0 ? 1 : -1);
                this.tile.setInsertDirection(this.side.ordinal(), this.tile.getInsertDirection()[this.side.ordinal()] + step);
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageInsertDirection((byte)this.side.ordinal(), this.tile.getInsertDirection()[this.side.ordinal()]));
            }
            if (this.tile instanceof TileAdvancedBuffer) {
                step = (byte)(type == 0 ? -1 : 1);
                if (isShiftKeyDown) {
                    step = (byte)(step * 6);
                }
                this.tile.setInsertDirection(this.side.ordinal(), this.tile.getInsertDirection()[this.side.ordinal()] + step);
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageInsertDirection((byte)this.side.ordinal(), this.tile.getInsertDirection()[this.side.ordinal()]));
            }
        }
    }
}

