/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButton;
import com.dynious.refinedrelocation.client.gui.widget.GuiWidgetBase;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiDisguise
extends GuiWidgetBase {
    protected GuiButton button;
    protected TileBlockExtender tile;

    public GuiDisguise(IGuiParent parent, int x, int y, int w, int h, TileBlockExtender tile) {
        super(parent, x, y, w, h);
        this.tile = tile;
        this.button = new GuiButton(this, x, y, w, h, 144, 112, null);
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> tooltip;
        block4: {
            tooltip = super.getTooltip(mouseX, mouseY);
            if (!this.isMouseInsideBounds(mouseX, mouseY)) break block4;
            if (this.tile.getDisguise() != null) {
                Block disguisedAs = this.tile.getDisguise();
                int meta = this.tile.blockDisguisedMetadata;
                ItemStack item = new ItemStack(disguisedAs, 0, meta);
                tooltip.add(StatCollector.func_74837_a((String)Strings.DISGUISED, (Object[])new Object[]{item.func_82833_r()}));
                for (String s : StatCollector.func_74838_a((String)Strings.DISGUISED_INFO).split("\\\\n")) {
                    tooltip.add("\u00a77" + s);
                }
            } else {
                tooltip.add(StatCollector.func_74838_a((String)Strings.UNDISGUISED));
                for (String s : StatCollector.func_74838_a((String)Strings.UNDISGUISED_INFO).split("\\\\n")) {
                    tooltip.add("\u00a77" + s);
                }
            }
        }
        return tooltip;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tile.getDisguise() != null) {
            Block disguisedAs = this.tile.getDisguise();
            int meta = this.tile.blockDisguisedMetadata;
            IIcon icon = disguisedAs.func_149691_a(this.tile.getConnectedDirection().ordinal(), meta);
            if (icon != null) {
                this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                this.func_94065_a(this.x, this.y, icon, this.w, this.h);
            }
        }
        if (this.tile.getDisguise() != null && this.isMouseInsideBounds(mouseX, mouseY)) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        super.drawBackground(mouseX, mouseY);
        GL11.glDisable((int)3042);
    }
}

