/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButtonCounter;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleExtraction;
import com.dynious.refinedrelocation.lib.Settings;
import com.dynious.refinedrelocation.lib.Strings;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonTicksBetweenExtractions
extends GuiButtonCounter {
    private static final DecimalFormat decimalFormat = new DecimalFormat("##.##");
    private RelocatorModuleExtraction module;

    public GuiButtonTicksBetweenExtractions(IGuiParent parent, int x, int y, RelocatorModuleExtraction module) {
        super(parent, x, y, 24, 20, 0, 0, Settings.RELOCATOR_MIN_TICKS_BETWEEN_EXTRACTION, Integer.MAX_VALUE, 1, 10);
        this.module = module;
        this.update();
    }

    @Override
    protected void onValueChangedByUser(double newValue) {
        if (this.module == null) {
            return;
        }
        this.module.setTicksBetweenExtraction((int)newValue);
        this.getContainer().sendMessage(0, (int)newValue);
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> subTooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            float seconds = (float)this.module.getTicksBetweenExtraction() / 20.0f;
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(StatCollector.func_74838_a((String)Strings.TICKS_BETWEEN_EXT));
            tooltip.add(decimalFormat.format(seconds) + " " + StatCollector.func_74838_a((String)Strings.SECONDS_BETWEEN_EXT));
            tooltip.addAll(subTooltip);
            return tooltip;
        }
        return subTooltip;
    }

    @Override
    public void update() {
        if (this.module != null) {
            this.setValue(this.module.getTicksBetweenExtraction());
        }
        super.update();
    }
}

