/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButtonToggle;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessageSpread;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import com.dynious.refinedrelocation.tileentity.TileBuffer;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonSpread
extends GuiButtonToggle {
    protected IAdvancedTile tile;

    public GuiButtonSpread(IGuiParent parent, int x, int y, IAdvancedTile tile) {
        super(parent, x, y, 24, 20, 48, 0, null, null);
        this.tile = tile;
        this.update();
    }

    @Override
    protected void onStateChangedByUser(boolean newState) {
        if (this.tile == null) {
            return;
        }
        this.tile.setSpreadItems(newState);
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageSpread(newState));
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> tooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            if (this.tile instanceof TileBuffer) {
                if (this.getState()) {
                    tooltip.add(StatCollector.func_74838_a((String)Strings.MODE) + ": " + StatCollector.func_74838_a((String)Strings.ROUND_ROBIN));
                    for (String s : StatCollector.func_74838_a((String)Strings.ROUND_ROBIN_INFO).split("\\\\n")) {
                        tooltip.add("\u00a77" + s);
                    }
                } else {
                    tooltip.add(StatCollector.func_74838_a((String)Strings.MODE) + ": " + StatCollector.func_74838_a((String)Strings.GREEDY));
                    for (String s : StatCollector.func_74838_a((String)Strings.GREEDY_INFO).split("\\\\n")) {
                        tooltip.add("\u00a77" + s);
                    }
                }
            } else {
                tooltip.add(StatCollector.func_74838_a((String)(this.getState() ? Strings.SPREAD : Strings.STACK)));
            }
        }
        return tooltip;
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setState(this.tile.getSpreadItems());
        }
        super.update();
    }
}

