/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButton;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleExtraction;
import com.dynious.refinedrelocation.lib.Strings;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonPulseExtractionToggle
extends GuiButton {
    private RelocatorModuleExtraction module;

    public GuiButtonPulseExtractionToggle(IGuiParent parent, int x, int y, RelocatorModuleExtraction module) {
        super(parent, x, y, 24, 20, 96, 0, null);
        this.module = module;
        this.update();
    }

    @Override
    public void update() {
        if (this.module != null) {
            this.setNewState(this.module.redstoneControlState, false);
        }
        super.update();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            if (type == 0) {
                this.setNewState(this.getNextControlState(), true);
            } else if (type == 1) {
                this.setNewState(this.getPreviousControlState(), true);
            }
        }
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
    }

    private int getNextControlState() {
        return this.module.redstoneControlState == 3 ? 0 : this.module.redstoneControlState + 1;
    }

    private int getPreviousControlState() {
        return this.module.redstoneControlState - 1 >= 0 ? this.module.redstoneControlState - 1 : 3;
    }

    protected void setNewState(int newState, boolean sendUpdate) {
        if (this.module == null) {
            return;
        }
        this.module.redstoneControlState = newState;
        if (sendUpdate) {
            this.getContainer().sendMessage(1, newState);
        }
        switch (this.module.redstoneControlState) {
            case 0: {
                this.textureX = 178;
                this.textureY = 0;
                break;
            }
            case 1: {
                this.textureX = 154;
                this.textureY = 40;
                break;
            }
            case 2: {
                this.textureX = 96;
                this.textureY = 40;
                break;
            }
            case 3: {
                this.textureX = 96;
                this.textureY = 0;
            }
        }
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> tooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            tooltip.add(StatCollector.func_74838_a((String)(Strings.MODULE_REDSTONE_CONTROL + this.module.redstoneControlState)));
        }
        return tooltip;
    }
}

