/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButton;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessagePriority;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonPriority
extends GuiButton {
    private ISortingInventory tile;

    public GuiButtonPriority(IGuiParent parent, ISortingInventory tile) {
        super(parent, "");
        this.tile = tile;
    }

    public GuiButtonPriority(IGuiParent parent, int x, int y, int w, int h, ISortingInventory tile) {
        super(parent, x, y, w, h, 0, 0, "");
        this.tile = tile;
    }

    public void setValue(ISortingInventory.Priority priority) {
        String text = "";
        switch (priority) {
            case HIGH: {
                text = "+";
                break;
            }
            case NORMAL_HIGH: {
                text = "0+";
                break;
            }
            case NORMAL: {
                text = "0";
                break;
            }
            case NORMAL_LOW: {
                text = "-0";
                break;
            }
            case LOW: {
                text = "-";
            }
        }
        this.label.setText(text);
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> subTooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(StatCollector.func_74838_a((String)Strings.PRIORITY) + ":");
            tooltip.add("\u00a77" + StatCollector.func_74838_a((String)this.tile.getPriority().name().replace('_', '-')));
            tooltip.addAll(subTooltip);
            return tooltip;
        }
        return subTooltip;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (this.isMouseInsideBounds(mouseX, mouseY) && (type == 0 || type == 1)) {
            int amount;
            int n = amount = type == 0 ? -1 : 1;
            if (this.tile.getPriority().ordinal() + amount >= 0 && this.tile.getPriority().ordinal() + amount < ISortingInventory.Priority.values().length) {
                ISortingInventory.Priority newPriority = ISortingInventory.Priority.values()[this.tile.getPriority().ordinal() + amount];
                this.tile.setPriority(newPriority);
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessagePriority(newPriority.ordinal()));
                this.setValue(newPriority);
            }
        }
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setValue(this.tile.getPriority());
        }
        super.update();
    }
}

