/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.block;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.lib.Mods;
import com.dynious.refinedrelocation.mods.EE3Helper;
import com.dynious.refinedrelocation.mods.IronChestHelper;
import com.dynious.refinedrelocation.tileentity.TileSortingChest;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSortingChest
extends BlockContainer {
    private final Random random = new Random();

    protected BlockSortingChest() {
        super(Material.field_151575_d);
        this.func_149711_c(3.0f);
        this.func_149647_a(RefinedRelocation.tabRefinedRelocation);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        this.func_149663_c("sortingChest");
    }

    public static boolean isOcelotBlockingChest(World par0World, int par1, int par2, int par3) {
        EntityOcelot entityocelot;
        Iterator iterator = par0World.func_72872_a(EntityOcelot.class, AxisAlignedBB.func_72330_a((double)par1, (double)(par2 + 1), (double)par3, (double)(par1 + 1), (double)(par2 + 2), (double)(par3 + 1))).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(entityocelot = (EntityOcelot)iterator.next()).func_70906_o());
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 22;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        TileEntity te;
        int chestFacing = 0;
        int facing = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (facing == 0) {
            chestFacing = 2;
        }
        if (facing == 1) {
            chestFacing = 5;
        }
        if (facing == 2) {
            chestFacing = 3;
        }
        if (facing == 3) {
            chestFacing = 4;
        }
        if ((te = par1World.func_147438_o(par2, par3, par4)) != null && te instanceof TileSortingChest) {
            TileSortingChest tile = (TileSortingChest)te;
            tile.setFacing(chestFacing);
            par1World.func_147471_g(par2, par3, par4);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldMetadata) {
        TileSortingChest tileEntityChest = (TileSortingChest)world.func_147438_o(x, y, z);
        if (tileEntityChest != null) {
            IOHelper.dropInventory(world, x, y, z);
            world.func_147453_f(x, y, z, oldBlock);
        }
        super.func_149749_a(world, x, y, z, oldBlock, oldMetadata);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        IInventory iinventory;
        if (Mods.IS_IRON_CHEST_LOADED && IronChestHelper.upgradeToIronChest(world, player, x, y, z)) {
            return true;
        }
        if (Mods.IS_EE3_LOADED && EE3Helper.upgradeToAlchemicalChest(world, player, x, y, z)) {
            return true;
        }
        if (!world.field_72995_K && (iinventory = this.getInventory(world, x, y, z)) != null) {
            if (!player.func_70093_af()) {
                GuiHelper.openGui(player, world.func_147438_o(x, y, z));
            } else {
                APIUtils.openFilteringGUI(player, world, x, y, z);
            }
        }
        return true;
    }

    public IInventory getInventory(World world, int x, int y, int z) {
        TileEntity object = world.func_147438_o(x, y, z);
        if (object == null) {
            return null;
        }
        if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            return null;
        }
        if (BlockSortingChest.isOcelotBlockingChest(world, x, y, z)) {
            return null;
        }
        return (IInventory)object;
    }

    public TileEntity func_149915_a(World par1World, int meta) {
        return new TileSortingChest();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("planks_oak");
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            TileEntity tileEntity = worldObj.func_147438_o(x, y, z);
            if (tileEntity instanceof TileSortingChest) {
                TileSortingChest sortingChest = (TileSortingChest)tileEntity;
                sortingChest.rotateAround(axis);
            }
            return true;
        }
        return false;
    }
}

